package com.ejianc.business.finance.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.foundation.support.api.ISupplierWebApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
@Component
public class MbsUtils {
	
	 @Autowired
	 private IOrgApi orgApi;

	 @Autowired
	 private IProjectApi projectApi;
	 
	 @Autowired
	 private ISupplierWebApi supplierWebApi;
    /**
     * 根据id查询组织
     * @param id
     * @return
     */
    public OrgVO queryOrgById(Long id){
        CommonResponse<OrgVO> resp = orgApi.detailById(id);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        return resp.getData();
    }

    /**
     * 根据id查询项目部上级组织
     * @return
     */
    public OrgVO queryParentOrgById(Long id){
        OrgVO org = this.queryOrgById(id);
        // 如果是项目部取上级组织后判断
        if(new Integer(5).equals(org.getOrgType())) {// 项目部
            return this.queryOrgById(org.getParentId());
        }
        return org;
    }

    /**
     * 根据租户ID查询组织(只包含集团和分公司)
     * @return
     */
    public Map<String, OrgVO> findOrgMap(){
        CommonResponse<List<OrgVO>> resp = orgApi.findOrgByType(InvocationInfoProxy.getTenantid(), Arrays.asList(2), null);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        List<OrgVO> list = resp.getData();
        Map<String, OrgVO> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(list)) {
            map = list.stream().collect(Collectors.toMap(OrgVO::getInnerCode, Function.identity()));
        }
        return map;
    }

    /**
     * 根据id集合查询项目列表
     * @param ids
     * @return
     */
    public List<ProjectRegisterVO> queryProjectByIds(List<Long> ids){
        CommonResponse<List<ProjectRegisterVO>> resp = projectApi.queryProjectByIds(ids);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        return resp.getData();
    }
    /**
     * 如果项目部查询上级分子公司
     * @param id
     * @return
     */
    private Long getCorpOrgId(Long id) {
        OrgVO org = this.queryOrgById(id);
        if(new Integer(5).equals(org.getOrgType())){// 项目部
            Map<String, OrgVO> orgMap = this.findOrgMap();
            for(String key : orgMap.keySet()){
                if(org.getInnerCode().startsWith(key)){
                    id = orgMap.get(key).getId();
                }
            }
        }
        return id;
    }
    /**
     * 根据id查询默认银行账户
     * @param id
     * @param type  supplierId or customerId or insideOrgId
     * @return
     */
    public BankAccountVO queryDefaultBankAccountById(Long id, String type){
        if("insideOrgId".equals(type)) {// 根据组织查询
            id = this.getCorpOrgId(id);
        }
        CommonResponse<BankAccountVO> resp = supplierWebApi.queryDefaultBankAccountById(id, type);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        if (StringUtils.isEmpty(resp.getData().getBankCode())){
            throw new BusinessException("客商银行账户为空！");
        }
        return resp.getData();
    }

}
