package com.ejianc.business.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 保证金对上申请表
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@TableName("ejc_finance_bond_up")
public class BondUpEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 申请编码
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 保证金类型
     */
    @TableField("bond_type")
    private Long bondType;

    /**
     * 保证金状态:0-待处理，1-有效
     */
    @TableField("bond_status")
    private String bondStatus;

    /**
     * 保函格式
     */
    @TableField("bond_format")
    private Long bondFormat;

    /**
     * 申请金额
     */
     @TableField("apply_mny")
     private BigDecimal applyMny;

     /**
     * 期限开始日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField("begin_date")
    private Date beginDate;

    /**
     * 期限结束日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField("end_date")
    private Date endDate;

    /**
     * 申请说明
     */
    @TableField("memo")
    private String memo;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 合同编号
     */
    @TableField("contract_code")
    private String contractCode;

    /**
     * 申请人
     */
    @TableField("apply_employee_id")
    private Long applyEmployeeId;

    /**
     * 申请人名称
     */
    @TableField("apply_employee_name")
    private String applyEmployeeName;

    /**
     * 申请时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField("apply_time")
    private Date applyTime;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 总包名称
     */
    @TableField("customer_id")
    private Long customerId;

    /**
     * 总包名称
     */
    @TableField("customer_name")
    private String customerName;

    /**
     * 合同金额
     */
    @TableField("contract_tax_mny")
    private BigDecimal contractTaxMny;

    /**
     * 保证金比例
     */
    @TableField("bond_scale")
    private BigDecimal bondScale;

    /**
     * 账户名
     */
    @TableField("account_name")
    private String accountName;

    /**
     * 银行账号
     */
    @TableField("bank_account")
    private String bankAccount;

    /**
     * 开户行
     */
    @TableField("bank_name")
    private String bankName;

    /**
     * 已支付金额
     */
    @TableField("pay_mny")
    private BigDecimal payMny;

    /**
     * 已退还金额
     */
    @TableField("back_mny")
    private BigDecimal backMny;

    /**
     * 单据状态（审批必须字段）
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 合同类型(1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁)
     */
    @TableField("contract_type")
    private String contractType;

    /**
     * 办理时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField("deal_time")
    private Date dealTime;

    /**
     * 付款方式
     */
    @TableField("payment_way")
    private Long paymentWay;

    /**
     * 申请付款组织id
     */
    @TableField("apply_org_id")
    private Long applyOrgId;

    /**
     * 申请付款组织名称
     */
    @TableField("apply_org_name")
    private String applyOrgName;

    /**
     * 实际付款组织id
     */
    @TableField("actual_org_id")
    private Long actualOrgId;
    
    /**
     * 实际付款组织名称
     */
    @TableField("actual_org_name")
    private String actualOrgName;

    /**
     * 来源ID
     */
    @TableField("source_id")
    private String sourceId;
    /**
     * 部门ID
     */
    @TableField("dept_id")
    private Long deptId;
    /**
     * 部门名称
     */
    @TableField("dept_name")
    private String deptName;

    /*
     * 现金项目流量id
     * */
    @TableField("cash_item_id")
    private Long cashItemId;

    /*
     * 现金项目流量名称
     * */
    @TableField("cash_item_name")
    private String cashItemName;

    /**
     * 来源退还ID
     */
    @TableField("source_back_id")
    private String sourceBackId;

    public String getSourceBackId() {
        return sourceBackId;
    }

    public void setSourceBackId(String sourceBackId) {
        this.sourceBackId = sourceBackId;
    }
    
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getBondType() {
        return bondType;
    }

    public void setBondType(Long bondType) {
        this.bondType = bondType;
    }

    public Date getDealTime() {
        return dealTime;
    }

    public void setDealTime(Date dealTime) {
        this.dealTime = dealTime;
    }

    public String getBondStatus() {
        return bondStatus;
    }

    public void setBondStatus(String bondStatus) {
        this.bondStatus = bondStatus;
    }
    public Long getBondFormat() {
        return bondFormat;
    }

    public void setBondFormat(Long bondFormat) {
        this.bondFormat = bondFormat;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getApplyEmployeeId() {
        return applyEmployeeId;
    }

    public void setApplyEmployeeId(Long applyEmployeeId) {
        this.applyEmployeeId = applyEmployeeId;
    }
    public String getApplyEmployeeName() {
        return applyEmployeeName;
    }

    public void setApplyEmployeeName(String applyEmployeeName) {
        this.applyEmployeeName = applyEmployeeName;
    }
    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getBondScale() {
        return bondScale;
    }

    public void setBondScale(BigDecimal bondScale) {
        this.bondScale = bondScale;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }
    public BigDecimal getBackMny() {
        return backMny;
    }

    public void setBackMny(BigDecimal backMny) {
        this.backMny = backMny;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public Long getPaymentWay() {
        return paymentWay;
    }

    public void setPaymentWay(Long paymentWay) {
        this.paymentWay = paymentWay;
    }

    public Long getApplyOrgId() {
        return applyOrgId;
    }

    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }

    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }

    public Long getActualOrgId() {
        return actualOrgId;
    }

    public void setActualOrgId(Long actualOrgId) {
        this.actualOrgId = actualOrgId;
    }

    public String getActualOrgName() {
        return actualOrgName;
    }

    public void setActualOrgName(String actualOrgName) {
        this.actualOrgName = actualOrgName;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Long getCashItemId() {
        return cashItemId;
    }

    public void setCashItemId(Long cashItemId) {
        this.cashItemId = cashItemId;
    }

    public String getCashItemName() {
        return cashItemName;
    }

    public void setCashItemName(String cashItemName) {
        this.cashItemName = cashItemName;
    }
}
