package com.ejianc.business.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@TableName("ejc_finance_pay_foregift")
public class PayForegiftEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 单据编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 经办时间
     */
    @TableField("confirm_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 付款类型：1-组织付款 2-项目付款
     */
    @TableField("pay_type")
    private Integer payType;

    /**
     * 支付状态：1-未支付 2-已支付
     */
    @TableField("pay_status")
    private Integer payStatus;

    /**
     * 支付金额
     */
    @TableField("pay_mny")
    private BigDecimal payMny;

    /**
     * 是否逾期：1-已逾期 0-未逾期
     */
    @TableField("overdue_flag")
    private Integer overdueFlag;

    /**
     * 返还金额
     */
    @TableField("return_mny")
    private BigDecimal returnMny;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 合同类型：1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
     */
    @TableField("contract_type")
    private Long contractType;

    /**
     * 合同编码
     */
    @TableField("contract_code")
    private String contractCode;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 合同金额
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 付款事由
     */
    @TableField("pay_reason")
    private String payReason;

    /**
     * 收款单位
     */
    @TableField("receive_unit_id")
    private Long receiveUnitId;

    /**
     * 收款单位名称
     */
    @TableField("receive_unit_name")
    private String receiveUnitName;

    /**
     * 申请人
     */
    @TableField("apply_user_id")
    private Long applyUserId;

    /**
     * 申请人名称
     */
    @TableField("apply_user_name")
    private String applyUserName;

    /**
     * 申请时间
     */
    @TableField("apply_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime;

    /**
     * 申请金额
     */
    @TableField("apply_mny")
    private BigDecimal applyMny;

    /**
     * 账户名称
     */
    @TableField("account_name")
    private String accountName;

    /**
     * 银行账号
     */
    @TableField("account_num")
    private String accountNum;

    /**
     * 开户行
     */
    @TableField("account_bank")
    private String accountBank;

    /**
     * 撤回原因
     */
    @TableField("back_reason")
    private String backReason;

    /**
     * 撤回时间
     */
    @TableField("back_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date backTime;

    /**
     * 预计退还日期
     */
    @TableField("plan_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date planTime;

    /**
     * 审批时间
     */
    @TableField("approve_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date approveTime;

    /**
     * 押金比例
     */
    @TableField("foregift_scale")
    private BigDecimal foregiftScale;

    /**
     * 剩余返还金额
     */
    @TableField("surplus_return_mny")
    private BigDecimal surplusReturnMny;

    /**
     * 属于项目:1-是，0-否
     */
    @TableField("depend_on_project")
    private String dependOnProject;

    /**
     * 采购类型 1-自采，2-集采
     */
    @TableField("purchase_type")
    private String purchaseType;

    /**
     * 项目资金余额
     */
    @TableField("project_balance_tax_mny")
    private BigDecimal projectBalanceTaxMny;

    /**
     * 应付账款余额
     */
    @TableField("accounts_balance_tax_mny")
    private BigDecimal accountsBalanceTaxMny;
    
    /**
     * 开户行主键
     */
    @TableField("account_bank_id")
    private Long accountBankId;
    
    /**
     * 开户行编码
     */
    @TableField("account_bank_code")
    private String accountBankCode;
    
    /**
     * 收款对象类型 qy企业 gr个人
     */
    @TableField("collection_type")
    private String collectionType;
    
    @TableField(value = "apply_org_id")
	private Long applyOrgId; // 申请付款组织id
	@TableField(value = "apply_org_name")
	private String applyOrgName; // 申请付款组织名称
	@TableField(value = "actual_org_id")
	private Long actualOrgId; // 实际付款组织id
	@TableField(value = "actual_org_name")
	private String actualOrgName; // 实际付款组织名称

	/**
	 * 实际付款账户名
	 */
	@TableField("actual_bank_account")
	private String actualBankAccount;

	/**
	 * 实际付款账号
	 */
	@TableField("actual_bank_code")
	private String actualBankCode;

	/**
	 * 实际付款开户银行
	 */
	@TableField("actual_bank_name")
	private String actualBankName;
	
	/**
	 * 现金流量
	 */
	@TableField("cash_item_id")
	private Long cashItemId;

	/**
	 * 现金流量名称
	 */
	@TableField("cash_item_name")
	private String cashItemName;
	
	@TableField(value = "payment_method")
	private Long paymentMethod; //收付款方式
	@TableField(value = "payment_method_name")
	private String paymentMethodName; //收付款方式名称
	
	/**
     * 来源ID
     */
    @TableField("source_id")
    private String sourceId;
    
    
    public Long getApplyOrgId() {
		return applyOrgId;
	}

	public void setApplyOrgId(Long applyOrgId) {
		this.applyOrgId = applyOrgId;
	}

	public String getApplyOrgName() {
		return applyOrgName;
	}

	public void setApplyOrgName(String applyOrgName) {
		this.applyOrgName = applyOrgName;
	}

	public Long getActualOrgId() {
		return actualOrgId;
	}

	public void setActualOrgId(Long actualOrgId) {
		this.actualOrgId = actualOrgId;
	}

	public String getActualOrgName() {
		return actualOrgName;
	}

	public void setActualOrgName(String actualOrgName) {
		this.actualOrgName = actualOrgName;
	}

	public String getActualBankAccount() {
		return actualBankAccount;
	}

	public void setActualBankAccount(String actualBankAccount) {
		this.actualBankAccount = actualBankAccount;
	}

	public String getActualBankCode() {
		return actualBankCode;
	}

	public void setActualBankCode(String actualBankCode) {
		this.actualBankCode = actualBankCode;
	}

	public String getActualBankName() {
		return actualBankName;
	}

	public void setActualBankName(String actualBankName) {
		this.actualBankName = actualBankName;
	}

	public Long getCashItemId() {
		return cashItemId;
	}

	public void setCashItemId(Long cashItemId) {
		this.cashItemId = cashItemId;
	}

	public String getCashItemName() {
		return cashItemName;
	}

	public void setCashItemName(String cashItemName) {
		this.cashItemName = cashItemName;
	}

	public Long getPaymentMethod() {
		return paymentMethod;
	}

	public void setPaymentMethod(Long paymentMethod) {
		this.paymentMethod = paymentMethod;
	}

	public String getPaymentMethodName() {
		return paymentMethodName;
	}

	public void setPaymentMethodName(String paymentMethodName) {
		this.paymentMethodName = paymentMethodName;
	}

	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public String getCollectionType() {
		return collectionType;
	}

	public void setCollectionType(String collectionType) {
		this.collectionType = collectionType;
	}
    
    
    public Long getAccountBankId() {
		return accountBankId;
	}

	public void setAccountBankId(Long accountBankId) {
		this.accountBankId = accountBankId;
	}

	public String getAccountBankCode() {
		return accountBankCode;
	}

	public void setAccountBankCode(String accountBankCode) {
		this.accountBankCode = accountBankCode;
	}

	public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public BigDecimal getSurplusReturnMny() {
        return surplusReturnMny;
    }

    public void setSurplusReturnMny(BigDecimal surplusReturnMny) {
        this.surplusReturnMny = surplusReturnMny;
    }

    public BigDecimal getForegiftScale() {
        return foregiftScale;
    }

    public void setForegiftScale(BigDecimal foregiftScale) {
        this.foregiftScale = foregiftScale;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public Integer getOverdueFlag() {
        return overdueFlag;
    }

    public void setOverdueFlag(Integer overdueFlag) {
        this.overdueFlag = overdueFlag;
    }

    public BigDecimal getReturnMny() {
        return returnMny;
    }

    public void setReturnMny(BigDecimal returnMny) {
        this.returnMny = returnMny;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }

    public Long getReceiveUnitId() {
        return receiveUnitId;
    }

    public void setReceiveUnitId(Long receiveUnitId) {
        this.receiveUnitId = receiveUnitId;
    }

    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }

    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }

    public Date getBackTime() {
        return backTime;
    }

    public void setBackTime(Date backTime) {
        this.backTime = backTime;
    }

    public Date getPlanTime() {
        return planTime;
    }

    public void setPlanTime(Date planTime) {
        this.planTime = planTime;
    }

    public BigDecimal getProjectBalanceTaxMny() {
        return projectBalanceTaxMny;
    }

    public void setProjectBalanceTaxMny(BigDecimal projectBalanceTaxMny) {
        this.projectBalanceTaxMny = projectBalanceTaxMny;
    }

    public BigDecimal getAccountsBalanceTaxMny() {
        return accountsBalanceTaxMny;
    }

    public void setAccountsBalanceTaxMny(BigDecimal accountsBalanceTaxMny) {
        this.accountsBalanceTaxMny = accountsBalanceTaxMny;
    }
}
