package com.ejianc.business.finance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.finance.mbs.bean.pay.response.PayMbsRespVo;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 实付款信息
 * 
 * @author generator
 * 
 */
 @TableName("ejc_finance_pay_info")
public class PayInfoEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="confirm_time")
    private Date confirmTime; // 经办时间
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="payapply_id")
    private Long payapplyId; // 付款申请单主键
    @TableField(value="payapply_code")
    private String payapplyCode; // 付款申请单单号
    @TableField(value="settle_id")
    private Long settleId; // 来源结算单主键
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_type")
    private Long contractType; // 合同类型：1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="fee_type")
    private Long feeType; // 支付类型：1-预付款，2-过程款，3-其他
    @TableField(value="receive_unit_id")
    private Long receiveUnitId; // 收款单位
    @TableField(value="receive_unit_name")
    private String receiveUnitName; // 收款单位名称
    @TableField(value="settle_payment_method")
    private Long settlePaymentMethod; // 收付款方式
    @TableField(value="settle_payment_method_name")
    private String settlePaymentMethodName; // 收付款方式名称
    @TableField(value="account_name")
    private String accountName; // 账户名称
    @TableField(value="account_num")
    private String accountNum; // 银行账号
    @TableField(value="account_bank")
    private String accountBank; // 开户行
    @TableField(value="account_bank_id")
    private Long accountBankId; // 开户行主键
    @TableField(value="account_bank_code")
    private String accountBankCode; // 开户行编码
    @TableField(value="collection_type")
    private String collectionType; // 收款对象类型 qy：企业 gr：个人
    @TableField(value="approve_time")
    private Date approveTime; // 审批时间
    @TableField(value="pay_reason")
    private String payReason; // 付款事由
    @TableField(value="is_bank")
    private String isBank; // 是否是网银类付款 Y是N否
    @TableField(value="apply_user_id")
    private Long applyUserId; // 申请人
    @TableField(value="apply_user_name")
    private String applyUserName; // 申请人名称
    @TableField(value="apply_time")
    private Date applyTime; // 申请时间
    @TableField(value="pay_info_type")
    private String payInfoType; // 实付类型 HT合同LX零星YJ押金QT其他
    @TableField(value="pay_mny")
    private BigDecimal payMny; // 支付金额
    @TableField(value="pay_status")
    private Integer payStatus; // 资金系统支付状态：0-部分支付 1-已支付 2-关闭付款
    @TableField(value="apply_mny")
    private BigDecimal applyMny;//申请金额
    
    @TableField(value = "actual_bank_code")
    private String actualBankCode;//付方账号
    
    @TableField(value = "result")
    private String result;//NC推送状态
    
    @TableField(value = "send_mbs_msg")
    private String sendMbsMsg;//业资推送报文
    @TableField(value = "renew_msg")
    private String renewMsg;//状态更新报文
    @TableField(value = "renew_result")
    private String renewResult;//状态更新返回报文
    @TableField(value = "send_mbs_result")
    private String sendMbsResult;//业资推送返回报文

	public String getSendMbsMsg() {
		return sendMbsMsg;
	}

	public void setSendMbsMsg(String sendMbsMsg) {
		this.sendMbsMsg = sendMbsMsg;
	}

	public String getRenewMsg() {
		return renewMsg;
	}

	public void setRenewMsg(String renewMsg) {
		this.renewMsg = renewMsg;
	}

	public String getRenewResult() {
		return renewResult;
	}

	public void setRenewResult(String renewResult) {
		this.renewResult = renewResult;
	}

	public String getSendMbsResult() {
		return sendMbsResult;
	}

	public void setSendMbsResult(String sendMbsResult) {
		this.sendMbsResult = sendMbsResult;
	}

	public String getResult() {
		return result;
	}

	public void setResult(String string) {
		this.result = string;
	}

	public BigDecimal getApplyMny() {
		return applyMny;
	}

	public void setApplyMny(BigDecimal applyMny) {
		this.applyMny = applyMny;
	}

	public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getPayapplyId() {
        return payapplyId;
    }

    public void setPayapplyId(Long payapplyId) {
        this.payapplyId = payapplyId;
    }
    public String getPayapplyCode() {
        return payapplyCode;
    }

    public void setPayapplyCode(String payapplyCode) {
        this.payapplyCode = payapplyCode;
    }
    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getFeeType() {
        return feeType;
    }

    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }
    public Long getReceiveUnitId() {
        return receiveUnitId;
    }

    public void setReceiveUnitId(Long receiveUnitId) {
        this.receiveUnitId = receiveUnitId;
    }
    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }
    public Long getSettlePaymentMethod() {
        return settlePaymentMethod;
    }

    public void setSettlePaymentMethod(Long settlePaymentMethod) {
        this.settlePaymentMethod = settlePaymentMethod;
    }
    public String getSettlePaymentMethodName() {
        return settlePaymentMethodName;
    }

    public void setSettlePaymentMethodName(String settlePaymentMethodName) {
        this.settlePaymentMethodName = settlePaymentMethodName;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }
    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }
    public Long getAccountBankId() {
        return accountBankId;
    }

    public void setAccountBankId(Long accountBankId) {
        this.accountBankId = accountBankId;
    }
    public String getAccountBankCode() {
        return accountBankCode;
    }

    public void setAccountBankCode(String accountBankCode) {
        this.accountBankCode = accountBankCode;
    }
    public String getCollectionType() {
        return collectionType;
    }

    public void setCollectionType(String collectionType) {
        this.collectionType = collectionType;
    }
    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }
    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }
    public String getIsBank() {
        return isBank;
    }

    public void setIsBank(String isBank) {
        this.isBank = isBank;
    }
    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }
    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }
    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }
    public String getPayInfoType() {
        return payInfoType;
    }

    public void setPayInfoType(String payInfoType) {
        this.payInfoType = payInfoType;
    }
    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }
    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

	public String getActualBankCode() {
		return actualBankCode;
	}

	public void setActualBankCode(String actualBankCode) {
		this.actualBankCode = actualBankCode;
	}
    
}
