package com.ejianc.business.finance.bean;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 项目资金设置-费用清单
 * </p>
 *
 * @author liyj
 * @since 2021-05-11
 */
@TableName("ejc_finance_project_capital_set_cost")
public class ProjectCapitalSetCostEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 费用名称
     */
    @TableField("cost_name")
    private String costName;

    /**
     * 增加/扣除
     */
    @TableField("add_or_delete")
    private String addOrDelete;

    /**
     * 数据类型
     */
    @TableField("data_type")
    private String dataType;

    /**
     * 数值/公式
     */
    @TableField("value_or_formula")
    private String valueOrFormula;

    /**
     * 公式--实际值
     */
    @TableField("formula")
    private String formula;

    /**
     * 公式--列描述
     */
    @TableField("column_describe")
    private String columnDescribe;

    /**
     * 金额
     */
    @TableField("amount")
    private BigDecimal amount;

    /**
     * 登记时间
     */
    @TableField("registration_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date registrationTime;

    /**
     * 经办人
     */
    @TableField("deal_user")
    private Long dealUser;

    /**
     * 备注
     */
    @TableField("remarks")
    private String remarks;
    
    /**
     * 主表id
     */
    @TableField("project_capital_set_id")
    private Long projectCapitalSetId;
    
	public String getCostName() {
		return costName;
	}

	public void setCostName(String costName) {
		this.costName = costName;
	}

	public String getAddOrDelete() {
		return addOrDelete;
	}

	public void setAddOrDelete(String addOrDelete) {
		this.addOrDelete = addOrDelete;
	}

	public String getDataType() {
		return dataType;
	}

	public void setDataType(String dataType) {
		this.dataType = dataType;
	}

	public String getValueOrFormula() {
		return valueOrFormula;
	}

	public void setValueOrFormula(String valueOrFormula) {
		this.valueOrFormula = valueOrFormula;
	}

	public BigDecimal getAmount() {
		return amount;
	}

	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}

	public Date getRegistrationTime() {
		return registrationTime;
	}

	public void setRegistrationTime(Date registrationTime) {
		this.registrationTime = registrationTime;
	}

	public Long getDealUser() {
		return dealUser;
	}

	public void setDealUser(Long dealUser) {
		this.dealUser = dealUser;
	}

	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public Long getProjectCapitalSetId() {
		return projectCapitalSetId;
	}

	public void setProjectCapitalSetId(Long projectCapitalSetId) {
		this.projectCapitalSetId = projectCapitalSetId;
	}

	public String getFormula() {
		return formula;
	}

	public void setFormula(String formula) {
		this.formula = formula;
	}

	public String getColumnDescribe() {
		return columnDescribe;
	}

	public void setColumnDescribe(String columnDescribe) {
		this.columnDescribe = columnDescribe;
	}

}
