package com.ejianc.business.finance.controller;


import com.ejianc.business.finance.service.IBondDownBackService;
import com.ejianc.business.finance.vo.BondDownBackVO;
import com.ejianc.business.finance.vo.BondDownDealRentVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 保证金退还表 前端控制器
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@RestController
@RequestMapping("/bondDownBack")
public class BondDownBackController {
    @Autowired
    private IBondDownBackService bondDownBackService;
    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrUpdate 新增或者修改
     * @param bondDownBackVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BondDownBackVO> saveOrUpdate(@RequestBody BondDownBackVO bondDownBackVO) {
        BondDownBackVO backVO = bondDownBackService.insertOrUpdate(bondDownBackVO);
        return CommonResponse.success("保存或修改单据成功！", backVO);
    }

    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description  查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BondDownDealRentVO> queryDetail(Long id) {
        BondDownDealRentVO backVO = bondDownBackService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", backVO);
    }
}
