package com.ejianc.business.finance.controller;


import com.ejianc.business.finance.service.IBondDownDealService;
import com.ejianc.business.finance.vo.BondDownDealRentVO;
import com.ejianc.business.finance.vo.BondDownDealVO;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 保证金办理表 前端控制器
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@RestController
@RequestMapping("/bondDownDeal")
public class BondDownDealController {
    @Autowired
    private IBondDownDealService bondDownDealService;
    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrDowndate 新增或者修改
     * @param bondDownDealVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BondDownDealVO> saveOrUpdate(@RequestBody BondDownDealVO bondDownDealVO) {
        BondDownDealVO backVO = bondDownDealService.insertOrUpdate(bondDownDealVO);
        return CommonResponse.success("保存或修改单据成功！", backVO);
    }

    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description  查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BondDownDealRentVO> queryDetail(Long id) {
        BondDownDealRentVO backVO = bondDownDealService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", backVO);
    }
}
