package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

@RestController
@RequestMapping(value = "/report/")
public class ReportController {
    @Autowired
    private IPayContractService reportService;

    /***************  移动看板start  *****************/
    /**
     * 根据项目id，查询项目进度数据
     *
     * @return
     */
    @RequestMapping(value = "/projectProgress", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> projectProgress(@RequestParam(value = "projectId") Long projectId,
                                                      @RequestParam(value = "startDate", required = false) Date startDate,
                                                      @RequestParam(value = "endDate", required = false) Date endDate) {
        return CommonResponse.success("查询列表数据成功！", reportService.projectProgress(projectId, startDate, endDate));
    }

    /**
     * 根据项目id，查询项目收入数据
     *
     * @return
     */
    @RequestMapping(value = "/projectIncome", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> projectProgress(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("查询列表数据成功！", reportService.projectIncome(projectId));
    }
    /**
     * 根据项目id，查询项目支出数据
     *
     * @return
     */
    @RequestMapping(value = "/projectOut", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> projectOut(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("查询列表数据成功！", reportService.projectOut(projectId));
    }
    /***************  移动看板end    *****************/
}
