package com.ejianc.business.finance.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.vo.BondReportVO;
import com.ejianc.business.finance.vo.BondVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 保证金对上申请表 Mapper 接口
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@Mapper
public interface BondUpMapper extends BaseCrudMapper<BondUpEntity> {

    List<BondVO> pageList(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    List<BondReportVO> queryBondUpReport(@Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    List<BondReportVO> queryBondDownReport(@Param(Constants.WRAPPER) QueryWrapper queryWrapper);

}
