package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.finance.bean.BondDownBackEntity;
import com.ejianc.business.finance.bean.BondDownDealEntity;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.business.finance.service.IBondDownBackService;
import com.ejianc.business.finance.service.IBondDownDealService;
import com.ejianc.business.finance.service.IBondDownService;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * <p>
 * 对下保证金申请审批事件
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("bondDown")
public class BondDownBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBondDownService bondDownService;

    @Autowired
    private IBondDownDealService bondDownDealService;

    @Autowired
    private IBondDownBackService bondDownBackService;


    @Autowired
    private NCUtil ncUtil;

    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        logger.info("进入弃审后回写--- billId:"+billId+"  state:"+state);
        BondDownEntity upEntity = bondDownService.selectById(billId);
        upEntity.setBondStatus("0");
        upEntity.setBackMny(BigDecimal.ZERO);
        upEntity.setPayMny(BigDecimal.ZERO);
        upEntity.setEmployeeId(null);
        upEntity.setEmployeeName(null);
        boolean res = bondDownService.saveOrUpdate(upEntity,false);
        QueryWrapper<BondDownDealEntity> dealWrapper = new QueryWrapper<>();
        dealWrapper.eq("bond_id", billId);
        bondDownDealService.remove(dealWrapper,false);

        QueryWrapper<BondDownBackEntity> backWrapper = new QueryWrapper<>();
        backWrapper.eq("bond_id", billId);
        bondDownBackService.remove(backWrapper,false);
        // 删除NC传付款单凭证
        if(StringUtils.isNotEmpty(upEntity.getSourceId())){
            String[] split = upEntity.getSourceId().split(",");
            for (String sourceId : split){
                JSONObject json = new JSONObject();
                json.put("busitype", "deleterecbill");
                json.put("pk_bill", sourceId);
                ncUtil.postByJson(json.toJSONString());// 调用NC传凭证接口
            }
            LambdaUpdateWrapper<BondDownEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(BondDownEntity::getSourceId, null);// 保存来源主键
            wrapper.eq(BondDownEntity::getId, billId);
            bondDownService.update(wrapper);
        }
        // 删除NC传付款单凭证
        if(StringUtils.isNotEmpty(upEntity.getSourceBackId())){
            String[] split = upEntity.getSourceBackId().split(",");
            for (String sourceId : split){
                JSONObject json = new JSONObject();
                json.put("busitype", "deletepaybill");
                json.put("pk_bill", sourceId);
                ncUtil.postByJson(json.toJSONString());// 调用NC传凭证接口
            }
            LambdaUpdateWrapper<BondDownEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(BondDownEntity::getSourceId, null);// 保存来源主键
            wrapper.eq(BondDownEntity::getId, billId);
            bondDownService.update(wrapper);
        }
        if(res){
            return CommonResponse.success("回退成功!");
        }else{
            return CommonResponse.error("回退出现异常，请刷新后再试!");
        }
    }

}
