package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.bean.BondDownDealEntity;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.business.finance.mapper.BondDownDealMapper;
import com.ejianc.business.finance.service.IBondDownDealService;
import com.ejianc.business.finance.service.IBondDownService;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.finance.vo.BondDownDealRentVO;
import com.ejianc.business.finance.vo.BondDownDealVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.RecBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.RecBillVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 保证金办理表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@Service
public class BondDownDealServiceImpl extends BaseServiceImpl<BondDownDealMapper, BondDownDealEntity> implements IBondDownDealService {
    private static final String BONGDOWN_DEAL = "BONGDOWN_DEAL";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBondDownService bondDownService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private NCUtil ncUtil;


    @Override
    public BondDownDealVO insertOrUpdate(BondDownDealVO bondDownDealVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<BondDownDealEntity> entities = null;
        if(StringUtils.isEmpty(bondDownDealVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BONGDOWN_DEAL,tenantId);
            if(billCode.isSuccess()) {
                bondDownDealVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        BondDownDealEntity entity = BeanMapper.map(bondDownDealVO, BondDownDealEntity.class);
        if(null!=bondDownDealVO.getId()&&bondDownDealVO.getId()>0){
            //编辑
            LambdaQueryWrapper<BondDownDealEntity> lambda = Wrappers.<BondDownDealEntity>lambdaQuery();
            lambda.eq(BondDownDealEntity::getBillCode, bondDownDealVO.getBillCode());
            lambda.eq(BondDownDealEntity::getTenantId, tenantId);
            lambda.ne(BondDownDealEntity::getId, bondDownDealVO.getId());
            entities = super.list(lambda);
            //需要将本次数据新增，将之前数据改为作废
            LambdaUpdateWrapper<BondDownDealEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(BondDownDealEntity::getId,entity.getId());
            updateWrapper.set(BondDownDealEntity::getDealStatus,"2");
            super.update(updateWrapper);
            entity.setId(null);
        }else{
            //新增
            //校验合同编号是否重复
            LambdaQueryWrapper<BondDownDealEntity> lambda = Wrappers.<BondDownDealEntity>lambdaQuery();
            lambda.eq(BondDownDealEntity::getTenantId, tenantId);
            lambda.eq(BondDownDealEntity::getBillCode, bondDownDealVO.getBillCode());
            entities = super.list(lambda);
        }
        if(entities != null && entities.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setDealStatus("1");
        entity.setDealTime(new Date());
        super.saveOrUpdate(entity,false);

        //回写申请单
        LambdaUpdateWrapper<BondDownEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BondDownEntity::getId,entity.getBondId());
        updateWrapper.set(BondDownEntity::getBondStatus,"1");
        updateWrapper.set(BondDownEntity::getBeginDate,entity.getBeginDate());
        updateWrapper.set(BondDownEntity::getEndDate,entity.getEndDate());
        updateWrapper.set(BondDownEntity::getEmployeeId,entity.getEmployeeId());
        updateWrapper.set(BondDownEntity::getEmployeeName,entity.getEmployeeName());
        updateWrapper.set(BondDownEntity::getPayMny,entity.getBondMny());
        updateWrapper.set(BondDownEntity::getBondType,entity.getBondType());
        updateWrapper.set(BondDownEntity::getDealTime,entity.getDealTime());
        bondDownService.update(updateWrapper);
        //推送凭证
        BondDownEntity bondDownEntity = bondDownService.selectById(bondDownDealVO.getBondId());
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(bondDownEntity.getProjectId())).get(0);
        if ("1".equals(project.getIndustryIntegrationFlag())){
            this.pushToNC(bondDownEntity,entity);
        }
        return BeanMapper.map(entity, BondDownDealVO.class);
    }
    @Override
    public BondDownDealRentVO queryDetail(Long id) {
        BondDownDealRentVO vo = new BondDownDealRentVO();
        BondDownEntity upEntity = bondDownService.selectById(id);
        LambdaQueryWrapper<BondDownDealEntity> lambda = Wrappers.<BondDownDealEntity>lambdaQuery();
        lambda.eq(BondDownDealEntity::getBondId, id);
        lambda.orderBy(true,true,BondDownDealEntity::getDealStatus);
        List<BondDownDealEntity> list = super.list(lambda);
        vo = BeanMapper.map(upEntity,BondDownDealRentVO.class);
        if(CollectionUtils.isNotEmpty(list)){
            vo.setDealRecord(BeanMapper.mapList(list,BondDownDealVO.class));
        }
        return vo;
    }

    /**
     * 推送NC传收款单凭证
     * @param entity
     */
    private void pushToNC(BondDownEntity entity,BondDownDealEntity bondDownDealEntity) {
        RecBillVO vo = this.transferToNCVO(entity,bondDownDealEntity);// 转换成NCVO
        StringBuffer sb = new StringBuffer();
        if(entity.getPaymentOrgId().equals(entity.getActualOrgId())){
            //如果【收款组织】和【实际收款组织】相同则传一个凭证
            String sourceId = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 开始传凭证
            sb.append(sourceId);
        }else{
            //否则如果【收款组织】和【实际收款组织】不同则传两个凭证
            String sourceId1 = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 第一次传凭证
            vo.setPk_org(ncUtil.queryOrgById(entity.getActualOrgId()).getCode()); //传【实际收款组织】
            BankAccountVO bankAccountVO2 = ncUtil.queryDefaultBankAccountById(entity.getActualOrgId(), "insideOrgId");//根据实际收款组织查银行账户
            RecBillDetailVO recBillDetailVO2 = vo.getDetail().get(0);
            recBillDetailVO2.setBankaccount(bankAccountVO2.getBankCode());
            String sourceId2 = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 第二次传凭证
            sb.append(sourceId1).append(",").append(sourceId2);
        }
        LambdaUpdateWrapper<BondDownEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(BondDownEntity::getSourceId, sb.toString());// 保存来源主键
        wrapper.eq(BondDownEntity::getId, entity.getId());
        bondDownService.update(wrapper);
        LambdaUpdateWrapper<BondDownDealEntity> lambda = new LambdaUpdateWrapper<>();
        lambda.set(BondDownDealEntity::getSourceId, sb.toString());// 保存来源主键
        lambda.eq(BondDownDealEntity::getId, bondDownDealEntity.getId());
        this.update(lambda);
    }

    /**
     * 转换成NCVO
     * @param entity
     * @return
     */
    private RecBillVO transferToNCVO(BondDownEntity entity,BondDownDealEntity bondDownDealEntity){
        logger.info("----收款单传凭证开始:");
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        OrgVO orgVO = ncUtil.queryOrgById(project.getOrgId());
        SupplierVO supplierrVO = ncUtil.querySupplierById(entity.getSupplierId());
        RecBillVO vo = new RecBillVO();
        vo.setBusitype("recbill");// 业务标识
        vo.setTradetype("F2-Cxx-003");// 交易类型
        vo.setPk_project(String.valueOf(entity.getProjectId()));// 项目主键
        vo.setPk_dept(String.valueOf(project.getDeptId()));// 部门主键
        vo.setDef12(String.valueOf(entity.getId()));// PM单据主键
        vo.setDef19(bondDownDealEntity.getBillCode());//单据编号
        vo.setDef1(false);
        vo.setPk_org(ncUtil.queryOrgById(entity.getPaymentOrgId()).getCode()); // 财务组织编码（收款单位）
        vo.setPk_customer("1001A11000000009VTP1");
        vo.setDef18(String.valueOf(entity.getSupplierId()));//def18自定义字段 客户id
        vo.setDef6(supplierrVO.getInsideOrgId() != null);// 是否内部单位 true/false
        //vo.setPk_realorg(String.valueOf(entity.getActualOrgId()));//实际付款组织
        DefdocDetailVO defDocById = ncUtil.getDefDocById(entity.getPaymentWay());
        vo.setBalatype(defDocById.getCode()); //结算方式
        vo.setDef20(ncUtil.getWebSite("ejc-finance-frontend/#/bondManageList/bondDownDetailManage?id=" + entity.getId()));// 外部访问url
        vo.setDef21("BT200616000000004");// 单据类型

        List<RecBillDetailVO> detailVOS = new ArrayList<>();
        RecBillDetailVO detailVO = new RecBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setLocal_mny(bondDownDealEntity.getBondMny());
        BankAccountVO bankAccountVO = ncUtil.queryDefaultBankAccountById(entity.getPaymentOrgId(), "insideOrgId");//根据收款组织查银行账户
        detailVO.setBankaccount(bankAccountVO.getBankCode()); //传收款组织的银行账户
        detailVO.setCashitem(ncUtil.getDefDocById(entity.getCashItemId()).getCode()); //现金流量
        detailVOS.add(detailVO);
        vo.setDetail(detailVOS);
        return  vo;
    }
}
