package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.business.finance.mapper.BondDownMapper;
import com.ejianc.business.finance.service.IBondDownService;
import com.ejianc.business.finance.vo.BondDownVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

/**
 * <p>
 * 保证金对下申请表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@Service
public class BondDownServiceImpl extends BaseServiceImpl<BondDownMapper, BondDownEntity> implements IBondDownService {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    
    private static final String BONDDOWN_BILL_CODE = "FINANCE_BONDDOWN";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private JedisPool jedisPool;

    @Autowired
    private ICommenQueryFieldsService commenQueryFieldsService;
    
    @Override
    public CommonResponse<BondDownVO> insertOrUpdate(BondDownVO bondDownVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(null!=bondDownVO&&StringUtils.isEmpty(bondDownVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BONDDOWN_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                bondDownVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //保存时校验合同version是否一致
        if(bondDownVO.getContractVersion()!=null&&bondDownVO.getContractVersion()!=0) {
            Jedis jedis = jedisPool.getResource();
            boolean locked = false;
            try {
                locked = RedisTool.tryLock(jedis, String.valueOf(bondDownVO.getContractId()), "saveOrUpdate", 1000);
                logger.info("判断单据单据锁结果------" + locked);
                if (locked) {
                    JSONObject contractEntity = commenQueryFieldsService.queryBillDetail(String.valueOf(bondDownVO.getContractId()), getBillTypeCode(bondDownVO.getContractType()));
                    String objVersion = contractEntity.getJSONObject("data").get("version").toString();
                    Integer version =contractEntity.getJSONObject("data").get("version")==null?0:Integer.parseInt(objVersion.substring(0,objVersion.indexOf(".")));
                    Integer conVersion = bondDownVO.getContractVersion();
                    if (version != conVersion) {
                        return CommonResponse.error("该合同已被更新，请刷新后重做！");
                    }
                }else{
                    return CommonResponse.error("出现并发操作,请稍后重试！");
                }
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                if (locked) {
                    RedisTool.releaseLock(jedis, String.valueOf(bondDownVO.getContractId()), "saveOrUpdate");
                }
                jedis.close();
            }
        }
        bondDownVO.setBondStatus("0");
        BondDownEntity entity = BeanMapper.map(bondDownVO, BondDownEntity.class);
        super.saveOrUpdate(entity,false);
        return CommonResponse.success(BeanMapper.map(entity, BondDownVO.class));
    }

    @Override
    public BondDownVO queryDetail(Long id) {
        BondDownEntity entity = super.selectById(id);
        BondDownVO bondDownVO = BeanMapper.map(entity, BondDownVO.class);
        return bondDownVO;
    }

    @Override
    public IPage<BondDownEntity> selectPage(Page pages, QueryWrapper queryWrapper) {
        return baseMapper.selectPage(pages,queryWrapper);
    }

    public String getBillTypeCode(String contractType){
        if("1".equals(contractType)){//分包合同
            return "BT200529000000001";
        }else if("2".equals(contractType)){//设备采购合同
            return "BT200528000000001";
        }else if("3".equals(contractType)){//设备租赁合同
            return "BT200528000000003";
        }else if("4".equals(contractType)){//物资采购合同
            return "BT200608000000001";
        }else if("5".equals(contractType)){//物资租赁合同
            return "BT200608000000001";
        }
        return "";
    }
}
