package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.bean.BondDownDealEntity;
import com.ejianc.business.finance.bean.BondUpBackEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.mapper.BondUpBackMapper;
import com.ejianc.business.finance.service.IBondUpBackService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.finance.vo.BondUpBackVO;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.RecBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.RecBillVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 保证金退还表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@Service
public class BondUpBackServiceImpl extends BaseServiceImpl<BondUpBackMapper, BondUpBackEntity> implements IBondUpBackService {

    private static final String BONGUP_BACK = "BONGUP_BACK";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBondUpService bondUpService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private NCUtil ncUtil;

    @Override
    public BondUpBackVO insertOrUpdate(BondUpBackVO bondUpBackVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<BondUpBackEntity> entities = null;
        if(StringUtils.isEmpty(bondUpBackVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BONGUP_BACK,tenantId);
            if(billCode.isSuccess()) {
                bondUpBackVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        BondUpBackEntity entity = BeanMapper.map(bondUpBackVO, BondUpBackEntity.class);
        if(null!=bondUpBackVO.getId()&&bondUpBackVO.getId()>0){
            //编辑
            LambdaQueryWrapper<BondUpBackEntity> lambda = Wrappers.<BondUpBackEntity>lambdaQuery();
            lambda.eq(BondUpBackEntity::getBillCode, bondUpBackVO.getBillCode());
            lambda.eq(BondUpBackEntity::getTenantId, tenantId);
            lambda.ne(BondUpBackEntity::getId, bondUpBackVO.getId());
            entities = super.list(lambda);
        }else{
            //新增
            //校验合同编号是否重复
            LambdaQueryWrapper<BondUpBackEntity> lambda = Wrappers.<BondUpBackEntity>lambdaQuery();
            lambda.eq(BondUpBackEntity::getTenantId, tenantId);
            lambda.eq(BondUpBackEntity::getBillCode, bondUpBackVO.getBillCode());
            entities = super.list(lambda);
        }
        if(entities != null && entities.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setBackTime(new Date());
        super.saveOrUpdate(entity,false);
        //回写申请单
        BondUpEntity upentity= bondUpService.selectById(bondUpBackVO.getBondId());
        BigDecimal sumBackMny = upentity.getBackMny()==null?BigDecimal.ZERO:upentity.getBackMny();
        BigDecimal applyMny = upentity.getApplyMny()==null?BigDecimal.ZERO:upentity.getApplyMny();
        if(applyMny.compareTo(sumBackMny.add(entity.getBackMny()))<0){
            throw new BusinessException("本次退还金额不能超过剩余金额!");
        }
        LambdaUpdateWrapper<BondUpEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BondUpEntity::getId,entity.getBondId());
        updateWrapper.set(BondUpEntity::getBackMny,sumBackMny.add(entity.getBackMny()));
        bondUpService.update(updateWrapper);
        //推送凭证
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(upentity.getProjectId())).get(0);
        if ("1".equals(project.getIndustryIntegrationFlag())){
            this.pushToNC(upentity,entity);
        }
        return BeanMapper.map(entity, BondUpBackVO.class);
    }

    @Override
    public BondUpDealRentVO queryDetail(Long id) {
        BondUpDealRentVO vo = new BondUpDealRentVO();
        BondUpEntity upEntity = bondUpService.selectById(id);
        LambdaQueryWrapper<BondUpBackEntity> lambda = Wrappers.<BondUpBackEntity>lambdaQuery();
        lambda.eq(BondUpBackEntity::getBondId, id);
        lambda.orderBy(true,false,BondUpBackEntity::getBackTime);
        List<BondUpBackEntity> list = super.list(lambda);
        vo.setId(id);
        vo.setBondStatus(upEntity.getBondStatus());
        vo.setContractId(upEntity.getContractId());
        vo.setContractName(upEntity.getContractName());
        vo.setApplyMny(upEntity.getApplyMny()==null?BigDecimal.ZERO:upEntity.getApplyMny());
        vo.setContractTaxMny(upEntity.getContractTaxMny()==null?BigDecimal.ZERO:upEntity.getContractTaxMny());
        vo.setBackMny(upEntity.getBackMny()==null?BigDecimal.ZERO:upEntity.getBackMny());
        vo.setSurplusMny(vo.getApplyMny().subtract(vo.getBackMny()));
        if(CollectionUtils.isNotEmpty(list)){
            vo.setBackRecord(BeanMapper.mapList(list,BondUpBackVO.class));
        }
        return vo;
    }

    /**
     * 推送NC传收款单凭证
     * @param entity
     */
    private void pushToNC(BondUpEntity entity,BondUpBackEntity bondUpBackEntity) {
        RecBillVO vo = this.transferToNCVO(entity,bondUpBackEntity);// 转换成NCVO
        StringBuffer sb = new StringBuffer();
        if(entity.getApplyOrgId().equals(entity.getActualOrgId())){
            //如果【收款组织】和【实际收款组织】相同则传一个凭证
            String sourceId = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 开始传凭证
            sb.append(sourceId);
        }else{
            //否则如果【收款组织】和【实际收款组织】不同则传两个凭证
            String sourceId1 = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 第一次传凭证
            vo.setPk_org(ncUtil.queryOrgById(entity.getActualOrgId()).getCode()); //传【实际收款组织】
            BankAccountVO bankAccountVO2 = ncUtil.queryDefaultBankAccountById(entity.getActualOrgId(), "insideOrgId");//根据实际收款组织查银行账户
            RecBillDetailVO recBillDetailVO2 = vo.getDetail().get(0);
            recBillDetailVO2.setBankaccount(bankAccountVO2.getBankCode());
            String sourceId2 = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 第二次传凭证
            sb.append(sourceId1).append(",").append(sourceId2);
        }
        // 多次退回，主表拼接多次记录
        LambdaQueryWrapper<BondUpEntity> ew = new LambdaQueryWrapper<>();
        BondUpEntity data = bondUpService.getById(entity.getId());
        String dataSourceIds = data.getSourceBackId();
        dataSourceIds = StringUtils.isNotEmpty(dataSourceIds) ? dataSourceIds + "," + sb.toString() : sb.toString();
        LambdaUpdateWrapper<BondUpEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(BondUpEntity::getSourceBackId, dataSourceIds);// 保存来源主键
        wrapper.eq(BondUpEntity::getId, entity.getId());
        bondUpService.update(wrapper);

        LambdaUpdateWrapper<BondUpBackEntity> lambda = new LambdaUpdateWrapper<>();
        lambda.set(BondUpBackEntity::getSourceBackId, sb.toString());// 保存来源主键
        lambda.eq(BondUpBackEntity::getId, bondUpBackEntity.getId());
        this.update(lambda);
    }
    /**
     * 转换成NCVO
     * @param entity
     * @return
     */
    private RecBillVO transferToNCVO(BondUpEntity entity,BondUpBackEntity bondUpBackEntity){
        logger.info("----收款单传凭证开始:");
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
//        OrgVO orgVO = ncUtil.queryOrgById(project.getOrgId());
        CustomerVO customerVO = ncUtil.queryCustomerById(entity.getCustomerId());
        RecBillVO vo = new RecBillVO();
        vo.setBusitype("recbill");// 业务标识
        vo.setTradetype("F2-Cxx-002");// 交易类型
        vo.setDef1(false);
        vo.setPk_project(String.valueOf(entity.getProjectId()));// 项目主键
        vo.setPk_dept(String.valueOf(project.getDeptId()));// 部门主键
        vo.setDef12(String.valueOf(entity.getId()));// PM单据主键
        vo.setDef19(bondUpBackEntity.getBillCode());//单据编号
        vo.setPk_org(ncUtil.queryOrgById(entity.getActualOrgId()).getCode()); // 财务组织编码（收款单位）
        vo.setPk_customer(String.valueOf(entity.getCustomerId()));// 客户主键
        vo.setDef6(customerVO.getInsideOrgId() != null);// 是否内部单位 true/false
        //vo.setPk_realorg(String.valueOf(entity.getActualOrgId()));//实际付款组织
        DefdocDetailVO defDocById = ncUtil.getDefDocById(entity.getPaymentWay());
        vo.setBalatype(defDocById.getCode()); //结算方式
        vo.setDef20(ncUtil.getWebSite("ejc-finance-frontend/#/bondManageList/bondUpDetailManage?id=" + entity.getId()));// 外部访问url
        vo.setDef21("BT200616000000003");// 单据类型

        List<RecBillDetailVO> detailVOS = new ArrayList<>();
        RecBillDetailVO detailVO = new RecBillDetailVO();
        detailVO.setPk_project(String.valueOf(entity.getProjectId()));
        detailVO.setLocal_mny(bondUpBackEntity.getBackMny());//退还保证金
        BankAccountVO bankAccountVO = ncUtil.queryDefaultBankAccountById(entity.getApplyOrgId(), "insideOrgId");//根据收款组织查银行账户
        detailVO.setBankaccount(bankAccountVO.getBankCode()); //传收款组织的银行账户
        detailVO.setCashitem(ncUtil.getDefDocById(entity.getCashItemId()).getCode()); //现金流量
        detailVOS.add(detailVO);
        vo.setDetail(detailVOS);
        return  vo;
    }
}
