package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.equipment.vo.RentSettlementVO;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.mapper.LoadReimburseMapper;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.vo.LoadInvoiceVO;
import com.ejianc.business.finance.vo.LoadReimburseVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveFlagVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 借款报销
 * 
 * @author generator
 * 
 */
@Service("LoadReimburseService")
public class LoadReimburseServiceImpl extends BaseServiceImpl<LoadReimburseMapper, LoadReimburseEntity> implements ILoadReimburseService{
    private static final String BONDUP_BILL_CODE = "LOAD_REIMBURSE";

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ILoadApplyService loadApplyService;

    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IOrgApi orgApi;

    @Override
    public LoadReimburseVO insertOrUpdate(LoadReimburseVO loadReimburseVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(null!=loadReimburseVO&&StringUtils.isEmpty(loadReimburseVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BONDUP_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                loadReimburseVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        LoadReimburseEntity entity = BeanMapper.map(loadReimburseVO, LoadReimburseEntity.class);
        BigDecimal surplusMny =  loadApplyService.querySurplusMny(entity.getId(),null,entity.getOrgId(),0,"");
        BigDecimal reimburseMny = entity.getReimburseMny();
        if(reimburseMny.compareTo(surplusMny)>0){
            DecimalFormat df1 = new DecimalFormat("###,###.##");
            throw new BusinessException("本次报销金额不能超过剩余可报销金额【"+df1.format(surplusMny)+"】元");
        }
        List<LoadInvoiceVO> invoiceVOList = loadReimburseVO.getInvoiceVOList();
        if(CollectionUtils.isNotEmpty(invoiceVOList)){
            List<InvoiceReceiveFlagVO> listi = new ArrayList<>();
            invoiceVOList.forEach(vo -> {
                InvoiceReceiveFlagVO invo = new InvoiceReceiveFlagVO();
                if("add".equals(vo.getRowState())){
                    //发票占用
                    invo.setId(vo.getInvoiceId());
                    invo.setFlag(1);
                    listi.add(invo);
                }else if("del".equals(vo.getRowState())){
                    //取消发票占用
                    invo.setId(vo.getInvoiceId());
                    invo.setFlag(0);
                    listi.add(invo);
                }
            });
            if(listi.size()>0){
                invoiceApi.updateFlag(listi);
            }
        }

        entity.setSurplusMny(surplusMny);
        entity.setProportionFlag("0");
        entity.setRelationFlag("0");
        super.saveOrUpdate(entity,false);
        return BeanMapper.map(entity, LoadReimburseVO.class);
    }

    @Override
    public Map<String, Object> countAmt(Long tenantId, List<Long> projectIds, List<Long> orgIds) {
        QueryWrapper<LoadReimburseEntity> queryWrapper = new QueryWrapper<>();
        if (CollectionUtils.isNotEmpty(orgIds)) {
            queryWrapper.in("org_id", orgIds);
        }

        queryWrapper.select("ifnull(sum(reimburse_mny),0) as amt");

        queryWrapper.eq("tenant_id", tenantId);
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
        //属于项目
//        queryWrapper.eq("depend_on_project", "1");

//        if(CollectionUtils.isNotEmpty(projectIds)) {
//            queryWrapper.in("project_id", projectIds);
//        }
//        已生效的单据
        queryWrapper.in("bill_state",
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()}));

        return super.getMap(queryWrapper);
    }

    @Override
    public CommonResponse<LoadReimburseVO> pushCost(LoadReimburseVO loadReimburseVO) {
        LoadReimburseEntity loadReimburseEntity = baseMapper.selectById(loadReimburseVO.getId());
        loadReimburseEntity.setSubjectId(loadReimburseVO.getSubjectId());
        loadReimburseEntity.setSubjectName(loadReimburseVO.getSubjectName());
        super.saveOrUpdate(loadReimburseEntity,false);
        //推送数据
        costPush(loadReimburseEntity);
        return CommonResponse.success(BeanMapper.map(loadReimburseEntity, LoadReimburseVO.class));
    }
    @Override
    public void costPush(LoadReimburseEntity loadReimburseEntity) {
        if (!"1".equals(loadReimburseEntity.getDependOnProject())){
            return;
        }
        //1.判断是否关联
        Long subjectId = loadReimburseEntity.getSubjectId();
        boolean newRelationFlag = true;
        if(null == subjectId){
            newRelationFlag = false;
        }
        //更新是否关联
        LambdaUpdateWrapper<LoadReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(LoadReimburseEntity::getId, loadReimburseEntity.getId());
        updateWrapper.set(LoadReimburseEntity::getRelationFlag, newRelationFlag ? "1":"0");//(1:是，0：否)
        super.update(updateWrapper);

        //判断之前的单据是否关联
        String oldRelationFlag = loadReimburseEntity.getRelationFlag();
        //之前已关联
        if (oldRelationFlag.equals("1")){
            if (newRelationFlag){
                saveCost(loadReimburseEntity);
            }
            if (!newRelationFlag){
                //删除成本中心之前的数据
                costDetailApi.deleteSubject(loadReimburseEntity.getId());
            }
        }
        //之前未关联
        if (oldRelationFlag.equals("0")){
            if (newRelationFlag){
                //税率
                saveCost(loadReimburseEntity);
            }
        }


        }

    private void saveCost(LoadReimburseEntity loadReimburseEntity) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        CostDetailVO costDetailVO = new CostDetailVO();
        costDetailVO.setSubjectId(loadReimburseEntity.getSubjectId());
        costDetailVO.setSourceId(loadReimburseEntity.getId());
        costDetailVO.setSourceDetailId(loadReimburseEntity.getId());
        costDetailVO.setHappenTaxMny(loadReimburseEntity.getReimburseMny());
        costDetailVO.setHappenMny(loadReimburseEntity.getReimburseMny());
        costDetailVO.setHappenDate(loadReimburseEntity.getApplyTime());
        costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
        costDetailVO.setSourceType(BONDUP_BILL_CODE);
        costDetailVO.setSourceTabType(BONDUP_BILL_CODE);
        costDetailVO.setProjectId(loadReimburseEntity.getProjectId());
        costDetailVOList.add(costDetailVO);
        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)){
            costDetailVOList.toString();
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            if (stringCommonResponse.isSuccess()){
            }else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
    //成本改造
    @Override
    public void pullCost(Long id) {
        ////更新关联状态为未关联
        LambdaUpdateWrapper<LoadReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(LoadReimburseEntity::getId, id);
        updateWrapper.set(LoadReimburseEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
        //删除成本中心数据
        costDetailApi.deleteSubject(id);
    }
    }
