package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.finance.bean.OtherDetailEntity;
import com.ejianc.business.finance.vo.OtherVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.finance.mapper.OtherMapper;
import com.ejianc.business.finance.bean.OtherEntity;
import com.ejianc.business.finance.service.IOtherService;

import java.util.ArrayList;
import java.util.List;

/**
 * 其他费用
 * 
 * @author generator
 * 
 */
@Service("otherService")
public class OtherServiceImpl extends BaseServiceImpl<OtherMapper, OtherEntity> implements IOtherService{

    private static final String FINANCE_OTHER = "FINANCE_OTHER";
    private static final String FINANCE_OTHER_DETAIL = "FINANCE_OTHER_DETAIL";

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse<OtherVO> pushCost(OtherVO otherVO) {
        OtherEntity otherEntity = baseMapper.selectById(otherVO.getId());
        if (ListUtil.isNotEmpty(otherVO.getOtherDetailList())) {
            List<OtherDetailEntity> otherDetail = BeanMapper.mapList(otherVO.getOtherDetailList(), OtherDetailEntity.class);
            otherEntity.setOtherDetailList(otherDetail);
        }
        super.saveOrUpdate(otherEntity, false);
        //推送数据
        costPush(otherEntity);
        return CommonResponse.success(BeanMapper.map(otherEntity, OtherVO.class));
    }

    @Override
    public void pullCost(Long id) {
        ////更新关联状态为未关联
        LambdaUpdateWrapper<OtherEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(OtherEntity::getId, id);
        updateWrapper.set(OtherEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
        //删除成本中心数据
        costDetailApi.deleteSubject(id);
    }

    @Override
    public void costPush(OtherEntity otherEntity) {
        logger.info("开始Push");
        //1.判断结算单所有子表是否全部关联科目
        List<OtherDetailEntity> otherdetail = otherEntity.getOtherDetailList();
        boolean newRelationFlag = true;
        if (ListUtil.isNotEmpty(otherdetail)) {
            for (OtherDetailEntity otherDetailEntity : otherdetail) {
                if (null == otherDetailEntity.getSubjectId()) {
                    newRelationFlag = false;
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(otherdetail)) {
            newRelationFlag = false;
        }

        //更新是否关联
        LambdaUpdateWrapper<OtherEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(OtherEntity::getId, otherEntity.getId());
        updateWrapper.set(OtherEntity::getRelationFlag, newRelationFlag ? "1" : "0");//(1:是，0：否)
        super.update(updateWrapper);

        //判断之前的单据是否关联
        String oldRelationFlag = otherEntity.getRelationFlag();
        //之前已关联
        if (oldRelationFlag.equals("1")) {
            if (newRelationFlag) {
                saveCost(otherEntity);
            }
            if (!newRelationFlag) {
                //删除成本中心之前的数据
                costDetailApi.deleteSubject(otherEntity.getId());
            }
        }
        //之前未关联
        if (oldRelationFlag.equals("0")) {
            if (newRelationFlag) {
                saveCost(otherEntity);
            }
        }
    }


    private void saveCost(OtherEntity otherEntity) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<OtherDetailEntity> pushOtherDetail = otherEntity.getOtherDetailList();
        if (ListUtil.isNotEmpty(pushOtherDetail)) {
            for (OtherDetailEntity otherDetailEntity : pushOtherDetail) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(otherDetailEntity.getSubjectId());
                costDetailVO.setSourceId(otherDetailEntity.getOtherId());
                costDetailVO.setSourceDetailId(otherDetailEntity.getId());
                costDetailVO.setHappenTaxMny(otherDetailEntity.getTaxMny());
                costDetailVO.setHappenMny(otherDetailEntity.getMny());
                costDetailVO.setHappenDate(otherEntity.getHappenDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(FINANCE_OTHER);
                costDetailVO.setSourceTabType(FINANCE_OTHER_DETAIL);
                costDetailVO.setProjectId(otherEntity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
}
