package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.finance.bean.PayForegiftEntity;
import com.ejianc.business.finance.bean.PayForegiftRecordEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.service.IPayForegiftRecordService;
import com.ejianc.business.finance.service.IPayForegiftService;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 押金付款申请审批操作业务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@Service("payForegift")
public class PayForegiftBpmServiceImpl implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPayForegiftService service;

    @Autowired
    private IPayForegiftRecordService recordService;
    
    @Autowired
    private NCUtil ncUtil;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    };

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PayForegiftEntity entity = service.selectById(billId);
        entity.setApproveTime(new Date());
        service.saveOrUpdate(entity);
        logger.info("进入审批后回写--- entity:"+entity);
        return CommonResponse.success("回调处理成功！");
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PayForegiftEntity entity = service.selectById(billId);
        // 校验审批时间
        if (!validateApproveTime(entity)) return CommonResponse.error("该合同在本组织下已存在后续审批单据,不能弃审!");
        // 校验存在未生效单据
        if (!validateEffective(entity)) return CommonResponse.error("该支出单据数据已被引用，不可进行撤回操作!");
        return CommonResponse.success("校验通过");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PayForegiftEntity entity = service.selectById(billId);
        
     // 删除NC传应付单凭证
        if(StringUtils.isNotEmpty(entity.getSourceId())){
            String[] split = entity.getSourceId().split(",");
            for (String sourceId : split){
                JSONObject json = new JSONObject();
                json.put("busitype", "deletepaybill");
                json.put("pk_bill", sourceId);
                ncUtil.postByJson(json.toJSONString());// 调用NC传凭证接口
            }

            LambdaUpdateWrapper<PayForegiftEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(PayForegiftEntity::getSourceId,null);
            wrapper.eq(PayForegiftEntity::getId,billId);
            service.update(wrapper);
        }
        
        entity.setPayMny(null);
        entity.setPayStatus(1);
        entity.setApproveTime(null);
        entity.setReturnMny(null);
        entity.setSurplusReturnMny(null);
        service.saveOrUpdate(entity);
        logger.info("进入审批后回写--- entity:"+entity);
        // 撤回申请删除退还记录
        QueryWrapper wrapper = new QueryWrapper<PayForegiftRecordEntity>();
        wrapper.eq("payapply_id", billId);
        recordService.remove(wrapper, false);
        return CommonResponse.success("回调处理成功！");
    }

    /**
     * 校验存在未生效单据
     * @param entity
     * @return
     */
    private boolean validateEffective(PayForegiftEntity entity) {
        Long contractId = entity.getContractId();
        Long orgId = entity.getOrgId();
        QueryWrapper wrapper = new QueryWrapper<PayForegiftEntity>();
        wrapper.eq("contract_id", contractId);
        wrapper.eq("org_id", orgId);
        wrapper.ne("bill_state", 1);
        wrapper.ne("bill_state", 3);
        List<PayForegiftEntity> list = service.list(wrapper);
        if(!list.isEmpty()){
            return false;
        }
        return true;
    }

    /**
     * 校验审批时间
     * @param entity
     * @return
     */
    private boolean validateApproveTime(PayForegiftEntity entity) {
        Long contractId = entity.getContractId();
        Long orgId = entity.getOrgId();
        Date approveTime = entity.getConfirmTime() != null ? entity.getConfirmTime() : entity.getApproveTime();
        QueryWrapper wrapper = new QueryWrapper<PayForegiftEntity>();
        wrapper.eq("contract_id", contractId);
        wrapper.eq("org_id", orgId);
        wrapper.gt("approve_time", approveTime);
        List<PayForegiftEntity> list = service.list(wrapper);
        if(!list.isEmpty()){
            return false;
        }
        return true;
    }
}
