package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayContractSettleEntity;
import com.ejianc.business.finance.bean.PayInfoEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.bean.PaySporadicStockEntity;
import com.ejianc.business.finance.mbs.bean.pay.request.PayReqDetail;
import com.ejianc.business.finance.mbs.bean.pay.response.PayMbsRespVo;
import com.ejianc.business.finance.mbs.service.MbsService;
import com.ejianc.business.finance.service.IPayInfoService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.service.IPaySporadicStockService;
import com.ejianc.business.finance.utils.MbsUtils;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.finance.vo.PayInfoVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 零星材料付款申请审批操作业务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@Service("paySporadic")
public class PaySporadicBpmServiceImpl implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPaySporadicService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private NCUtil ncUtil;
    @Autowired
    private IPaySporadicStockService stockService;
    @Autowired
    private IPayInfoService payInfoService;
    @Autowired
    private MbsUtils mbsUtils;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private MbsService mbsService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    };

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
       
    	//原代码
        PaySporadicEntity entity = service.selectById(billId);
        entity.setApproveTime(new Date());
        service.saveOrUpdate(entity);
        logger.info("进入审批后回写--- entity:"+entity);

        // 推送成本中间表
        service.costPush(entity);

        return CommonResponse.success("回调处理成功！");

    	
//    	PaySporadicEntity entity = service.selectById(billId);
//        entity.setApproveTime(new Date());
//        service.saveOrUpdate(entity);
//        logger.info("进入审批后回写--- entity:"+entity);
//        
//        Long projectId=entity.getProjectId();
//        List<Long> ids=new ArrayList<Long>();
//        ids.add(projectId);
//        List<ProjectRegisterVO> ProjectRegisterVOList= mbsUtils.queryProjectByIds(ids);
//        ProjectRegisterVO projectRegisterVO=new ProjectRegisterVO();
//        if(ProjectRegisterVOList!=null && ProjectRegisterVOList.size()>0) {
//        	projectRegisterVO=ProjectRegisterVOList.get(0);
//        }
//        logger.info("打印项目属性--- projectRegisterVO:"+projectRegisterVO.toString());
//        //判断项目是否启用业资一体化
//        if(projectRegisterVO !=null) {
//        	if("1".equals(projectRegisterVO.getIsSendMbs())) {
//        		logger.info("开始推送业资一体化--- entity:"+entity.toString());
//        		//生成业资数据并推送
//        		if(!bankPayInfo(entity)) {
//        			return CommonResponse.error("网银类付款推送资金系统失败");
//        		}
//        	}
//        }
//        
//        return CommonResponse.success("回调处理成功！");
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TO DO 结算单是否被其他引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        if(res.isSuccess()) {//单据未被下游单据引用
        }else{
            return CommonResponse.error(res.getMsg());
        }
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PaySporadicEntity entity = service.selectById(billId);
        
     // 删除NC传应付单凭证
        if(StringUtils.isNotEmpty(entity.getSourceId())){
            String[] split = entity.getSourceId().split(",");
            for (String sourceId : split){
                JSONObject json = new JSONObject();
                json.put("busitype", "deletepaybill");
                json.put("pk_bill", sourceId);
                ncUtil.postByJson(json.toJSONString());// 调用NC传凭证接口
            }

            LambdaUpdateWrapper<PaySporadicEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(PaySporadicEntity::getSourceId,null);
            wrapper.eq(PaySporadicEntity::getId,billId);
            service.update(wrapper);
        }
        
        entity.setPayMny(null);
        entity.setPayStatus(1);
        entity.setApproveTime(null);
        service.saveOrUpdate(entity);
        logger.info("进入审批后回写--- entity:"+entity);
        //成本改造
        //删除成本中心数据, 更新关联状态为未关联
        service.pullCost(billId);
        return CommonResponse.success("回调处理成功！");
    }
    
	// 合同过程款网银支付生成支付单并推送MBS
	public boolean bankPayInfo(PaySporadicEntity entity) {

		logger.info("开始生成实际支付单据");
		logger.info("entity实体参数---------" + entity.getId() + "是否网银" + entity.getPaymentMethodName()
				+ entity.getPaymentMethod());
		
		// 预付款生成实付信息（预付款无结算明细）
		if ("网银".equals(entity.getPaymentMethodName())) {
			logger.info("开始生成预付款网银类实际支付单据");
			PayInfoEntity bankPayInfo = new PayInfoEntity();
			bankPayInfo.setBillState(0);
			bankPayInfo.setCreateUserCode(entity.getCreateUserCode());
			bankPayInfo.setCreateTime(entity.getApproveTime());
			bankPayInfo.setDr(0);
			bankPayInfo.setTenantId(entity.getTenantId());
			bankPayInfo.setPayapplyId(entity.getId());
			bankPayInfo.setPayapplyCode(entity.getBillCode());
			bankPayInfo.setProjectName(entity.getProjectName());
			bankPayInfo.setProjectId(entity.getProjectId());
			bankPayInfo.setOrgId(entity.getOrgId());
			bankPayInfo.setOrgName(entity.getOrgName());
			bankPayInfo.setReceiveUnitId(entity.getSupplierId());
			bankPayInfo.setReceiveUnitName(entity.getSupplierName());
			bankPayInfo.setAccountBank(entity.getAccountBank());
			bankPayInfo.setAccountBankCode(entity.getAccountBankCode());
			bankPayInfo.setAccountBankId(entity.getAccountBankId());
			bankPayInfo.setAccountNum(entity.getAccountNum());
			bankPayInfo.setAccountName(entity.getAccountName());
			bankPayInfo.setCollectionType(entity.getCollectionType());
			bankPayInfo.setIsBank("Y");
			bankPayInfo.setApplyUserName(entity.getApplyUserName());
			bankPayInfo.setApplyTime(entity.getApplyTime());
			bankPayInfo.setPayInfoType("LX");
			bankPayInfo.setSettlePaymentMethod(1460207005128986625L);
			bankPayInfo.setSettlePaymentMethodName("网银");
			bankPayInfo.setApplyMny(entity.getApplyMny());
			bankPayInfo.setActualBankCode(entity.getActualBankCode());
			bankPayInfo.setResult("0");//NC推送状态默认为未推送
			PayInfoVO payInfoVo = BeanMapper.map(bankPayInfo, PayInfoVO.class);
			logger.info("打印支付单实体----" + payInfoVo.toString());
			payInfoVo = payInfoService.insertOrUpdate(payInfoVo);
			PayReqDetail payReqDetail = makeMbs(payInfoVo, null);

			try {
				//推送至资金系统
	    		PayMbsRespVo payMbsRespVo=mbsService.sendPay(payReqDetail, payInfoVo);

	    		if (!"0".equals(payMbsRespVo.getPub().getRESPCODE())) {
	    			return false;
	    		}
			} catch (Exception e) {
				return false;
			}
		}
		return true;
	}
    
    public PayReqDetail makeMbs (PayInfoVO payInfoVo,PayContractSettleEntity payContractSettleEntity) {
    	logger.info("开始生成推送报文实体");
        List<Long> ids=new ArrayList<Long>();
        ids.add(payInfoVo.getProjectId());
        List<ProjectRegisterVO> ProjectRegisterVOList= mbsUtils.queryProjectByIds(ids);
        ProjectRegisterVO projectRegisterVO=new ProjectRegisterVO();
        if(ProjectRegisterVOList!=null && ProjectRegisterVOList.size()>0) {
        	projectRegisterVO=ProjectRegisterVOList.get(0);
        }
		PayReqDetail payDetail=new PayReqDetail();
		payDetail.setSRCSERIALNO(payInfoVo.getId().toString());//明细业务主键
		payDetail.setSRCNOTECODE(payInfoVo.getBillCode());//明细业务编码
		payDetail.setORGCODE(projectRegisterVO.getMbsDept());//单据所属组织
		payDetail.setAPPLYORGCODE(projectRegisterVO.getMbsDept());//付款申请组织
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String now = dateFormat.format(new Date());
		payDetail.setPAYDATE(now);//应付款日期
		payDetail.setPAYTYPECODE("103");//交易类型 
		payDetail.setSETTLEMENTMODECODE(projectRegisterVO.getWySettleCode());//结算方式代码 
		payDetail.setISURGENT("0");//不加急
		payDetail.setPURPOSE(payInfoVo.getMemo());//用途
		payDetail.setOURORGCODE(projectRegisterVO.getMbsDept());//付方组织
		payDetail.setOURBANKACCOUNTNUMBER(payInfoVo.getActualBankCode());//付方账号
		payDetail.setOURCURCODE("CNY");
		payDetail.setOPPPRIVATEFLAG("2");
		if(payContractSettleEntity !=null) {
			payDetail.setOURAMOUNT(payContractSettleEntity.getBodyApplyMny().setScale(4, RoundingMode.HALF_UP).toString());//金额
		}else {
			payDetail.setOURAMOUNT(payInfoVo.getApplyMny().setScale(4, RoundingMode.HALF_UP).toString());//金额
		}
		payDetail.setOPPOBJECTNAME(payInfoVo.getReceiveUnitName());//收方名称
		payDetail.setOPPBANKLOCATIONCODE(payInfoVo.getAccountBankCode());//收方开户银行代码
		payDetail.setOPPBANKACCOUNTNUMBER(payInfoVo.getAccountNum());//收方账号
		payDetail.setOPPBANKACCOUNTNAME(payInfoVo.getAccountName());//收方账号名称
		payDetail.setOPPDIRECTCURCODE("CNY");//收方币种
		logger.info("打印推送报文实体"+payDetail.toString());
		return payDetail;
    }
}
