package com.ejianc.business.finance.controller;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.finance.bean.CarNoEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.service.ICarNoService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.finance.vo.CarNoVO;
import com.ejianc.business.finance.vo.PayReimburseFeetypeVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.pub.utils.HttpTookit;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-05-28
 */
@Controller
@RequestMapping("/payReimburse")
public class PayReimburseController {

    private static final long serialVersionUID = 1L;
    
    @Value("${nc.ncSeUrl}")
    private String ncSeUrl;
    
    @Autowired
	private NCUtil ncUtil;

    @Autowired
    private IPayReimburseService payReimburseService;
    
    @Autowired
    private ICarNoService carNoService;

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 新增或者修改
     * @param payReimburseVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayReimburseVO> saveOrUpdate(@RequestBody PayReimburseVO payReimburseVO) {
        PayReimburseVO backVO = payReimburseService.insertOrUpdate(payReimburseVO);
        return CommonResponse.success("保存或修改单据成功！", backVO);
    }
    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayReimburseVO> queryDetail(Long id) {
        PayReimburseVO backVO = payReimburseService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", backVO);
    }
    
    /**
     * @Author zhyj
     * @Date 2023/5/16
     * @Description industry 查询项目是否开启业财一体化
     * @param projectId
     * @Return 
     */
    @RequestMapping(value = "/industry", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> industry(Long projectId) {
		ProjectRegisterVO projects = ncUtil.queryProjectByIds(Arrays.asList(projectId)).get(0);
		String industry = projects.getIndustryIntegrationFlag();
//		System.out.println("是否开启业财一体化结果："+industry);
        return CommonResponse.success("查询数据成功！", industry);
    }
    
    /**
     * @Author zhyj
     * @Date 2023/5/16
     * @Description isSendMbs 查询项目是否开启业资一体化
     * @param projectId
     * @Return 
     */
    @RequestMapping(value = "/isSendMbs", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> issendmbs(Long projectId) {
		ProjectRegisterVO projects = ncUtil.queryProjectByIds(Arrays.asList(projectId)).get(0);
		String isSendMbs = projects.getIsSendMbs();
		System.out.println("是否开启业资一体化结果："+isSendMbs);
        return CommonResponse.success("查询数据成功！", isSendMbs);
    }
    
    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description queryPrint 查询打印详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("PayReimburse", payReimburseService.queryDetail(id));
        return CommonResponse.success("查询打印数据成功！",json);
    }

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", QueryParam.DESC);
//        param.getParams().put("createUserCode",new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
        JSONObject page = payReimburseService.queryPageJson(param,false);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryApproveList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryApproveList(@RequestBody QueryParam param) {
        //已生效状态的单据
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        param.getOrderMap().put("approveTime", QueryParam.DESC);
        JSONObject page = payReimburseService.queryPageJson(param,false);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayReimburseVO> vos) {
        List<Long> ids = vos.stream().map(PayReimburseVO::getId).collect(Collectors.toList());
        String msg = payReimburseService.delete(ids);
        return CommonResponse.success(msg);
    }


    /**
     * excel导出
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        //queryParam.getParams().put("createUserCode",new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
        List<PayReimburseVO> supplierVos = payReimburseService.queryExportList(queryParam);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("reim-payapply-export.xlsx", beans, response);
    }

    /**
     * 支出管理excel导出
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportApprove", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportApprove(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        //已生效状态的单据
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        List<PayReimburseVO> supplierVos = payReimburseService.queryExportList(queryParam);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("reim-payapply-export.xlsx", beans, response);
    }


    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description refer 商机登记列表参照
     *
     * @Param [pageNumber, pageSize, searchText]
     * @Return com.alibaba.fastjson.JSONObject
     */
    @RequestMapping(value = "/refer")
    @ResponseBody
    public JSONObject refer(@RequestParam(defaultValue = "1") Integer pageNumber,
                            @RequestParam(defaultValue = "10") Integer pageSize,
                            String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("address");
        fuzzyFields.add("area");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("engineeringTypeName");
        fuzzyFields.add("infoSourceName");
        fuzzyFields.add("followPersonName");
        fuzzyFields.add("constructionUnitName");
        IPage<PayReimburseEntity> pageData = payReimburseService.queryPage(queryParam,false);
        Page<PayReimburseEntity> page = new PageImpl<>(pageData.getRecords(),new PageRequest(pageNumber,pageSize),pageData.getTotal());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", page);
        jsonObject.put("code", "success");
        jsonObject.put("msg", "查询数表参照成功");
        return jsonObject;
    }

    /**
     * 查询收款账户信息
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/queryReceiveInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayReimburseVO> queryReceiveInfo(QueryParam queryParam) {
        queryParam.getParams().put("applyUserId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
        //已生效状态的单据
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<PayReimburseEntity> entityList = payReimburseService.queryList(queryParam,false);
        PayReimburseVO backVO = !entityList.isEmpty() ? BeanMapper.map( entityList.get(0), PayReimburseVO.class) : new PayReimburseVO();
        return CommonResponse.success("查询数据成功！", backVO);
    }
    /**成本改造
     * 关联保存接口
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayReimburseVO> pushCost(@RequestBody PayReimburseVO paySporadicVO) {
        return payReimburseService.pushCost(paySporadicVO);
    }

    /**
     * @Author 曹鹏辉
     * @Date 2021/9/17
     * @Description 获取合计栏信息(累计申请金额总计，累计支付金额总计)
     * @Param
     * @Return com.ejianc.framework.core.response.CommonResponse<TotalColumnVO>
     */
    @RequestMapping(value = "getTotalColumnInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TotalColumnVO> getTotalColumnInfo(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", QueryParam.DESC);
        param.getParams().put("createUserCode",new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
        return CommonResponse.success("查询成功！", payReimburseService.getTotalColumnInfo(param, false));
    }

    /**
     * @Author 曹鹏辉
     * @Date 2021/9/17
     * @Description 获取支出管理 合计栏信息(累计申请金额总计，累计支付金额总计)
     * @Param
     * @Return com.ejianc.framework.core.response.CommonResponse<TotalColumnVO>
     */
    @RequestMapping(value = "getApproveTotalColumnInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TotalColumnVO> getApproveTotalColumnInfo(@RequestBody QueryParam param) {
        //已生效状态的单据
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        param.getOrderMap().put("approveTime", QueryParam.DESC);
        return CommonResponse.success("查询成功！", payReimburseService.getApproveTotalColumnInfo(param, false));
    }
    
//    /**
//     * @Author zhyj
//     * @Date 2023/5/15
//     * @Description 获取NC车号信息
//     * @Param
//     * @Return com.ejianc.framework.core.response.CommonResponse<TotalColumnVO>
//     */
//    @RequestMapping(value = "getCarno", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<List<Object>> getCarno(String param) {
//    	
//    	QueryParam queryParam = new QueryParam();
//    	queryParam.getParams().put("code", new Parameter(QueryParam.NE, null));
//    	List<CarNoEntity> list = carNoService.queryList(queryParam);//查询数据库中现有的车号信息
//    	
//		SimpleDateFormat enddate = new SimpleDateFormat("yyyy-MM-dd");
//    	param="{\"busitype\":\"carno\",\"begindate\":\"2000-01-01\",\"enddate\": \""+ enddate +"\"}";
//    	//查询2000年至今的车号信息
//    	List<Object> carnolist = new ArrayList<Object>();
//		
//    	Map<String, String> headers = new HashMap<>();
//        String back = null;
//        try {
//            back = HttpTookit.postByJson(ncSeUrl, param, headers);
//        } catch (Exception e) {
//            try {
//                back = HttpTookit.postByJson(ncSeUrl, param, headers);
//            } catch (Exception e1) {
//                throw new BusinessException("查询车牌接口异常!");
//            }
//        }
//        if(!back.contains("code")){
//            throw new BusinessException("返回值解析异常!");
//        }
//        JSONObject json = JSONObject.parseObject(back);
//        if(!"1".equals(json.getString("success"))){
//            throw new BusinessException(json.getString("msg"));
//        }else{
//        	List<Object> result = json.getJSONArray("result");
//        	for(int i =0;i<result.size();i++) {//逐条获取车号信息
//        		Object object = result.get(i);
//        		Map<String, Object> mess = (Map<String, Object>) object;
//        		Integer dr = (Integer) mess.get("dr");
//        		Integer enable = (Integer) mess.get("enablestate");
//        		String orgcode = (String) mess.get("orgcode");
//				String name = (String) mess.get("name");
//				String code  = (String) mess.get("code");
//				String ncid = (String) mess.get("id");
//				//获取车号详细数据
//        		if(dr !=null || enable!=null) {
//        			if(list.size()!=0) {
//        				CarNoVO carNoVO = carNoService.selectByNcid(ncid);
//        				if(carNoVO != null) {
//            				carNoVO.setCode(code);
//            				carNoVO.setDr(dr);
//            				carNoVO.setEnablestate(enable);
//                			carNoVO.setOrgcode(orgcode);
//                			carNoVO.setName(name);
//                			carNoService.insertOrUpdate(carNoVO);
//            			}else {
//            				CarNoVO carno = new CarNoVO();
//        					carno.setCode(code);
//                			carno.setDr(dr);
//                			carno.setEnablestate(enable);
//                			carno.setOrgcode(orgcode);
//                			carno.setName(name);
//                			carno.setNcid(ncid);
//                			carNoService.insertOrUpdate(carno);
//            			}
//        			}else {
//        				CarNoVO carno = new CarNoVO();
//    					carno.setCode(code);
//            			carno.setDr(dr);
//            			carno.setEnablestate(enable);
//            			carno.setOrgcode(orgcode);
//            			carno.setName(name);
//            			carno.setNcid(ncid);
//            			carNoService.insertOrUpdate(carno);
//        			}
//        			
//        		}
//        	}
//        }
//        return CommonResponse.success("参照查询成功！", carnolist);
//    }

    
}
