package com.ejianc.business.finance.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.business.finance.bean.PayReimburseFeetypeEntity;
import com.ejianc.business.finance.service.IPayReimburseFeetypeService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;

/**
 * 其他费用费用类别
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("/payReimburseFeetype")
public class PayReimburseFeetypeController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IPayReimburseFeetypeService payReimburseFeetypeService;

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refPayReimburseFeetype", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> refPayReimburseFeetype(@RequestParam(value = "searchText", required = false) String searchText,
                                           @RequestParam(value = "condition", required = false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("feetypeName");
        param.getFuzzyFields().add("feetypeCode");
        param.getFuzzyFields().add("isScient");
        param.getFuzzyFields().add("isCar");
        param.getOrderMap().put("feetypeCode", "asc");
        List<PayReimburseFeetypeEntity> list = payReimburseFeetypeService.queryList(param, false);
        List<Map> resultMapList = new ArrayList<Map>();
        Map map = null;
        for(PayReimburseFeetypeEntity entity:list) {
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getFeetypeName());
            map.put("code", entity.getFeetypeCode());
            map.put("scient", entity.getIsScient());
            map.put("car", entity.getIsCar());
            map.put("parentId", entity.getParentId());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }
    
    //会计科目导入后父id更新语句
//    UPDATE ejc_finance_pay_reimburse_feetype a
//    LEFT JOIN ejc_finance_pay_reimburse_feetype b ON LEFT ( a.id, length( a.id )- 2 )= b.id 
//    SET a.parent_id = b.id
    
//    UPDATE ejc_finance_pay_reimburse_feetype SET is_scient = 'Y' where assist_calculate = ' 部门, 项目, 研发项目' and is_last = '是'
//    UPDATE ejc_finance_pay_reimburse_feetype SET is_car = 'Y' where assist_calculate = ' 部门, 项目, 车号' and is_last = '是'
    
    /**
     * @Author zhyj
     * @Date 2023/6/7
     * @Description queryFeetype 查询费用类别详细信息,判断是否需要车号与研究项目字段
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/scientproject", method = RequestMethod.GET)            
    @ResponseBody
    public CommonResponse<PayReimburseFeetypeEntity> queryFeetype(Long id) {
    	PayReimburseFeetypeEntity backEntity = payReimburseFeetypeService.queryFeetype(id);
        return CommonResponse.success("查询数据成功！", backEntity);
    }
    
}
