package com.ejianc.business.finance.mbs.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayContractSettleEntity;
import com.ejianc.business.finance.mbs.bean.bank.BankEntity;
import com.ejianc.business.finance.mbs.bean.bank.request.*;
import com.ejianc.business.finance.mbs.bean.bank.response.*;
import com.ejianc.business.finance.mbs.bean.pay.request.*;
import com.ejianc.business.finance.mbs.bean.pay.response.*;
import com.ejianc.business.finance.mbs.bean.payInfo.request.*;
import com.ejianc.business.finance.mbs.bean.payInfo.response.*;
import com.ejianc.business.finance.mbs.mapper.BankMapper;
import com.ejianc.business.finance.service.IPayInfoService;
import com.ejianc.business.finance.utils.XmlUtils;
import com.ejianc.business.finance.vo.PayInfoVO;
import com.ejianc.support.idworker.util.IdWorker;

@Service("mbsService")
public class MbsService {

	@Autowired
	private IBankService bankService;
	
    @Value("${mbs.mbsUrl}")
    private String URL;
    
	//密码盐
    @Value("${mbs.MD5Key}")
	private String MD5Key;

    @Value("${common.env.base-host}")
    private String BASE_HOST;//运行环境域名
	//指令
	//查询银行
	private String BankTRANSCODE="PBQB01";
	//推送支付
	private String PayTRANSCODE="PMSQ01";
	//查询支付状态
	private String PayInfoTRANSCODE="GETPAYINFO";

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	//获取银行信息
	public void getMbsBankInfo() throws Exception {
		//银行档案实例
		List<BankEntity> bankList= new ArrayList<BankEntity>();
		
		//查询页数，每页条数
		BankReqHeadVo bankHeadVo=new BankReqHeadVo(1,100);
		//时间格式化 查询数据时间
		Date today = new Date();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		String LASTMODIFIEDONSTART=sdf.format(today);
		String LASTMODIFIEDONEND=sdf.format(today);
		SimpleDateFormat sdfCodeF = new SimpleDateFormat("yyyyMMdd");
		String getCode=sdfCodeF.format(today);
		BankReqSearchonditionsVo bankSearchonditionsVo=new BankReqSearchonditionsVo(LASTMODIFIEDONSTART,LASTMODIFIEDONEND);
		BankReqVo bankReqVo=new BankReqVo(bankHeadVo,bankSearchonditionsVo);
		BankMbsReqVo mbsVo=new BankMbsReqVo();
		mbsVo.setReq(bankReqVo);
		String MD5=md5String(XmlUtils.getXmlFromObject(bankReqVo),MD5Key);
		//拼接pub 
		BankPubReqVo pubVo=new BankPubReqVo(getCode,BankTRANSCODE,MD5);
		mbsVo.setPub(pubVo);
		String xmlStr=XmlUtils.getXmlFromObject(mbsVo);
		xmlStr=splicingXmlRequest(xmlStr);
        System.out.println(xmlStr);
		//推送获取返回结果
		String sendResult = XmlUtils.sendXml(xmlStr,URL);
		sendResult=splicingXmlResponse(sendResult);
		System.out.println(sendResult);	
		//XML转换为Bean
		BankMbsRespVo mbsResponseVo=new BankMbsRespVo();
		mbsResponseVo=(BankMbsRespVo)XmlUtils.getObjectFromXml(mbsResponseVo, sendResult);
		//获取总页数
		int pageNum=mbsResponseVo.getResp().getPAGECOUNT();
		//页数大于1,需要循环遍历继续查询
		if(pageNum>1) {
			for (int i = 1; i > pageNum; i++) {
				mbsVo.getReq().getHead().setPAGEINDEX(i);
				sendResult = XmlUtils.sendXml(xmlStr,URL);
				mbsResponseVo=(BankMbsRespVo)XmlUtils.getObjectFromXml(mbsResponseVo, sendResult);
				List<BankRespDetail> detail = mbsResponseVo.getResp().getList().getDetail();
				for (BankRespDetail bankRespDetail : detail) {
					BankEntity entity=new BankEntity();
					entity.setId(IdWorker.getId());
					entity.setShortName(bankRespDetail.getName());
					entity.setName(bankRespDetail.getName());
					entity.setCode(bankRespDetail.getBankcode());
					entity.setBankCategoryId(null);
					entity.setBankCategoryName(null);
					bankList.add(entity);
				}
				//TODO 写入银行档案List中，保存实例到数据库中
				
			}
		}else {
			//TODO 写入银行档案List中，保存实例到数据库中
			List<BankRespDetail> detail = mbsResponseVo.getResp().getList().getDetail();
			for (BankRespDetail bankRespDetail : detail) {
				BankEntity entity=new BankEntity();
				entity.setId(IdWorker.getId());
				entity.setShortName(bankRespDetail.getName());
				entity.setName(bankRespDetail.getName());
				entity.setCode(bankRespDetail.getBankcode());
				entity.setBankCategoryId(null);
				entity.setBankCategoryName(null);
				bankList.add(entity);
			}
		}
		for (BankEntity bankEntity : bankList) {
			QueryWrapper<BankEntity> bankWrapper=new QueryWrapper<BankEntity>();
			bankWrapper.eq("code", bankEntity.getCode()).eq("dr", 0);
			List<BankEntity> entityList=bankService.list(bankWrapper);
			if(entityList.size()>0) {
				bankEntity.setId(entityList.get(0).getId());
				bankEntity.setCreateTime(entityList.get(0).getCreateTime());
				bankEntity.setCreateUserCode(entityList.get(0).getCreateUserCode());
			}
			bankService.saveOrUpdate(bankEntity);
		}
	}
	
	//推送支付信息至资金系统
	public PayMbsRespVo sendPay(PayReqDetail payDetail,PayInfoVO payInfoVO)throws Exception {
		logger.info("开始推送资金系统");
		int ALLCOUNT=1;
		PayMbsReqVo mbsReqVo=new PayMbsReqVo();
		PayReqVo req=new PayReqVo();
		PayReqHeadVo head=new PayReqHeadVo();
		PayReqList list=new PayReqList();
		head.setALLAMOUNT(new BigDecimal(payDetail.getOURAMOUNT()).setScale(4, RoundingMode.HALF_UP));
		head.setALLCOUNT(ALLCOUNT);
		List<PayReqDetail> payReqDetail=new ArrayList<PayReqDetail>();
		payReqDetail.add(payDetail);
		list.setDetail(payReqDetail);
		req.setHead(head);
		req.setList(list);
		mbsReqVo.setReq(req);
		String reqString=XmlUtils.getXmlFromObject(req);
		logger.info("打印reqString-----"+reqString);
		String MD5=md5String(reqString,MD5Key);
		logger.info("打印MD5密文-----"+MD5);
		PayPubReqVo pubReqVo=new PayPubReqVo(payDetail.getSRCSERIALNO(),PayTRANSCODE,MD5);
		mbsReqVo.setPub(pubReqVo);
		String xmlStr=XmlUtils.getXmlFromObject(mbsReqVo);
		logger.info("推送MBS报文--- xmlStr1:"+xmlStr);
		xmlStr=splicingXmlRequest(xmlStr);
        System.out.println(xmlStr);
        logger.info("推送MBS报文--- xmlStr:"+xmlStr);
        
		
        
        logger.info("推送MBS地址--- URL:"+URL);
		//推送获取返回结果
        
		String sendResult = XmlUtils.sendXml(xmlStr,URL);
		sendResult=splicingXmlResponse(sendResult);
		System.out.println(sendResult);	
		//XML转换为Bean
		PayMbsRespVo payMbsRespVo=new PayMbsRespVo();
		payMbsRespVo=(PayMbsRespVo)XmlUtils.getObjectFromXml(payMbsRespVo, sendResult);
		logger.info("MBS返回报文--- xmlStr:"+sendResult);
		
		payInfoVO.setSendMbsMsg(xmlStr);//业资推送报文
		payInfoVO.setSendMbsResult(sendResult);//业资推送返回报文
		//payInfoService.insertOrUpdate(payInfoVO);
		 
		return payMbsRespVo;
	}
	
	//推送支付信息至资金系统
	public void getPayInfo()throws Exception {
		//TODO 查询单号
		String SRCSERIALNO=null;
		PayInfoMbsReqVo mbsReqVo=new PayInfoMbsReqVo();
		mbsReqVo.getReq().getSearchconditions().setSRCSERIALNO(SRCSERIALNO);
		String MD5=md5String(XmlUtils.getXmlFromObject(mbsReqVo.getReq()),MD5Key);
		PayInfoPubReqVo pubReqVo=new PayInfoPubReqVo(SRCSERIALNO,PayTRANSCODE,MD5);
		mbsReqVo.setPub(pubReqVo);
		String xmlStr=XmlUtils.getXmlFromObject(mbsReqVo);
		xmlStr=splicingXmlRequest(xmlStr);
        System.out.println(xmlStr);
		//推送获取返回结果
		String sendResult = XmlUtils.sendXml(xmlStr,URL);
		sendResult=splicingXmlResponse(sendResult);
		System.out.println(sendResult);	
		//XML转换为Bean
		PayInfoMbsRespVo payMbsRespVo=new PayInfoMbsRespVo();
		payMbsRespVo=(PayInfoMbsRespVo)XmlUtils.getObjectFromXml(payMbsRespVo, sendResult);
	}
	//request转
	private String splicingXmlRequest(String xml) {
		//拼接格式
		xml="<?xml version=\"1.0\" encoding=\"UTF-8\"?>"+xml;
		xml="<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:out=\"http://outsystem.ats.com.cn\"><soapenv:Header/><soapenv:Body><out:outSystemWS><out:in0><![CDATA["+xml+"]]></out:in0></out:outSystemWS></soapenv:Body></soapenv:Envelope>";
		return xml;
	}
	
	private String splicingXmlResponse(String xml) {
		//转义
		xml = StringEscapeUtils.unescapeXml(xml);
		//拼接获取XML
		int a=xml.indexOf("<MBS>");
		int b=xml.indexOf("</MBS>");
		xml=StringUtils.substring(xml, a, b)+"</MBS>";
		return xml;
	}
	
	private static String md5String(String md5String,String md5Key){
	    String md5Value = MD5Encoder(md5String + md5Key);
	    return md5Value;
	}
	
	public final static String MD5Encoder(String s) {
	    return MD5Encoder(s,"utf-8");
	}

	public final static String MD5Encoder(String s, String charset) {
	    try {
	        byte[] btInput = s.getBytes(charset);
	        MessageDigest mdInst = MessageDigest.getInstance("MD5");
	        mdInst.update(btInput);
	        byte[] md = mdInst.digest();
	        StringBuffer sb = new StringBuffer();
	        for (int i = 0; i < md.length; i++) {
	            int val = ((int) md[i]) & 0xff;
	            if (val < 16){
	                sb.append("0");
	            }
	            sb.append(Integer.toHexString(val));
	        }
	        return sb.toString();
	    } catch (Exception e) {
	        return null;
	    }
	}
}
