package com.ejianc.business.finance.mbs.task;

import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.CarNoEntity;
import com.ejianc.business.finance.bean.PayInfoEntity;
import com.ejianc.business.finance.mbs.bean.bank.BankEntity;
import com.ejianc.business.finance.mbs.bean.bank.request.BankMbsReqVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankPubReqVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankReqHeadVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankReqSearchonditionsVo;
import com.ejianc.business.finance.mbs.bean.bank.request.BankReqVo;
import com.ejianc.business.finance.mbs.bean.bank.response.BankMbsRespVo;
import com.ejianc.business.finance.mbs.bean.bank.response.BankRespDetail;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoMbsReqVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoPubReqVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoReqHeadVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoReqSearchonditionsVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoReqVo;
import com.ejianc.business.finance.mbs.bean.payInfo.response.PayInfoMbsRespVo;
import com.ejianc.business.finance.mbs.service.IBankService;
import com.ejianc.business.finance.service.ICarNoService;
import com.ejianc.business.finance.service.IPayInfoService;
import com.ejianc.business.finance.utils.XmlUtils;
import com.ejianc.business.finance.vo.CarNoVO;
import com.ejianc.business.finance.vo.PayInfoVO;
import com.ejianc.business.pub.utils.HttpTookit;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;

@Component
public class MbsTask {
	@Autowired
	IBankService bankService;
	@Autowired
	IPayInfoService payInfoService;
	

    @Value("${mbs.mbsUrl}")
    private String URL;
    
    @Value("${nc.ncSeUrl}")
    private String ncSeUrl;
    
	//密码盐
    @Value("${mbs.MD5Key}")
	private String MD5Key;
	//指令
	//查询银行
	private String BankTRANSCODE="PBQB01";
	//推送支付
	private String PayTRANSCODE="PMSQ01";
	//查询支付状态
	private String PayInfoTRANSCODE="GETPAYINFO";

	@Autowired
    private IDefdocApi defdocApi;
	
	@Autowired
    private ICarNoService carNoService;
	

	
	@Scheduled(cron = "0 0 0 * * ?")  //间隔1秒
    public void saveMbsBankInfo() throws Exception {
		//银行档案实例
		List<BankEntity> bankList= new ArrayList<BankEntity>();
		
		//查询页数，每页条数
		BankReqHeadVo bankHeadVo=new BankReqHeadVo(1,100);
		//时间格式化 查询数据时间
		Date today = new Date();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		String LASTMODIFIEDONSTART=sdf.format(today);
		String LASTMODIFIEDONEND=sdf.format(today);
		SimpleDateFormat sdfCodeF = new SimpleDateFormat("yyyyMMdd");
		String getCode=sdfCodeF.format(today);
		BankReqSearchonditionsVo bankSearchonditionsVo=new BankReqSearchonditionsVo("2023-01-01",LASTMODIFIEDONEND);
		BankReqVo bankReqVo=new BankReqVo(bankHeadVo,bankSearchonditionsVo);
		BankMbsReqVo mbsVo=new BankMbsReqVo();
		mbsVo.setReq(bankReqVo);
		String MD5=md5String(XmlUtils.getXmlFromObject(bankReqVo),MD5Key);
		//拼接pub 
		BankPubReqVo pubVo=new BankPubReqVo(getCode,BankTRANSCODE,MD5);
		mbsVo.setPub(pubVo);
		String xmlStr=XmlUtils.getXmlFromObject(mbsVo);
		xmlStr=splicingXmlRequest(xmlStr);
        System.out.println(xmlStr);
		//推送获取返回结果
		String sendResult = XmlUtils.sendXml(xmlStr,URL);
		sendResult=splicingXmlResponse(sendResult);
		System.out.println(sendResult);	
		//XML转换为Bean
		BankMbsRespVo mbsResponseVo=new BankMbsRespVo();
		mbsResponseVo=(BankMbsRespVo)XmlUtils.getObjectFromXml(mbsResponseVo, sendResult);
		//获取总页数
		int pageNum=mbsResponseVo.getResp().getPAGECOUNT();
		//页数大于1,需要循环遍历继续查询
		if(pageNum>1) {
			for (int i = 1; i > pageNum; i++) {
				mbsVo.getReq().getHead().setPAGEINDEX(i);
				sendResult = XmlUtils.sendXml(xmlStr,URL);
				mbsResponseVo=(BankMbsRespVo)XmlUtils.getObjectFromXml(mbsResponseVo, sendResult);
				List<BankRespDetail> detail = mbsResponseVo.getResp().getList().getDetail();
				for (BankRespDetail bankRespDetail : detail) {
					BankEntity entity=new BankEntity();
					entity.setId(IdWorker.getId());
					entity.setShortName(bankRespDetail.getName());
					entity.setName(bankRespDetail.getName());
					entity.setCode(bankRespDetail.getBankcode());
					entity.setBankCategoryId(null);
					entity.setBankCategoryName(null);
					bankList.add(entity);
				}
				//TODO 写入银行档案List中，保存实例到数据库中
				
			}
		}else if (pageNum==1) {
			//TODO 写入银行档案List中，保存实例到数据库中
			List<BankRespDetail> detail = mbsResponseVo.getResp().getList().getDetail();
			for (BankRespDetail bankRespDetail : detail) {
				BankEntity entity=new BankEntity();
				entity.setId(IdWorker.getId());
				entity.setShortName(bankRespDetail.getName());
				entity.setName(bankRespDetail.getName());
				entity.setCode(bankRespDetail.getBankcode());
				entity.setBankCategoryId(null);
				entity.setBankCategoryName(null);
				bankList.add(entity);
			}
		}
		if(bankList != null) {
		for (BankEntity bankEntity : bankList) {
			QueryWrapper<BankEntity> bankWrapper=new QueryWrapper<BankEntity>();
			bankWrapper.eq("code", bankEntity.getCode()).eq("dr", 0);
			List<BankEntity> entityList=bankService.list(bankWrapper);
			if(entityList.size()>0) {
				bankEntity.setId(entityList.get(0).getId());
				bankEntity.setCreateTime(entityList.get(0).getCreateTime());
				bankEntity.setCreateUserCode(entityList.get(0).getCreateUserCode());
			}
			bankService.saveOrUpdate(bankEntity);
		}
		}
	}
	//推送支付信息至资金系统
			@Scheduled(cron = "0 0 0,12,19 * * ? ")  //12、24点进行一次 
			public void getPayInfo()throws Exception {
				QueryParam queryParam = new QueryParam();
				queryParam.getParams().put("is_bank",new Parameter(QueryParam.EQ,"Y"));//是否网银类付款
				queryParam.getParams().put("dr",new Parameter(QueryParam.EQ,"0"));//是否网银类付款
				//获取需要更新的数据
				List<PayInfoEntity> payInfoList=payInfoService.queryList(queryParam);//查找网银类的三天前的数据
				String SRCSERIALNO=null;
				PayInfoMbsReqVo mbsReqVo=new PayInfoMbsReqVo();
				PayInfoReqHeadVo head=new PayInfoReqHeadVo(1, 10);
				PayInfoReqSearchonditionsVo searchconditions=new PayInfoReqSearchonditionsVo();
				PayInfoReqVo req=new PayInfoReqVo();
				for (PayInfoEntity payInfoEntity : payInfoList) {
					SRCSERIALNO=payInfoEntity.getId().toString();
					searchconditions.setSRCSERIALNO(SRCSERIALNO);
					req.setHead(head);
					req.setSearchconditions(searchconditions);
					mbsReqVo.setReq(req);
					String reqStr=XmlUtils.getXmlFromObject(req);
					String MD5=md5String(reqStr,MD5Key);
					PayInfoPubReqVo pubReqVo=new PayInfoPubReqVo(SRCSERIALNO,PayInfoTRANSCODE,MD5);
					mbsReqVo.setPub(pubReqVo);
					String xmlStr=XmlUtils.getXmlFromObject(mbsReqVo);
					xmlStr=splicingXmlRequest(xmlStr);
			        System.out.println(xmlStr);
					//推送获取返回结果
					String sendResult = XmlUtils.sendXml(xmlStr,URL);
					sendResult=splicingXmlResponse(sendResult);
					System.out.println(sendResult);	
					String RESPCODE=StringUtils.substringBefore(sendResult, "</RESPCODE>");
					RESPCODE=StringUtils.substringAfter(RESPCODE, "<RESPCODE>");
		    		payInfoEntity.setRenewMsg(xmlStr);//状态更新报文
		    		payInfoEntity.setRenewResult(sendResult);//状态更新返回报文
		    		String RESPMSG=StringUtils.substringBefore(sendResult, "</RESPMSG>");
					RESPCODE=StringUtils.substringAfter(RESPCODE, "<RESPMSG>");
					payInfoEntity.setPayInfo(RESPCODE);
					if("0".equals(RESPCODE)) {
						//XML转换为Bean
						PayInfoMbsRespVo payMbsRespVo=new PayInfoMbsRespVo();
						payMbsRespVo=(PayInfoMbsRespVo)XmlUtils.getObjectFromXml(payMbsRespVo, sendResult);
						String payState=payMbsRespVo.getResp().getList().getDetail().get(0).getPaystate();
						payInfoEntity.setPayStatus(Integer.valueOf(payState));
						String payInfo=payMbsRespVo.getResp().getList().getDetail().get(0).getPayinfo();
						payInfoEntity.setPayInfo(payInfo);
						payInfoService.saveOrUpdate(payInfoEntity);
						if("2".equals(payState)) {
							PayInfoVO payInfoVO=BeanMapper.map(payInfoEntity, PayInfoVO.class);
							payInfoService.batchConfirm(payInfoVO);
						}
					}
				}
			}	
//	//推送支付信息至资金系统
//	@Scheduled(cron = "0 0 0,12 * * ?")  //12、24点进行一次 
//	public void getPayInfo()throws Exception {
//        
//		QueryParam queryParam = new QueryParam();
//		queryParam.getParams().put("is_bank",new Parameter(QueryParam.EQ,"Y"));//是否网银类付款
//		queryParam.getParams().put("create_time",new Parameter(QueryParam.SQL," datediff(now(),create_time)>3 "));//3天前的数据
//		//获取需要更新的数据
//		List<PayInfoEntity> payInfoList=payInfoService.queryList(queryParam);//查找网银类的三天前的数据
//		String SRCSERIALNO=null;
//		PayInfoMbsReqVo mbsReqVo=new PayInfoMbsReqVo();
//		PayInfoReqHeadVo head=new PayInfoReqHeadVo(1, 10);
//		PayInfoReqSearchonditionsVo searchconditions=new PayInfoReqSearchonditionsVo();
//		PayInfoReqVo req=new PayInfoReqVo();
//		for (PayInfoEntity payInfoEntity : payInfoList) {
//			SRCSERIALNO=payInfoEntity.getId().toString();
//			searchconditions.setSRCSERIALNO(SRCSERIALNO);
//			req.setHead(head);
//			req.setSearchconditions(searchconditions);
//			mbsReqVo.setReq(req);
//			String MD5=md5String(XmlUtils.getXmlFromObject(mbsReqVo.getReq()),MD5Key);
//			PayInfoPubReqVo pubReqVo=new PayInfoPubReqVo(SRCSERIALNO,PayTRANSCODE,MD5);
//			mbsReqVo.setPub(pubReqVo);
//			String xmlStr=XmlUtils.getXmlFromObject(mbsReqVo);
//			xmlStr=splicingXmlRequest(xmlStr);
//	        System.out.println(xmlStr);
//			//推送获取返回结果
//			String sendResult = XmlUtils.sendXml(xmlStr,URL);
//			sendResult=splicingXmlResponse(sendResult);
//			System.out.println(sendResult);	
//			//XML转换为Bean
//			PayInfoMbsRespVo payMbsRespVo=new PayInfoMbsRespVo();
//			payMbsRespVo=(PayInfoMbsRespVo)XmlUtils.getObjectFromXml(payMbsRespVo, sendResult);
//			String payState=payMbsRespVo.getResp().getList().getDetail().get(0).getPaystate();
//    		
//    		payInfoEntity.setRenewMsg(xmlStr);//状态更新报文
//    		payInfoEntity.setRenewResult(sendResult);//状态更新返回报文
//    		
//			if("2".equals(payState)) {
//				payInfoEntity.setPayStatus(2);
//				payInfoService.saveOrUpdate(payInfoEntity);
//				PayInfoVO payInfoVO=BeanMapper.map(payInfoEntity, PayInfoVO.class);
//				List<PayInfoVO> payInfovo=new ArrayList<PayInfoVO>();
//				payInfovo.add(payInfoVO);
//				payInfoService.batchConfirm(payInfovo);
//			}else{
//				payInfoEntity.setPayStatus(Integer.parseInt(payState));
//				payInfoService.saveOrUpdate(payInfoEntity);
//			}
//		}
//
//
//
//	}
//	
//	    //取网银类 未支付成功的数据，自动推送
//		@Scheduled(cron = "0 0 0,12 * * ?")  //12、24点进行一次 
//		public void resendPayInfo()throws Exception {
//			
//			Map<String, String> allresponse = new HashMap<String,String>();
//	        
//	        CommonResponse<List<DefdocDetailVO>> response = defdocApi.getDefDocByDefCode("finance-pay-status");
//	        for (DefdocDetailVO defdocDetailVO : response.getData()) {
//	        	allresponse.put(defdocDetailVO.getCode(), defdocDetailVO.getName());
//			}
//			List<String> mbsStatusList=new ArrayList<String>();
//			mbsStatusList.add("2");//已支付状态
//			mbsStatusList.add("3");//支付失败
//			mbsStatusList.add("6");//退票
//			mbsStatusList.add("9");//部分支付
//			QueryParam queryParam = new QueryParam();
//			queryParam.getParams().put("is_bank",new Parameter(QueryParam.EQ,"Y"));//是否网银类付款
//			queryParam.getParams().put("pay_status",new Parameter(QueryParam.NOT_IN,mbsStatusList));//付款失败的单据
//			//获取需要更新的数据
//			List<PayInfoEntity> payInfoList=payInfoService.queryList(queryParam);//查找网银类付款失败的单据
//			String SRCSERIALNO=null;
//			PayInfoMbsReqVo mbsReqVo=new PayInfoMbsReqVo();
//			PayInfoReqHeadVo head=new PayInfoReqHeadVo(1, 10);
//			PayInfoReqSearchonditionsVo searchconditions=new PayInfoReqSearchonditionsVo();
//			PayInfoReqVo req=new PayInfoReqVo();
//			for (PayInfoEntity payInfoEntity : payInfoList) {
//				SRCSERIALNO=payInfoEntity.getId().toString();
//				searchconditions.setSRCSERIALNO(SRCSERIALNO);
//				req.setHead(head);
//				req.setSearchconditions(searchconditions);
//				mbsReqVo.setReq(req);
//				String MD5=md5String(XmlUtils.getXmlFromObject(mbsReqVo.getReq()),MD5Key);
//				PayInfoPubReqVo pubReqVo=new PayInfoPubReqVo(SRCSERIALNO,PayTRANSCODE,MD5);
//				mbsReqVo.setPub(pubReqVo);
//				String xmlStr=XmlUtils.getXmlFromObject(mbsReqVo);
//				xmlStr=splicingXmlRequest(xmlStr);
//		        System.out.println(xmlStr);
//				//推送获取返回结果
//				String sendResult = XmlUtils.sendXml(xmlStr,URL);
//				sendResult=splicingXmlResponse(sendResult);
//				System.out.println(sendResult);	
//				//XML转换为Bean
//				PayInfoMbsRespVo payMbsRespVo=new PayInfoMbsRespVo();
//				payMbsRespVo=(PayInfoMbsRespVo)XmlUtils.getObjectFromXml(payMbsRespVo, sendResult);
//				String payState=payMbsRespVo.getResp().getList().getDetail().get(0).getPaystate();
//				String jsonString = JSONObject.toJSON(payMbsRespVo.getResp().getList().getDetail()).toString();
//	    		int start = jsonString.indexOf("<paystate>");
//	    		int end = jsonString.indexOf("</paystate>");
//	    		String code = jsonString.substring(start, end);//截取返回的推送状态报文
//	    		//通过返回报文查找对应的自定义档案id
//	    		payInfoEntity.setResult(allresponse.get(code));
//				if("2".equals(payState)) {
//					payInfoEntity.setPayStatus(2);
//					payInfoService.saveOrUpdate(payInfoEntity);
//					PayInfoVO payInfoVO=BeanMapper.map(payInfoEntity, PayInfoVO.class);
//					List<PayInfoVO> payInfovo=new ArrayList<PayInfoVO>();
//					payInfovo.add(payInfoVO);
//					payInfoService.batchConfirm(payInfovo);
//				}else{
//					payInfoEntity.setPayStatus(Integer.parseInt(payState));
//					payInfoService.saveOrUpdate(payInfoEntity);
//				}
//			}
//
//
//
//		}
	
	
			//request转
			private String splicingXmlRequest(String xml) {
				//拼接格式
				xml="<?xml version=\"1.0\" encoding=\"UTF-8\"?>"+xml;
				xml="<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:out=\"http://outsystem.ats.com.cn\"><soapenv:Header/><soapenv:Body><out:outSystemWS><out:in0><![CDATA["+xml+"]]></out:in0></out:outSystemWS></soapenv:Body></soapenv:Envelope>";
				return xml;
			}
			
			private String splicingXmlResponse(String xml) {
				//转义
				xml = StringEscapeUtils.unescapeXml(xml);
				//拼接获取XML
				int a=xml.indexOf("<MBS>");
				int b=xml.indexOf("</MBS>");
				xml=StringUtils.substring(xml, a, b)+"</MBS>";
				return xml;
			}
			private static String md5String(String md5String,String md5Key){
			    String md5Value = MD5Encoder(md5String + md5Key);
			    return md5Value;
			}
			
			public final static String MD5Encoder(String s) {
			    return MD5Encoder(s,"utf-8");
			}

			public final static String MD5Encoder(String s, String charset) {
			    try {
			        byte[] btInput = s.getBytes(charset);
			        MessageDigest mdInst = MessageDigest.getInstance("MD5");
			        mdInst.update(btInput);
			        byte[] md = mdInst.digest();
			        StringBuffer sb = new StringBuffer();
			        for (int i = 0; i < md.length; i++) {
			            int val = ((int) md[i]) & 0xff;
			            if (val < 16){
			                sb.append("0");
			            }
			            sb.append(Integer.toHexString(val));
			        }
			        return sb.toString();
			    } catch (Exception e) {
			        return null;
			    }
			}
			

			//获取车号写入数据库
			@Scheduled(cron = "0 0 0,12 * * ?")  //12、24点进行一次 
			public void getCarno()throws Exception {
				
				String param = new String();
				QueryParam queryParam = new QueryParam();
		    	queryParam.getParams().put("code", new Parameter(QueryParam.NE, null));
		    	List<CarNoEntity> list = carNoService.queryList(queryParam);//查询数据库中现有的车号信息
		    	
				SimpleDateFormat enddate = new SimpleDateFormat("yyyy-MM-dd");
		    	param="{\"busitype\":\"carno\",\"begindate\":\"2000-01-01\",\"enddate\": \""+ enddate +"\"}";
		    	//查询2000年至今的车号信息
		    	List<Object> carnolist = new ArrayList<Object>();
				
		    	Map<String, String> headers = new HashMap<>();
		        String back = null;
		        try {
		            back = HttpTookit.postByJson(ncSeUrl, param, headers);
		        } catch (Exception e) {
		            try {
		                back = HttpTookit.postByJson(ncSeUrl, param, headers);
		            } catch (Exception e1) {
		                throw new BusinessException("查询车牌接口异常!");
		            }
		        }
		        if(!back.contains("code")){
		            throw new BusinessException("返回值解析异常!");
		        }
		        JSONObject json = JSONObject.parseObject(back);
		        if(!"1".equals(json.getString("success"))){
		            throw new BusinessException(json.getString("msg"));
		        }else{
		        	List<Object> result = json.getJSONArray("result");
		        	for(int i =0;i<result.size();i++) {//逐条获取车号信息
		        		Object object = result.get(i);
		        		Map<String, Object> mess = (Map<String, Object>) object;
		        		Integer dr = (Integer) mess.get("dr");
		        		Integer enable = (Integer) mess.get("enablestate");
		        		String orgcode = (String) mess.get("orgcode");
						String name = (String) mess.get("name");
						String code  = (String) mess.get("code");
						String ncid = (String) mess.get("id");
						//获取车号详细数据
		        		if(dr !=null || enable!=null) {
		        			if(list.size()!=0) {
		        				CarNoVO carNoVO = carNoService.selectByNcid(ncid);
		        				if(carNoVO != null) {
		            				carNoVO.setCode(code);
		            				carNoVO.setDr(dr);
		            				carNoVO.setEnablestate(enable);
		                			carNoVO.setOrgcode(orgcode);
		                			carNoVO.setName(name);
		                			carNoService.insertOrUpdate(carNoVO);
		            			}else {
		            				CarNoVO carno = new CarNoVO();
		        					carno.setCode(code);
		                			carno.setDr(dr);
		                			carno.setEnablestate(enable);
		                			carno.setOrgcode(orgcode);
		                			carno.setName(name);
		                			carno.setNcid(ncid);
		                			carNoService.insertOrUpdate(carno);
		            			}
		        			}else {
		        				CarNoVO carno = new CarNoVO();
		    					carno.setCode(code);
		            			carno.setDr(dr);
		            			carno.setEnablestate(enable);
		            			carno.setOrgcode(orgcode);
		            			carno.setName(name);
		            			carno.setNcid(ncid);
		            			carNoService.insertOrUpdate(carno);
		        			}
		        		}
		        	}
		        }
			}
			
//			//获取科研项目写入数据库
//			@Scheduled(cron = "0 0 0,12 * * ?")  //12、24点进行一次 
//			public void getScientProject()throws Exception {
//				
//				String param = new String();
//				QueryParam queryParam = new QueryParam();
//		    	queryParam.getParams().put("code", new Parameter(QueryParam.NE, null));
//		    	List<ScientProjectEntity> list = scientProjectService.queryList(queryParam);//查询数据库中现有的车号信息
//		    	
//				SimpleDateFormat enddate = new SimpleDateFormat("yyyy-MM-dd");
////		    	param="{\"busitype\":\"carno\",\"begindate\":\"2000-01-01\",\"enddate\": \""+ enddate +"\"}";
//		    	//查询2000年至今的车号信息
//		    	List<Object> carnolist = new ArrayList<Object>();
//				
//		    	Map<String, String> headers = new HashMap<>();
//		        String back = null;
//		        try {
//		            back = HttpTookit.postByJson(ncSeUrl, param, headers);
//		        } catch (Exception e) {
//		            try {
//		                back = HttpTookit.postByJson(ncSeUrl, param, headers);
//		            } catch (Exception e1) {
//		                throw new BusinessException("查询车牌接口异常!");
//		            }
//		        }
//		        if(!back.contains("code")){
//		            throw new BusinessException("返回值解析异常!");
//		        }
//		        JSONObject json = JSONObject.parseObject(back);
//		        if(!"1".equals(json.getString("success"))){
//		            throw new BusinessException(json.getString("msg"));
//		        }else{
//		        	List<Object> result = json.getJSONArray("result");
//		        	for(int i =0;i<result.size();i++) {//逐条获取车号信息
//		        		Object object = result.get(i);
//		        		Map<String, Object> mess = (Map<String, Object>) object;
//		        		Integer dr = (Integer) mess.get("dr");
//		        		Integer enable = (Integer) mess.get("enablestate");
//		        		String orgcode = (String) mess.get("orgcode");
//						String name = (String) mess.get("name");
//						String code  = (String) mess.get("code");
//						String ncid = (String) mess.get("id");
//						//获取车号详细数据
//		        		if(dr !=null || enable!=null) {
//		        			if(list.size()!=0) {
//		        				CarNoVO carNoVO = carNoService.selectByNcid(ncid);
//		        				if(carNoVO != null) {
//		            				carNoVO.setCode(code);
//		            				carNoVO.setDr(dr);
//		            				carNoVO.setEnablestate(enable);
//		                			carNoVO.setOrgcode(orgcode);
//		                			carNoVO.setName(name);
//		                			carNoService.insertOrUpdate(carNoVO);
//		            			}else {
//		            				CarNoVO carno = new CarNoVO();
//		        					carno.setCode(code);
//		                			carno.setDr(dr);
//		                			carno.setEnablestate(enable);
//		                			carno.setOrgcode(orgcode);
//		                			carno.setName(name);
//		                			carno.setNcid(ncid);
//		                			carNoService.insertOrUpdate(carno);
//		            			}
//		        			}else {
//		        				CarNoVO carno = new CarNoVO();
//		    					carno.setCode(code);
//		            			carno.setDr(dr);
//		            			carno.setEnablestate(enable);
//		            			carno.setOrgcode(orgcode);
//		            			carno.setName(name);
//		            			carno.setNcid(ncid);
//		            			carNoService.insertOrUpdate(carno);
//		        			}
//		        		}
//		        	}
//		        }
//			}
			
			
}
