package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.equipment.api.ISettlementApi;
import com.ejianc.business.equipment.vo.SettlementVO;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayContractSettleEntity;
import com.ejianc.business.finance.bean.PayInfoEntity;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.mbs.bean.pay.request.PayMbsReqVo;
import com.ejianc.business.finance.mbs.bean.pay.request.PayPubReqVo;
import com.ejianc.business.finance.mbs.bean.pay.request.PayReqDetail;
import com.ejianc.business.finance.mbs.bean.pay.response.PayMbsRespVo;
import com.ejianc.business.finance.mbs.service.MbsService;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayContractSettleService;
import com.ejianc.business.finance.service.IPayInfoService;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.utils.MbsUtils;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.finance.utils.XmlUtils;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.PayInfoVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.other.vo.OtherSettleVO;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.rmat.vo.RmatSettlementVO;
import com.ejianc.business.sub.api.ISubContractForPayApi;
import com.ejianc.business.sub.vo.SubSettleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 合同付款申请审批操作业务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@Service("payContract")
public class PayContractBpmServiceImpl implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPayContractService service;

    @Autowired
    private IPayContractSettleService settleService;
    
    @Autowired
    private IPayInfoService payInfoService;

    @Autowired
    private ISubContractForPayApi subApi;

    @Autowired
    private IEquipmentContractApi equipmentApi;

    @Autowired
    private IRmatContractApi rmatContractApi;


    @Autowired
    private ISettlementApi equipmentSettleApi;

    @Autowired
    private IMaterialSettlementApi materialApi;

    @Autowired
    private IOtherContractApi otherContractApi;

    @Autowired
    private NCUtil ncUtil;
    
    @Autowired
    private MbsUtils mbsUtils;
    
    @Autowired
    private MbsService mbsService;
    
    @Autowired
    private IDefdocApi defdocApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    };

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PayContractEntity entity = service.selectById(billId);
        entity.setApproveTime(new Date());
//        //回写累计付款与累计预付款金额  确认时回写修改
//        service.writeBackSumPayMny(billId, entity, true);
        //回写结算单累计申请金额、剩余可申请金额
        Long projectId=entity.getProjectId();

        writeBackSumApplyMny(billId, entity, true);
        service.saveOrUpdate(entity);
        //获取项目信息
        if(projectId == null) {
        	 logger.info("进入审批后回写--- entity:"+entity);
             return CommonResponse.success("回调处理成功！");
        }
        List<Long> ids=new ArrayList<Long>();
        ids.add(projectId);
        List<ProjectRegisterVO> ProjectRegisterVOList= mbsUtils.queryProjectByIds(ids);
        ProjectRegisterVO projectRegisterVO=new ProjectRegisterVO();
        if(ProjectRegisterVOList!=null && ProjectRegisterVOList.size()>0) {
        	projectRegisterVO=ProjectRegisterVOList.get(0);
        }
        logger.info("打印项目属性--- projectRegisterVO:"+projectRegisterVO.toString());
        //判断项目是否启用业资一体化
        if(projectRegisterVO !=null) {
        	//只有业资一体化标识为1且单据收款方式为网银才进行推送。
        	if("1".equals(projectRegisterVO.getIsSendMbs())&&"网银".equals(entity.getPaymentMethodName())) {
        		logger.info("开始推送业资一体化--- id:"+entity.getId());
        		logger.info("开始推送业资一体化--- entity:"+entity.toString());
        		//生成业资数据并推送
        		if(!bankPayInfo(entity)) {
        			return CommonResponse.error("网银类付款推送资金系统失败");
        		}
        	}
        }
        logger.info("进入审批后回写--- entity:"+entity);
        return CommonResponse.success("回调处理成功！");
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PayContractEntity entity = service.selectById(billId);
        // 校验审批时间
        if (!validateApproveTime(entity)) return CommonResponse.error("该合同已存在后续审批单据,不能弃审!");
        // 校验存在未生效单据
        if (!validateEffective(entity)) return CommonResponse.error("该支出单据数据已被引用，不可进行撤回操作!");
        // 校验结算单预付款抵扣引用
        if(entity.getFeeType() == 1 && entity.getPayStatus() == 2 && !validatePrepayMny(entity)){
            return CommonResponse.error("该合同付款申请已被结算单预付款抵扣引用,不能弃审!");
        }
        return CommonResponse.success("校验通过");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PayContractEntity entity = service.selectById(billId);

        // 删除NC传应付单凭证
        if(StringUtils.isNotEmpty(entity.getSourceId())){
            String[] split = entity.getSourceId().split(",");
            for (String sourceId : split){
                JSONObject json = new JSONObject();
                json.put("busitype", "deletepaybill");
                json.put("pk_bill", sourceId);
                ncUtil.postByJson(json.toJSONString());// 调用NC传凭证接口
            }

            LambdaUpdateWrapper<PayContractEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.set(PayContractEntity::getSourceId,null);
            wrapper.eq(PayContractEntity::getId,billId);
            service.update(wrapper);
        }

        // 已确认回写，未确认不回写
        if(2 == entity.getPayStatus()){
            //回写累计付款与累计预付款金额
            service.writeBackSumPayMny(billId, entity, false);
        }
        //回写结算单累计申请金额、剩余可申请金额
        writeBackSumApplyMny(billId, entity, false);
        entity.setPayMny(null);
        entity.setPayStatus(1);
        entity.setApproveTime(null);
        entity.setConfirmTime(null);
        service.saveOrUpdate(entity);
        logger.info("进入审批后回写--- entity:"+entity);

        return CommonResponse.success("回调处理成功！");
    }

    /**
     * 回写结算单累计申请金额、剩余可申请金额
     * @param billId
     * @param entity
     * @param flag
     */
    public boolean writeBackSumApplyMny(Long billId, PayContractEntity entity, boolean flag) {
        List<PayContractSettleEntity> settleEntityList = settleService.list(new QueryWrapper<PayContractSettleEntity>().eq("payapply_id", billId));
        // 结算单对应本期申请金额
        Map<Long, BigDecimal> settleApplyMnyMap  = new HashMap<>();
        for(PayContractSettleEntity settleEntity : settleEntityList){
            // 本期申请金额   true为回写，false为逆回写
            BigDecimal applyMny = flag ? settleEntity.getBodyApplyMny() : MathUtil.safeSub(new BigDecimal(0), settleEntity.getBodyApplyMny());
            settleApplyMnyMap.put(settleEntity.getSettleId(), applyMny);
        }
        if(entity.getContractType() == 1){//分包
            for(PayContractSettleEntity settleEntity : settleEntityList){
                subApi.updateSubSettleSumApplyMny(settleEntity.getSettleId(), settleApplyMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        if(entity.getContractType() == 2){//设备采购
            for(PayContractSettleEntity settleEntity : settleEntityList){
                equipmentApi.updatePurchaseSettleSumApplyMny(settleEntity.getSettleId(), settleApplyMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        if(entity.getContractType() == 3){//设备租赁
            for(PayContractSettleEntity settleEntity : settleEntityList){
                equipmentApi.updateRentSettleSumApplyMny(settleEntity.getSettleId(), settleApplyMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        if(entity.getContractType() == 4){//物资采购
            for(PayContractSettleEntity settleEntity : settleEntityList){
                materialApi.updateSettlementBillAlreadyApplyAmount(settleEntity.getSettleId(), settleApplyMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        if(entity.getContractType() == 5){//物资租赁
            for(PayContractSettleEntity settleEntity : settleEntityList){
                rmatContractApi.updateRentSettleSumApplyMny(settleEntity.getSettleId(), settleApplyMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        if(entity.getContractType() == 6){//其它支出
            for(PayContractSettleEntity settleEntity : settleEntityList){
               otherContractApi.updateOtherSettleSumApplyMny(settleEntity.getSettleId(), settleApplyMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        return true;
    }

    /**
     * 校验存在未生效单据
     * @param entity
     * @return
     */
    private boolean validateEffective(PayContractEntity entity) {
        Long contractId = entity.getContractId();
        QueryWrapper wrapper = new QueryWrapper<PayContractEntity>();
        wrapper.eq("contract_id", contractId);
        wrapper.eq("org_id", entity.getOrgId());
        wrapper.ne("bill_state", 1);
        wrapper.ne("bill_state", 3);
        List<PayContractEntity> list = service.list(wrapper);
        if(!list.isEmpty()){
            return false;
        }
        return true;
    }

    /**
     * 校验审批时间
     * @param entity
     * @return
     */
    private boolean validateApproveTime(PayContractEntity entity) {
        Long contractId = entity.getContractId();
        Date approveTime = entity.getConfirmTime() != null ? entity.getConfirmTime() : entity.getApproveTime();
        QueryWrapper wrapper = new QueryWrapper<PayContractEntity>();
        wrapper.eq("contract_id", contractId);
        wrapper.eq("org_id", entity.getOrgId());
        /* edit by yqls 2021-06-16 使用申请时间判断 */
        wrapper.gt("approve_time", approveTime);
//        wrapper.gt("apply_time", entity.getApplyTime());
        List<PayContractEntity> list = service.list(wrapper);
        if(!list.isEmpty()){
            return false;
        }
        return true;
    }

    /**
     * 结算单预付款抵扣引用
     * 合同、所属组织的剩余预付款必须大于等于当前弃审单据合同预付款金额
     * 剩余预付款 = 合同与所属组织的累计预付款-合同与所属组织累计冲抵金额
     * @param entity
     * @return
     */
    private boolean validatePrepayMny(PayContractEntity entity) {
        Long contractId = entity.getContractId();
        Long orgId = entity.getOrgId();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq("contract_id", contractId);
        wrapper.eq("org_id", orgId);
        List<PayContractEntity> list = service.list(wrapper);
        // 累计预付款
        BigDecimal sumPrepayMny = null;
        for(PayContractEntity data : list){
            if(data.getFeeType() == 1){
                sumPrepayMny = MathUtil.safeAdd(sumPrepayMny, data.getPayMny());
            }
        }
        // 累计冲抵金额
        BigDecimal sumOffsetMny = null;
        if(entity.getContractType() == 1){//分包
            CommonResponse<SubSettleVO> settleResponse = subApi.getSubSettleById(contractId, orgId);
            if(settleResponse.isSuccess()){
                sumOffsetMny = settleResponse.getData().getSumOffsetMny();
            }
        }
        if(entity.getContractType() == 2){//设备采购
            CommonResponse<SettlementVO> settleResponse = equipmentSettleApi.getPurchaseSettlementById(contractId, orgId);
            if(settleResponse.isSuccess()){
                sumOffsetMny = settleResponse.getData().getSumOffsetMny();
            }
        }
        if(entity.getContractType() == 3){//设备租赁
            CommonResponse<SettlementVO> settleResponse = equipmentSettleApi.getRentSettlementById(contractId, orgId);
            if(settleResponse.isSuccess()){
                sumOffsetMny = settleResponse.getData().getSumOffsetMny();
            }
        }
        if(entity.getContractType() == 4){//物资采购
            CommonResponse<BigDecimal> materialResponse = materialApi.getTotalOffsetAmountByContractIdAndOrgId(contractId, orgId);
            if(materialResponse.isSuccess()){
                sumOffsetMny = materialResponse.getData();
            }
        }
        if(entity.getContractType() == 5){//物资租赁
            CommonResponse<RmatSettlementVO> settleResponse = rmatContractApi.getRentSettlementById(contractId, orgId);
            if(settleResponse.isSuccess()){
                sumOffsetMny = settleResponse.getData().getSumOffsetMny();
            }
        }
        if(entity.getContractType() == 6){//其它支出
            CommonResponse<OtherSettleVO> settleResponse = otherContractApi.getOtherSettlementById(contractId, orgId);
            if(settleResponse.isSuccess()){
                sumOffsetMny = settleResponse.getData().getSumOffsetMny();
            }
        }
        BigDecimal prepayMny = entity.getPayMny() != null ? entity.getPayMny() : new BigDecimal(0);
        if(prepayMny.compareTo(MathUtil.safeSub(sumPrepayMny, sumOffsetMny)) > 0){
            logger.info("prepayMny:" + prepayMny + "> sumPrepayMny:" + sumPrepayMny + " - sumOffsetMny:" + sumOffsetMny);
            return false;
        }
        return true;
    }
    //合同过程款网银支付生成支付单并推送MBS
    public boolean bankPayInfo(PayContractEntity entity) {
    	
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter(QueryParam.EQ, entity.getId()));
        //根据主表主键获取子表
        List<PayContractSettleEntity> settleEntityList = settleService.queryList(queryParam, false);
        logger.info("开始生成实际支付单据");
        logger.info("entity实体参数---------"+entity.getId()+"是否网银"+entity.getPaymentMethodName()+entity.getPaymentMethod());
        BigDecimal applyMny=new BigDecimal(0);
        //过程款
        if(settleEntityList.size()>0) {
        	for (PayContractSettleEntity payContractSettleEntity : settleEntityList) {
        		//申请明细为网银类汇总网银类申请金额
    			if("网银".equals(payContractSettleEntity.getSettlePaymentMethodName())) {
    				applyMny=applyMny.add(payContractSettleEntity.getBodyApplyMny());
    			}	
    		}
        	if(applyMny.compareTo(new BigDecimal(0))!=0) {
        		PayInfoEntity bankPayInfo=new PayInfoEntity();
    	    	bankPayInfo.setBillState(0);
    	    	bankPayInfo.setCreateUserCode(entity.getCreateUserCode());
    	    	bankPayInfo.setCreateTime(entity.getApproveTime());
    	    	bankPayInfo.setDr(0);
    	    	bankPayInfo.setTenantId(entity.getTenantId());
    	    	bankPayInfo.setPayapplyId(entity.getId());
    	    	bankPayInfo.setPayapplyCode(entity.getBillCode());
    	    	bankPayInfo.setProjectName(entity.getProjectName());
    	    	bankPayInfo.setProjectId(entity.getProjectId());
    	    	bankPayInfo.setOrgId(entity.getOrgId());
    	    	bankPayInfo.setOrgName(entity.getOrgName());
    	    	bankPayInfo.setReceiveUnitId(entity.getReceiveUnitId());
    	    	bankPayInfo.setReceiveUnitName(entity.getReceiveUnitName());
    	    	bankPayInfo.setAccountBank(entity.getAccountBank());
    	    	bankPayInfo.setAccountBankCode(entity.getAccountBankCode());
    	    	bankPayInfo.setAccountBankId(entity.getAccountBankId());
    	    	bankPayInfo.setAccountNum(entity.getAccountNum());
    	    	bankPayInfo.setAccountName(entity.getAccountName());
    	    	bankPayInfo.setCollectionType(entity.getCollectionType());
    	    	bankPayInfo.setIsBank("Y");
    	    	bankPayInfo.setApplyUserName(entity.getApplyUserName());
    	    	bankPayInfo.setApplyTime(entity.getApplyTime());
    	    	bankPayInfo.setPayInfoType("HT");
    	    	bankPayInfo.setSettlePaymentMethod(1460207005128986625L);
    	    	bankPayInfo.setSettlePaymentMethodName("网银");
    	    	bankPayInfo.setApplyMny(applyMny);
    	    	bankPayInfo.setActualBankCode(entity.getActualBankCode());
    	    	bankPayInfo.setContractName(entity.getContractName());
    	    	bankPayInfo.setContractType(entity.getContractType());
    	    	bankPayInfo.setContractId(entity.getContractId());
    	    	bankPayInfo.setResult("0");//NC推送状态默认为未推送
    	    	PayInfoVO payInfoVo = BeanMapper.map(bankPayInfo, PayInfoVO.class);
    	    	logger.info("打印支付单实体----"+payInfoVo.toString());
    	    	payInfoVo=payInfoService.insertOrUpdate(payInfoVo);
    	    	//组装资金系统支付明细
    	    	PayReqDetail payReqDetail=makeMbs(payInfoVo);
    	    	try {
    	    		//推送至资金系统
    	    		PayMbsRespVo payMbsRespVo=mbsService.sendPay(payReqDetail, payInfoVo);
    	    		payInfoVo=payInfoService.insertOrUpdate(payInfoVo);
    	    		//TODO 返回资金报错信息
    	    		if (!"0".equals(payMbsRespVo.getPub().getRESPCODE())) {
    	    			return false;
    	    		}
    			} catch (Exception e) {
    				return false;
    			}
        	}
        	
        }else {
        	//预付款生成实付信息（预付款无结算明细）
        		logger.info("开始生成预付款网银类实际支付单据");
    	    	PayInfoEntity bankPayInfo=new PayInfoEntity();
    	    	bankPayInfo.setBillState(0);
    	    	bankPayInfo.setCreateUserCode(entity.getCreateUserCode());
    	    	bankPayInfo.setCreateTime(entity.getApproveTime());
    	    	bankPayInfo.setDr(0);
    	    	bankPayInfo.setTenantId(entity.getTenantId());
    	    	bankPayInfo.setPayapplyId(entity.getId());
    	    	bankPayInfo.setPayapplyCode(entity.getBillCode());
    	    	bankPayInfo.setProjectName(entity.getProjectName());
    	    	bankPayInfo.setProjectId(entity.getProjectId());
    	    	bankPayInfo.setOrgId(entity.getOrgId());
    	    	bankPayInfo.setOrgName(entity.getOrgName());
    	    	bankPayInfo.setReceiveUnitId(entity.getReceiveUnitId());
    	    	bankPayInfo.setReceiveUnitName(entity.getReceiveUnitName());
    	    	bankPayInfo.setAccountBank(entity.getAccountBank());
    	    	bankPayInfo.setAccountBankCode(entity.getAccountBankCode());
    	    	bankPayInfo.setAccountBankId(entity.getAccountBankId());
    	    	bankPayInfo.setAccountNum(entity.getAccountNum());
    	    	bankPayInfo.setAccountName(entity.getAccountName());
    	    	bankPayInfo.setCollectionType(entity.getCollectionType());
    	    	bankPayInfo.setIsBank("Y");
    	    	bankPayInfo.setApplyUserName(entity.getApplyUserName());
    	    	bankPayInfo.setApplyTime(entity.getApplyTime());
    	    	bankPayInfo.setPayInfoType("HT");
    	    	bankPayInfo.setSettlePaymentMethod(1460207005128986625L);
    	    	bankPayInfo.setSettlePaymentMethodName("网银");
    	    	bankPayInfo.setApplyMny(entity.getApplyMny());
    	    	bankPayInfo.setActualBankCode(entity.getActualBankCode());
    	    	bankPayInfo.setResult("0");//NC推送状态默认为未推送
    	    	PayInfoVO payInfoVo = BeanMapper.map(bankPayInfo, PayInfoVO.class);
    	    	logger.info("打印支付单实体----"+payInfoVo.toString());
    	    	payInfoVo=payInfoService.insertOrUpdate(payInfoVo);
    	    	PayReqDetail payReqDetail=makeMbs(payInfoVo);
    	    	
    	    	try {
    	    		PayMbsRespVo payMbsRespVo=mbsService.sendPay(payReqDetail, payInfoVo);
    	    		payInfoVo=payInfoService.insertOrUpdate(payInfoVo);
    	    		if (!"0".equals(payMbsRespVo.getPub().getRESPCODE())) {
    	    			return false;
    	    		}
    			} catch (Exception e) {
    				return false;
    			}
        	} 
    	return true;
    }
    public PayReqDetail makeMbs (PayInfoVO payInfoVo) {
    	logger.info("开始生成推送报文实体");
        List<Long> ids=new ArrayList<Long>();
        ids.add(payInfoVo.getProjectId());
        List<ProjectRegisterVO> ProjectRegisterVOList= mbsUtils.queryProjectByIds(ids);
        ProjectRegisterVO projectRegisterVO=new ProjectRegisterVO();
        if(ProjectRegisterVOList!=null && ProjectRegisterVOList.size()>0) {
        	projectRegisterVO=ProjectRegisterVOList.get(0);
        }
		PayReqDetail payDetail=new PayReqDetail();
		payDetail.setSRCSERIALNO(payInfoVo.getId().toString());//明细业务主键
		payDetail.setSRCNOTECODE(payInfoVo.getBillCode());//明细业务编码
		payDetail.setORGCODE(projectRegisterVO.getMbsDept());//单据所属组织
		payDetail.setAPPLYORGCODE(projectRegisterVO.getMbsDept());//付款申请组织
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String now = dateFormat.format(new Date());
		payDetail.setPAYDATE(now);//应付款日期
		payDetail.setPAYTYPECODE("103");//交易类型 
		payDetail.setSETTLEMENTMODECODE(projectRegisterVO.getWySettleCode());//结算方式代码 
		payDetail.setISURGENT("0");//不加急
		payDetail.setPURPOSE(payInfoVo.getMemo());//用途
		payDetail.setOURORGCODE(projectRegisterVO.getMbsDept());//付方组织
		payDetail.setOURBANKACCOUNTNUMBER(payInfoVo.getActualBankCode());//付方账号
		payDetail.setOURCURCODE("CNY");
		payDetail.setOPPPRIVATEFLAG("2");
        payDetail.setOURAMOUNT(payInfoVo.getApplyMny().setScale(4, RoundingMode.HALF_UP).toString());//金额
		payDetail.setOPPOBJECTNAME(payInfoVo.getReceiveUnitName());//收方名称
		payDetail.setOPPBANKLOCATIONCODE(payInfoVo.getAccountBankCode());//收方开户银行代码
		payDetail.setOPPBANKACCOUNTNUMBER(payInfoVo.getAccountNum());//收方账号
		payDetail.setOPPBANKACCOUNTNAME(payInfoVo.getAccountName());//收方账号名称
		payDetail.setOPPDIRECTCURCODE("CNY");//收方币种
		logger.info("打印推送报文实体"+payDetail.toString());
		return payDetail;
    }
    
}
