package com.ejianc.business.finance.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.business.finance.mapper.PayContractMapper;
import com.ejianc.business.finance.mapper.PayInfoMapper;
import com.ejianc.business.finance.mbs.bean.pay.request.PayReqDetail;
import com.ejianc.business.finance.mbs.bean.pay.response.PayMbsRespVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoMbsReqVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoPubReqVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoReqHeadVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoReqSearchonditionsVo;
import com.ejianc.business.finance.mbs.bean.payInfo.request.PayInfoReqVo;
import com.ejianc.business.finance.mbs.bean.payInfo.response.PayInfoMbsRespVo;
import com.ejianc.business.finance.mbs.service.MbsService;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayContractSettleEntity;
import com.ejianc.business.finance.bean.PayInfoEntity;
import com.ejianc.business.finance.bean.PayInvoiceEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayContractSettleService;
import com.ejianc.business.finance.service.IPayForegiftService;
import com.ejianc.business.finance.service.IPayInfoService;
import com.ejianc.business.finance.service.IPayInvoiceService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.utils.FeignUtil;
import com.ejianc.business.finance.utils.MbsUtils;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.finance.utils.XmlUtils;
import com.ejianc.business.finance.vo.PayApplyPubVO;
import com.ejianc.business.finance.vo.PayContractSettleVO;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.PayForegiftVO;
import com.ejianc.business.finance.vo.PayInfoVO;
import com.ejianc.business.finance.vo.PayInvoiceVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.finance.vo.PaySporadicVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.qdsz.nc.vo.PayBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.PayBillVO;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractForPayApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;

/**
 * 实付款信息
 * 
 * @author generator
 * 
 */
@Service("payInfoService")
public class PayInfoServiceImpl extends BaseServiceImpl<PayInfoMapper, PayInfoEntity> implements IPayInfoService{
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PAY_INFO_CODE";//此处需要根据实际修改
    
    private String URL="http://58.56.155.202:8010/webservice/outService.ws";
	private String MD5="9601a2e927ec7225a2e65ed6ed942198";
    
    @Autowired
	private IPayInfoService payInfoService;
    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private IPaySporadicService sporadicService;
    @Autowired
    private IPayReimburseService reimburseService;
    
    @Autowired
    private PayContractMapper payContractMapper;
    @Autowired
	private IPayInvoiceService invoiceService;
    
    
    @Autowired
    private IPayForegiftService foregiftService;
    
    @Autowired
    private IOrgApi orgApi;
    
    @Autowired
    private IDefdocApi defdocApi;
    
    @Autowired
    private IPayContractSettleService consetservice;
    
    @Autowired
    private FeignUtil feignUtil;
    
    @Autowired
    private PayContractMapper conmapper;
    
    @Autowired
	private IPayContractSettleService settleService;
    
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private MbsService mbsService;
    
    @Autowired
    private IPayReimburseService payReimburseService;
    
    @Autowired
    private MbsUtils mbsUtils;
    
    @Autowired
	private ISubContractForPayApi subApi;

	@Autowired
	private IEquipmentContractApi equipmentApi;

	@Autowired
	private IRmatContractApi rmatContractApi;

	@Autowired
	private IMaterialSettlementApi materialApi;
	@Autowired
	private IOtherContractApi otherContractApi; // 其他收入合同
    //指令
  	//查询银行
  	private String BankTRANSCODE="PBQB01";
  	//推送支付
  	private String PayTRANSCODE="PMSQ01";
  	//查询支付状态
  	private String PayInfoTRANSCODE="GETPAYINFO";
  	//密码盐
  	private String MD5Key="QDSZ123";
  	
	@Autowired
	private NCUtil ncUtil;
    

	@Override
	public PayInfoVO insertOrUpdate(PayInfoVO saveOrUpdateVO) {
		//vo转化实体
		PayInfoEntity entity = BeanMapper.map(saveOrUpdateVO, PayInfoEntity.class);
		//获取租户编码
		Long tenantId = InvocationInfoProxy.getTenantid();
	   	if(entity.getBillCode() == null || "".equals(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
	   	saveOrUpdate(entity, false);
	   	PayInfoVO vo = BeanMapper.map(entity, PayInfoVO.class);
		return vo;
	}
	
	 @Override
	    public String batchConfirm(PayInfoVO vo) {
	        	ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(vo.getProjectId())).get(0);
	        	if ("1".equals(project.getIndustryIntegrationFlag())) {
	        		this.pushToNcAr(vo);
	        		}
	        	if("HT".equals(vo.getPayInfoType())) {
		        	writeBackSumPayMny(vo, true);	
	        	}else if("QT".equals(vo.getPayInfoType())){
	        		PayReimburseEntity payReimburseEntity = payReimburseService.selectById(vo.getPayapplyId());
	        		payReimburseService.costPush(payReimburseEntity);
	        	}
	        return "推送凭证！";
	    }
	 
	@Override
	public JSONObject queryPendingPageJson(QueryParam param, boolean isEs) {

		Long parentid = null;
		List<Long> parentidlist = new ArrayList<>();

		QueryParam param2 = new QueryParam();
		param2.getParams().put("settlePaymentMethod", new Parameter(QueryParam.EQ, "1460221804369940481"));// 单据体收款方式为网银
		param2.getParams().put("dr", new Parameter(QueryParam.EQ, "0"));
		List<PayContractSettleEntity> page1 = consetservice.queryList(param2);

		for (PayContractSettleEntity conset : page1) {
			parentid = conset.getPayapplyId();
			if (!parentidlist.contains(parentid) && parentid != null) {
				parentidlist.add(parentid);
			}
		}
		String jsonString = JSONObject.toJSON(parentidlist).toString();
		String parent = jsonString.replace("[", "(").replace("]", ")");
		// 查找合同付款，单据体含有网银的数据

		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("contractName");
		fuzzyFields.add("orgName");
		fuzzyFields.add("receiveUnitName");
		fuzzyFields.add("applyUserName");
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		// 组织本下
		param.getParams().put("orgId",
				new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()
						.stream().map(OrgVO::getId).collect(Collectors.toList())));
		// 已生效状态的单据
		param.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
		param.getParams().put("payStatus", new Parameter(QueryParam.EQ, 1));// 未支付
		param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));// 未删除
		if(page1.size()!=0) {
			//
			param.getParams().put("id", new Parameter(QueryParam.SQL,"project_id  in (select id from `ejc-market`.ejc_market_project where dr=0 and is_send_mbs =1) and (id in " + parent + " or  payment_method = 1460221804369940481)"));
		}else {
			param.getParams().put("id", new Parameter(QueryParam.SQL,"project_id  in (select id from `ejc-market`.ejc_market_project where dr=0 and is_send_mbs =1) and payment_method = 1460221804369940481"));//单据头收款方式为网银
		}
		param.getOrderMap().put("approveTime", QueryParam.DESC);

		// 转换报销筛选条件
		transformReimburse(param);
		Page<PayApplyPubVO> pages = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
		QueryWrapper wrapper = changeToQueryWrapper(param);
		List<PayApplyPubVO> list = conmapper.queryPendingList(pages, wrapper);
		Map<Long, String> defdocMap = feignUtil.getDefdocMap(324875125018329093L);
		if (!list.isEmpty()) {
			for (PayApplyPubVO vo : list) {
				// 翻译报销
				if ("其他费用".equals(vo.getApplyType()) && defdocMap.containsKey(Long.valueOf(vo.getFeeType()))) {
					vo.setFeeType("其他费用-" + defdocMap.get(Long.valueOf(vo.getFeeType())));
				}
			}
		}

		JSONObject page = new JSONObject();
		page.put("records", list);
		page.put("total", pages.getTotal());
		page.put("current", pages.getCurrent());
		page.put("size", pages.getSize());
		page.put("pages", pages.getPages());
		return page;
	}

	private void transformReimburse(QueryParam param) {
		// 判断筛选条件是否携带报销信息
		Parameter feeType = param.getParams().get("feeType");
		if (!Objects.equals(feeType, null)) {
			String value = feeType.getValue().toString();

			if (StringUtils.contains(value, "其他费用-")) {
				// 查询资金-付款申请-报销费用类别
				CommonResponse<List<DefdocDetailVO>> listCommonResponse = defdocApi
						.getDefDocByDefId(324875125018329093L);
				List<DefdocDetailVO> data = listCommonResponse.getData();
				String[] split = value.split(",");
				for (int i = 0; i < split.length; i++) {
					String feeTypeName = split[i];
					if (StringUtils.contains(feeTypeName, "其他费用-")) {
						List<DefdocDetailVO> list = data.stream()
								.filter(vo -> vo.getName().equals(feeTypeName.substring(5)))
								.collect(Collectors.toList());

						split[i] = list.get(0).getId().toString();
					}
				}

				value = StringUtils.join(split, ",");
				// 重新赋值
				feeType.setValue(value);
			}
		}
	}

	@Override
	public String sendPayConfirmBtn(List<PayInfoVO> vos) {
		for(PayInfoVO vo : vos) {
			String result = vo.getResult();//获取返回值
			if(result.equals("支付失败")) {
				if("HT".equals(vo.getPayInfoType())) {
					//获取当前数据的原单数据
					PayContractEntity entity = payContractService.selectById(vo.getPayapplyId());
					
					logger.info("开始推送业资一体化--- entity:"+entity.toString());
	        		//生成业资数据并推送
	        		if(!ContractbankPayInfo(entity)) {
	        			return "网银类付款推送资金系统失败";
	        		}

				}else if("LX".equals(vo.getPayInfoType())) {
					PaySporadicEntity entity = sporadicService.selectById(vo.getPayapplyId());
					
					logger.info("开始推送业资一体化--- entity:"+entity.toString());
	        		//生成业资数据并推送
	        		if(!SporadicbankPayInfo(entity)) {
	        			return "网银类付款推送资金系统失败";
	        		}
					
				}else if("QT".equals(vo.getPayInfoType())) {
					PayReimburseEntity entity = reimburseService.selectById(vo.getPayapplyId());
					
					logger.info("开始推送业资一体化--- entity:"+entity.toString());
	        		//生成业资数据并推送
	        		if(!ReimbursebankPayInfo(entity)) {
	        			return "网银类付款推送资金系统失败";
	        		}
				}
				
			}else if(result.equals("已支付")){
				throw new BusinessException("已支付数据无法再次推送业资！");
			}else {
				throw new BusinessException("数据正在支付中，无法再次推送！");
			}
		}
		return "推送资金成功！";
	}
	
	private static String md5String(String md5String,String md5Key){
	    String md5Value = MD5Encoder(md5String + md5Key);
	    return md5Value;
	}
	public final static String MD5Encoder(String s) {
	    return MD5Encoder(s,"utf-8");
	}
	//request转
	private String splicingXmlRequest(String xml) {
		//拼接格式
		xml="<?xml version=\"1.0\" encoding=\"UTF-8\"?>"+xml;
		xml="<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:out=\"http://outsystem.ats.com.cn\"><soapenv:Header/><soapenv:Body><out:outSystemWS><out:in0><![CDATA["+xml+"]]></out:in0></out:outSystemWS></soapenv:Body></soapenv:Envelope>";
		return xml;
	}
	private String splicingXmlResponse(String xml) {
		//转义
		xml = StringEscapeUtils.unescapeXml(xml);
		//拼接获取XML
		int a=xml.indexOf("<MBS>");
		int b=xml.indexOf("</MBS>");
		xml=StringUtils.substring(xml, a, b)+"</MBS>";
		return xml;
	}
	public final static String MD5Encoder(String s, String charset) {
	    try {
	        byte[] btInput = s.getBytes(charset);
	        MessageDigest mdInst = MessageDigest.getInstance("MD5");
	        mdInst.update(btInput);
	        byte[] md = mdInst.digest();
	        StringBuffer sb = new StringBuffer();
	        for (int i = 0; i < md.length; i++) {
	            int val = ((int) md[i]) & 0xff;
	            if (val < 16){
	                sb.append("0");
	            }
	            sb.append(Integer.toHexString(val));
	        }
	        return sb.toString();
	    } catch (Exception e) {
	        return null;
	    }
	}
	
	//合同过程款网银支付生成支付单并推送MBS
    public boolean ContractbankPayInfo(PayContractEntity entity) {
    	
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter(QueryParam.EQ, entity.getId()));
        List<PayContractSettleEntity> settleEntityList = settleService.queryList(queryParam, false);
        logger.info("开始生成实际支付单据");
        logger.info("entity实体参数---------"+entity.getId()+"是否网银"+entity.getPaymentMethodName()+entity.getPaymentMethod());
        
//        Map<String, String> allresponse = new HashMap<String,String>();
//        
//        CommonResponse<List<DefdocDetailVO>> response = defdocApi.getDefDocByDefCode("finance-pay-status");
//        for (DefdocDetailVO defdocDetailVO : response.getData()) {
//        	allresponse.put(defdocDetailVO.getCode(), defdocDetailVO.getName());
//		}
        
        //过程款
        if(settleEntityList.size()>0) {
        	for (PayContractSettleEntity payContractSettleEntity : settleEntityList) {
        		//申请明细为网银类，自动生成实付信息
    			if("网银".equals(entity.getPaymentMethodName())) {
    		    	PayInfoEntity bankPayInfo=new PayInfoEntity();
    		    	bankPayInfo.setBillState(0);
    		    	bankPayInfo.setCreateUserCode(entity.getCreateUserCode());
    		    	bankPayInfo.setCreateTime(entity.getApproveTime());
    		    	bankPayInfo.setDr(0);
    		    	bankPayInfo.setTenantId(entity.getTenantId());
    		    	bankPayInfo.setPayapplyId(entity.getId());
    		    	bankPayInfo.setPayapplyCode(entity.getBillCode());
    		    	bankPayInfo.setProjectName(entity.getProjectName());
    		    	bankPayInfo.setProjectId(entity.getProjectId());
    		    	bankPayInfo.setOrgId(entity.getOrgId());
    		    	bankPayInfo.setOrgName(entity.getOrgName());
    		    	bankPayInfo.setReceiveUnitId(entity.getReceiveUnitId());
    		    	bankPayInfo.setReceiveUnitName(entity.getReceiveUnitName());
    		    	bankPayInfo.setAccountBank(entity.getAccountBank());
    		    	bankPayInfo.setAccountBankCode(entity.getAccountBankCode());
    		    	bankPayInfo.setAccountBankId(entity.getAccountBankId());
    		    	bankPayInfo.setAccountNum(entity.getAccountNum());
    		    	bankPayInfo.setAccountName(entity.getAccountName());
    		    	bankPayInfo.setCollectionType(entity.getCollectionType());
    		    	bankPayInfo.setIsBank("Y");
    		    	bankPayInfo.setApplyUserName(entity.getApplyUserName());
    		    	bankPayInfo.setApplyTime(entity.getApplyTime());
    		    	bankPayInfo.setPayInfoType("HT");
    		    	bankPayInfo.setSettlePaymentMethod(1460207005128986625L);
    		    	bankPayInfo.setSettlePaymentMethodName("网银");
    		    	bankPayInfo.setApplyMny(payContractSettleEntity.getBodyApplyMny());
    		    	bankPayInfo.setActualBankCode(entity.getActualBankCode());
    		    	PayInfoVO payInfoVo = BeanMapper.map(bankPayInfo, PayInfoVO.class);
    		    	logger.info("打印支付单实体----"+payInfoVo.toString());
    		    	payInfoVo=payInfoService.insertOrUpdate(payInfoVo);
    		    	//组装资金系统支付明细
    		    	PayReqDetail payReqDetail=makeMbs(payInfoVo,payContractSettleEntity);
    		    	try {
    		    		//推送至资金系统
    		    		PayMbsRespVo payMbsRespVo=mbsService.sendPay(payReqDetail, payInfoVo);
//    		    		String jsonString = JSONObject.toJSON(payMbsRespVo.getResp().getList().getDetail()).toString();
//    		    		int start = jsonString.indexOf("<paystate>");
//    		    		int end = jsonString.indexOf("</paystate>");
//    		    		String code = jsonString.substring(start, end);//截取返回的推送状态报文
//    		    		//通过返回报文查找对应的自定义档案id
//    		    		payInfoVo.setResult(allresponse.get(code));
	    	    		if (!"0".equals(payMbsRespVo.getPub().getRESPCODE())) {
	    	    			return false;
	    	    		}
					} catch (Exception e) {
						return false;
					}
    			}
    		}
        }else {
        	//预付款生成实付信息（预付款无结算明细）
        	if("网银".equals(entity.getPaymentMethodName())) {
        		logger.info("开始生成预付款网银类实际支付单据");
    	    	PayInfoEntity bankPayInfo=new PayInfoEntity();
    	    	bankPayInfo.setBillState(0);
    	    	bankPayInfo.setCreateUserCode(entity.getCreateUserCode());
    	    	bankPayInfo.setCreateTime(entity.getApproveTime());
    	    	bankPayInfo.setDr(0);
    	    	bankPayInfo.setTenantId(entity.getTenantId());
    	    	bankPayInfo.setPayapplyId(entity.getId());
    	    	bankPayInfo.setPayapplyCode(entity.getBillCode());
    	    	bankPayInfo.setProjectName(entity.getProjectName());
    	    	bankPayInfo.setProjectId(entity.getProjectId());
    	    	bankPayInfo.setOrgId(entity.getOrgId());
    	    	bankPayInfo.setOrgName(entity.getOrgName());
    	    	bankPayInfo.setReceiveUnitId(entity.getReceiveUnitId());
    	    	bankPayInfo.setReceiveUnitName(entity.getReceiveUnitName());
    	    	bankPayInfo.setAccountBank(entity.getAccountBank());
    	    	bankPayInfo.setAccountBankCode(entity.getAccountBankCode());
    	    	bankPayInfo.setAccountBankId(entity.getAccountBankId());
    	    	bankPayInfo.setAccountNum(entity.getAccountNum());
    	    	bankPayInfo.setAccountName(entity.getAccountName());
    	    	bankPayInfo.setCollectionType(entity.getCollectionType());
    	    	bankPayInfo.setIsBank("Y");
    	    	bankPayInfo.setApplyUserName(entity.getApplyUserName());
    	    	bankPayInfo.setApplyTime(entity.getApplyTime());
    	    	bankPayInfo.setPayInfoType("HT");
    	    	bankPayInfo.setSettlePaymentMethod(1460207005128986625L);
    	    	bankPayInfo.setSettlePaymentMethodName("网银");
    	    	bankPayInfo.setApplyMny(entity.getApplyMny());
    	    	bankPayInfo.setActualBankCode(entity.getActualBankCode());
    	    	PayInfoVO payInfoVo = BeanMapper.map(bankPayInfo, PayInfoVO.class);
    	    	logger.info("打印支付单实体----"+payInfoVo.toString());
    	    	payInfoVo=payInfoService.insertOrUpdate(payInfoVo);
    	    	PayReqDetail payReqDetail=makeMbs(payInfoVo,null);
    	    	
    	    	try {
    	    		PayMbsRespVo payMbsRespVo=mbsService.sendPay(payReqDetail, payInfoVo);
//    	    		String jsonString = JSONObject.toJSON(payMbsRespVo.getResp().getList()).toString();
//    	    		int start = jsonString.indexOf("<paystate>");
//		    		int end = jsonString.indexOf("</paystate>");
//		    		String code = jsonString.substring(start, end);//截取返回的推送状态报文
//		    		//通过返回报文查找对应的自定义档案id
//		    		payInfoVo.setResult(allresponse.get(code));
    	    		if (!"0".equals(payMbsRespVo.getPub().getRESPCODE())) {
    	    			return false;
    	    		}
    			} catch (Exception e) {
    				return false;
    			}
        	}
        }
    	return true;
    }
    
  //其他过程款网银支付生成支付单并推送MBS
    public boolean ReimbursebankPayInfo(PayReimburseEntity entity) {
    	
        logger.info("开始生成实际支付单据");
        logger.info("entity实体参数---------"+entity.getId()+"是否网银"+entity.getPaymentMethodName()+entity.getPaymentMethod());
        
//        Map<String, String> allresponse = new HashMap<String,String>();
//        
//        CommonResponse<List<DefdocDetailVO>> response = defdocApi.getDefDocByDefCode("finance-pay-status");
//        for (DefdocDetailVO defdocDetailVO : response.getData()) {
//        	allresponse.put(defdocDetailVO.getCode(), defdocDetailVO.getName());
//		}

        //预付款生成实付信息（预付款无结算明细）
        if("网银".equals(entity.getPaymentMethodName())) {
        	logger.info("开始生成预付款网银类实际支付单据");
    	    PayInfoEntity bankPayInfo=new PayInfoEntity();
    	    bankPayInfo.setBillState(0);
    	    bankPayInfo.setCreateUserCode(entity.getCreateUserCode());
    	    bankPayInfo.setCreateTime(entity.getApproveTime());
    	    bankPayInfo.setDr(0);
    	    bankPayInfo.setTenantId(entity.getTenantId());
    	    bankPayInfo.setPayapplyId(entity.getId());
    	    bankPayInfo.setPayapplyCode(entity.getBillCode());
    	    bankPayInfo.setProjectName(entity.getProjectName());
    	    bankPayInfo.setProjectId(entity.getProjectId());
    	    bankPayInfo.setOrgId(entity.getOrgId());
    	    bankPayInfo.setOrgName(entity.getOrgName());
    	    //其他费用均用通用供应商
    	    bankPayInfo.setReceiveUnitId(5465813256496854L);
    	    bankPayInfo.setReceiveUnitName("集团通用供应商");
    	    bankPayInfo.setAccountBank(entity.getAccountBank());
    	    bankPayInfo.setAccountBankCode(entity.getAccountBankCode());
    	    bankPayInfo.setAccountBankId(entity.getAccountBankId());
    	    bankPayInfo.setAccountNum(entity.getAccountNum());
    	    bankPayInfo.setAccountName(entity.getAccountName());
    	    bankPayInfo.setCollectionType(entity.getCollectionType());
    	    bankPayInfo.setIsBank("Y");
    	    bankPayInfo.setApplyUserName(entity.getApplyUserName());
    	    bankPayInfo.setApplyTime(entity.getApplyTime());
    	    bankPayInfo.setPayInfoType("QT");
    	    bankPayInfo.setSettlePaymentMethod(1460207005128986625L);
    	    bankPayInfo.setSettlePaymentMethodName("网银");
    	    bankPayInfo.setApplyMny(entity.getApplyMny());
    	    bankPayInfo.setActualBankCode(entity.getActualBankCode());
    	    PayInfoVO payInfoVo = BeanMapper.map(bankPayInfo, PayInfoVO.class);
    	    logger.info("打印支付单实体----"+payInfoVo.toString());
    	    payInfoVo=payInfoService.insertOrUpdate(payInfoVo);
    	    PayReqDetail payReqDetail=makeMbs(payInfoVo,null);
    	    try {
    	    	PayMbsRespVo payMbsRespVo=mbsService.sendPay(payReqDetail, payInfoVo);
//    	    	String jsonString = JSONObject.toJSON(payMbsRespVo.getResp().getList()).toString();
//	    		int start = jsonString.indexOf("<paystate>");
//	    		int end = jsonString.indexOf("</paystate>");
//	    		String code = jsonString.substring(start, end);//截取返回的推送状态报文
//	    		//通过返回报文查找对应的自定义档案id
//	    		payInfoVo.setResult(allresponse.get(code));
    	    	if (!"0".equals(payMbsRespVo.getPub().getRESPCODE())) {
    	    		return false;
    	    	}
    		} catch (Exception e) {
    			return false;
    		}
        }

    	return true;
    }
    
  //零星过程款网银支付生成支付单并推送MBS
	public boolean SporadicbankPayInfo(PaySporadicEntity entity) {

		logger.info("开始生成实际支付单据");
		logger.info("entity实体参数---------" + entity.getId() + "是否网银" + entity.getPaymentMethodName()
				+ entity.getPaymentMethod());
		
//        Map<String, String> allresponse = new HashMap<String,String>();
//        
//        CommonResponse<List<DefdocDetailVO>> response = defdocApi.getDefDocByDefCode("finance-pay-status");
//        for (DefdocDetailVO defdocDetailVO : response.getData()) {
//        	allresponse.put(defdocDetailVO.getCode(), defdocDetailVO.getName());
//		}
		
		// 预付款生成实付信息（预付款无结算明细）
		if ("网银".equals(entity.getPaymentMethodName())) {
			logger.info("开始生成预付款网银类实际支付单据");
			PayInfoEntity bankPayInfo = new PayInfoEntity();
			bankPayInfo.setBillState(0);
			bankPayInfo.setCreateUserCode(entity.getCreateUserCode());
			bankPayInfo.setCreateTime(entity.getApproveTime());
			bankPayInfo.setDr(0);
			bankPayInfo.setTenantId(entity.getTenantId());
			bankPayInfo.setPayapplyId(entity.getId());
			bankPayInfo.setPayapplyCode(entity.getBillCode());
			bankPayInfo.setProjectName(entity.getProjectName());
			bankPayInfo.setProjectId(entity.getProjectId());
			bankPayInfo.setOrgId(entity.getOrgId());
			bankPayInfo.setOrgName(entity.getOrgName());
			bankPayInfo.setReceiveUnitId(entity.getSupplierId());
			bankPayInfo.setReceiveUnitName(entity.getSupplierName());
			bankPayInfo.setAccountBank(entity.getAccountBank());
			bankPayInfo.setAccountBankCode(entity.getAccountBankCode());
			bankPayInfo.setAccountBankId(entity.getAccountBankId());
			bankPayInfo.setAccountNum(entity.getAccountNum());
			bankPayInfo.setAccountName(entity.getAccountName());
			bankPayInfo.setCollectionType(entity.getCollectionType());
			bankPayInfo.setIsBank("Y");
			bankPayInfo.setApplyUserName(entity.getApplyUserName());
			bankPayInfo.setApplyTime(entity.getApplyTime());
			bankPayInfo.setPayInfoType("LX");
			bankPayInfo.setSettlePaymentMethod(1460207005128986625L);
			bankPayInfo.setSettlePaymentMethodName("网银");
			bankPayInfo.setApplyMny(entity.getApplyMny());
			bankPayInfo.setActualBankCode(entity.getActualBankCode());
			PayInfoVO payInfoVo = BeanMapper.map(bankPayInfo, PayInfoVO.class);
			logger.info("打印支付单实体----" + payInfoVo.toString());
			payInfoVo = payInfoService.insertOrUpdate(payInfoVo);
			PayReqDetail payReqDetail = makeMbs(payInfoVo, null);

			try {
				//推送至资金系统
	    		PayMbsRespVo payMbsRespVo=mbsService.sendPay(payReqDetail, payInfoVo);
//	    		String jsonString = JSONObject.toJSON(payMbsRespVo.getResp().getList().getDetail()).toString();
//	    		int start = jsonString.indexOf("<paystate>");
//	    		int end = jsonString.indexOf("</paystate>");
//	    		String code = jsonString.substring(start, end);//截取返回的推送状态报文
//	    		//通过返回报文查找对应的自定义档案id
//	    		payInfoVo.setResult(allresponse.get(code));
	    		if (!"0".equals(payMbsRespVo.getPub().getRESPCODE())) {
	    			return false;
	    		}
			} catch (Exception e) {
				return false;
			}
		}
		return true;
	}
    
    
    
    public PayReqDetail makeMbs (PayInfoVO payInfoVo,PayContractSettleEntity payContractSettleEntity) {
    	logger.info("开始生成推送报文实体");
        List<Long> ids=new ArrayList<Long>();
        ids.add(payInfoVo.getProjectId());
        List<ProjectRegisterVO> ProjectRegisterVOList= mbsUtils.queryProjectByIds(ids);
        ProjectRegisterVO projectRegisterVO=new ProjectRegisterVO();
        if(ProjectRegisterVOList!=null && ProjectRegisterVOList.size()>0) {
        	projectRegisterVO=ProjectRegisterVOList.get(0);
        }
		PayReqDetail payDetail=new PayReqDetail();
		payDetail.setSRCSERIALNO(payInfoVo.getId().toString());//明细业务主键
		payDetail.setSRCNOTECODE(payInfoVo.getBillCode());//明细业务编码
		payDetail.setORGCODE(projectRegisterVO.getMbsDept());//单据所属组织
		payDetail.setAPPLYORGCODE(projectRegisterVO.getMbsDept());//付款申请组织
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String now = dateFormat.format(new Date());
		payDetail.setPAYDATE(now);//应付款日期
		payDetail.setPAYTYPECODE("103");//交易类型 
		payDetail.setSETTLEMENTMODECODE("101");//结算方式代码 
		payDetail.setISURGENT("0");//不加急
		payDetail.setPURPOSE(payInfoVo.getMemo());//用途
		payDetail.setOURORGCODE(projectRegisterVO.getMbsDept());//付方组织
		payDetail.setOURBANKACCOUNTNUMBER(payInfoVo.getActualBankCode());//付方账号
		payDetail.setOURCURCODE("CNY");
		payDetail.setOPPPRIVATEFLAG("2");
		if(payContractSettleEntity !=null) {
			payDetail.setOURAMOUNT(payContractSettleEntity.getBodyApplyMny().setScale(4, RoundingMode.HALF_UP).toString());//金额
		}else {
			payDetail.setOURAMOUNT(payInfoVo.getApplyMny().setScale(4, RoundingMode.HALF_UP).toString());//金额
		}
		payDetail.setOPPOBJECTNAME(payInfoVo.getReceiveUnitName());//收方名称
		payDetail.setOPPBANKLOCATIONCODE(payInfoVo.getAccountBankCode());//收方开户银行代码
		payDetail.setOPPBANKACCOUNTNUMBER(payInfoVo.getAccountNum());//收方账号
		payDetail.setOPPBANKACCOUNTNAME(payInfoVo.getAccountName());//收方账号名称
		payDetail.setOPPDIRECTCURCODE("CNY");//收方币种
		logger.info("打印推送报文实体"+payDetail.toString());
		return payDetail;
    }
    
    /**
	 * 推送NC传应付单凭证
	 * 
	 * @param payContractEntity
	 */
	private void pushToNcAr(PayInfoVO payInfoVo) {

		PayBillVO vo = transferToNCVO(payInfoVo);
		ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(payInfoVo.getProjectId())).get(0);
		StringBuffer sb = new StringBuffer();
		//判断实付组织与预付款组织标识
		boolean orgType=false;
		//判断是实付款单据类型
		List<Long> orgIds =new ArrayList<Long>();
		List<Long> orgIds2 =new ArrayList<Long>();
		String accountNum = null;
		String sourceIds=null;
		String feedetail=null;
		String carNoCode=null;
		String sourceId=null;
		if ("HT".equals(payInfoVo.getPayInfoType())) {
			PayContractVO payContractVO = payContractService.queryDetail(payInfoVo.getPayapplyId());
			if (payContractVO.getApplyOrgId().equals(payContractVO.getActualOrgId())) {
				orgType=true;
			}
			orgIds = ncUtil.validateInvoiceMainOrg(payContractVO.getApplyOrgId(),
					project.getMainOrgId());
			orgIds2 = ncUtil.validateInvoiceMainOrg(payContractVO.getActualOrgId(),
					project.getMainOrgId());
			accountNum =payContractVO.getAccountNum();
			sourceIds=payContractVO.getSourceId();
		}else if("LX".equals(payInfoVo.getPayInfoType())) {
			PaySporadicVO paySporadicVO=sporadicService.queryDetail(payInfoVo.getPayapplyId());
			if (paySporadicVO.getApplyOrgId().equals(paySporadicVO.getActualOrgId())) {
				orgType=true;
			}
			orgIds = ncUtil.validateInvoiceMainOrg(paySporadicVO.getApplyOrgId(),
					project.getMainOrgId());
			orgIds2 = ncUtil.validateInvoiceMainOrg(paySporadicVO.getActualOrgId(),
					project.getMainOrgId());
			accountNum =paySporadicVO.getAccountNum();
			sourceIds=paySporadicVO.getSourceId();
		}else if("QT".equals(payInfoVo.getPayInfoType())) {
			PayReimburseVO payReimburseVo=reimburseService.queryDetail(payInfoVo.getPayapplyId());
	    	//根据费用类别id查询编码
	    	Long feedtailid = payReimburseVo.getFeeType();
	    	Map<Long, String> defdocMap = this.getDefdocMap(feedtailid);
	    	feedetail = defdocMap.get(payReimburseVo.getFeeType());
	       	//获取车号编码
	    	Long carNoCodes = payReimburseVo.getCarNo();
	    	Map<Long, String> defdocMapcar = this.getDefdocMap(carNoCodes);
	    	carNoCode = defdocMapcar.get(payReimburseVo.getCarNo());
		}
		if(orgType) {
			for (Long orgId : orgIds) {
				vo.setPk_org(ncUtil.queryOrgById(orgId).getCode());
				if("QT".equals(payInfoVo.getPayInfoType())) {
					String jsonString = JSONObject.toJSON(vo).toString();
					String endjson = jsonString.replace(":[{", ":[{\"feedetail\":\""+ feedetail + "\",");//推送费用类别编码
	                if(carNoCode != null) {
	                	endjson = endjson.replace(",\"detail", ",\"def30\":\""+ carNoCode + "\",\"detail");//推送车号编码
	                }
	                sourceId = ncUtil.postByJson(endjson);// 调用NC传凭证接口	
				}else {
					sourceId = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 调用NC传凭证接口	
				}
				sb.append(sourceId).append(",");	
				}
		}else {
			for (Long orgId : orgIds) {
				vo.setPk_org(ncUtil.queryOrgById(orgId).getCode());
				if("QT".equals(payInfoVo.getPayInfoType())) {
					String jsonString = JSONObject.toJSON(vo).toString();
					String endjson = jsonString.replace(":[{", ":[{\"feedetail\":\""+ feedetail + "\",");//推送费用类别编码
	                if(carNoCode != null) {
	                	endjson = endjson.replace(",\"detail", ",\"def30\":\""+ carNoCode + "\",\"detail");//推送车号编码
	                }
	                sourceId = ncUtil.postByJson(endjson);// 调用NC传凭证接口	
				}else {
					sourceId = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 调用NC传凭证接口	
				}
				sb.append(sourceId).append(",");	
				}
			}
			PayBillDetailVO payBillDetailVO2 = vo.getDetail().get(0);
			payBillDetailVO2.setBankaccount(accountNum); // 传实际付款组织的银行账户
			for (Long orgId : orgIds2) {
				vo.setPk_org(String.valueOf(orgId));
				if("QT".equals(payInfoVo.getPayInfoType())) {
					String jsonString = JSONObject.toJSON(vo).toString();
					String endjson = jsonString.replace(":[{", ":[{\"feedetail\":\""+ feedetail + "\",");//推送费用类别编码
	                if(carNoCode != null) {
	                	endjson = endjson.replace(",\"detail", ",\"def30\":\""+ carNoCode + "\",\"detail");//推送车号编码
	                }
	                sourceId = ncUtil.postByJson(endjson);// 调用NC传凭证接口	
				}else {
					sourceId = ncUtil.postByJson(JSONObject.toJSON(vo).toString());// 调用NC传凭证接口	
				}
				sb.append(sourceId).append(",");
			}
		if(sourceIds!=null&&!"".equals(sourceIds)) {
			sourceIds =sourceIds+","+sb.substring(0, sb.length() - 1);
		}else {
			sourceIds=sb.substring(0, sb.length() - 1);
		}
		LambdaUpdateWrapper<PayContractEntity> wrapper = new LambdaUpdateWrapper<>();
		wrapper.set(PayContractEntity::getSourceId, sourceIds);// 保存来源主键
		wrapper.eq(PayContractEntity::getId, payInfoVo.getId());
		payInfoVo.setResult("200");
		payInfoService.insertOrUpdate(payInfoVo);
		payContractService.update(wrapper);
	}
	
	   /**
     * 转换成NCVO
     * @param PayInfoVO
     * @return
     */
	private PayBillVO transferToNCVO(PayInfoVO payInfoVo) {
		
		//获取项目主键
		Long projectId = payInfoVo.getProjectId();
		//获取项目
		ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(projectId)).get(0);
		logger.info("----付款单传凭证开始:");
		//实例ncVo
		PayBillVO ncVo = new PayBillVO();
		ncVo.setBusitype("paybill");
		ncVo.setPk_project(String.valueOf(payInfoVo.getProjectId()));// 项目主键
		
		ncVo.setDef1(
				null != project.getMeasurementCertificate() && 1 == project.getMeasurementCertificate() ? true : false);// 是否有计量证书
		ncVo.setDef2(ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory()));// 开票主体分类 0-PMDA06001,1-PMDA06002
		ncVo.setDef3(ncUtil.getTaxWayDefCode(project.getTaxWay()));// 计税方式 0-01,1-02
		ncVo.setDef4(ncUtil.getDefDocById(project.getEngineeringType()).getCode());// 工程类型
		if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(project.getAreaCode())) {
			throw new BusinessException("项目-区域不能为空！");
		}
		ncVo.setDef5(project.getAreaCode());// 区域编码
		ncVo.setDef12(String.valueOf(payInfoVo.getId())); // PM单据主键
		//实例表体
		List<PayBillDetailVO> detailVOS = new ArrayList<>();
		
		//根据类型转换NCVO
		if ("HT".equals(payInfoVo.getPayInfoType())) {
			//获取合同申请单
			PayContractVO payContractVO = payContractService.queryDetail(payInfoVo.getPayapplyId());
			
			if (payContractVO.getContractType() == 1) {// 分包
				ncVo.setTradetype("F3-Cxx-001"); // 交易类型
			}
			if (payContractVO.getContractType() == 2) {// 设备采购
				ncVo.setTradetype("F3-Cxx-004"); // 交易类型
			}
			if (payContractVO.getContractType() == 3) {// 设备租赁
				ncVo.setTradetype("F3-Cxx-005"); // 交易类型
			}
			if (payContractVO.getContractType() == 4) {// 物资
				ncVo.setTradetype("F3-Cxx-002"); // 交易类型
			}
			if (payContractVO.getContractType() == 5) {// 周转材租赁
				ncVo.setTradetype("F3-Cxx-003"); // 交易类型
			}
			if (payContractVO.getContractType() == 6) {// 其它支出
				ncVo.setTradetype("F3-Cxx-008"); // 交易类型
			}
			ncVo.setPk_supplier(String.valueOf(payContractVO.getReceiveUnitId())); // 供应商主键
			SupplierVO supplierVO = ncUtil.querySupplierById(payContractVO.getReceiveUnitId());
			ncVo.setSupname(supplierVO.getName());// 供应商名称
			ncVo.setTaxpayerid(supplierVO.getSocialCreditCode());// 纳税人识别号
			ncVo.setDef6(supplierVO.getInsideOrgId() != null);// 是否内部单位 true/false
//	        ncVo.setBalatype(ncUtil.getDefDocById(payContractEntity.getPaymentMethod()).getCode()); //结算方式
			ncVo.setDef19(payContractVO.getBillCode()); // 单据编号
			ncVo.setDef20(ncUtil.getWebSite("ejc-finance-frontend/#/manageList/contractCard?id=" + payContractVO.getId()));// 外部访问url
			ncVo.setDef21("BT200611000000017");// 单据类型
			
			
			PayBillDetailVO detailVO = new PayBillDetailVO();
			detailVO.setPk_project(String.valueOf(payContractVO.getProjectId())); // 项目主键
			detailVO.setBalatype(ncUtil.getDefDocById(payContractVO.getPaymentMethod()).getCode()); // 结算方式
			detailVO.setLocal_mny(payInfoVo.getPayMny()); // 组织本币金额(支付金额)
			detailVO.setCashitem(ncUtil.getDefDocById(payContractVO.getCashItemId()).getCode()); // 现金流量
			detailVOS.add(detailVO);
			
		}else if("LX".equals(payInfoVo.getPayInfoType())) {
			PaySporadicVO paySporadicVO=sporadicService.queryDetail(payInfoVo.getPayapplyId());
			ncVo.setTradetype("F3-Cxx-022");//零星费用
	        ncVo.setPk_supplier(String.valueOf(paySporadicVO.getSupplierId())); // 供应商主键
	        SupplierVO supplierVO = ncUtil.querySupplierById(paySporadicVO.getSupplierId());
	        ncVo.setSupname(supplierVO.getName());// 供应商名称
	        ncVo.setTaxpayerid(supplierVO.getSocialCreditCode());// 纳税人识别号
	        ncVo.setDef6(supplierVO.getInsideOrgId() != null);// 是否内部单位 true/false
     	    ncVo.setBalatype(ncUtil.getDefDocById(paySporadicVO.getPaymentMethod()).getCode()); //结算方式
	        ncVo.setDef19(paySporadicVO.getBillCode()); //单据编号
	        ncVo.setDef20(ncUtil.getWebSite("ejc-finance-frontend/#/manageList/contractCard?id=" + paySporadicVO.getId()));// 外部访问url
	        ncVo.setDef21("BT200611000000017");// 单据类型
	        
            PayBillDetailVO detailVO = new PayBillDetailVO();
            detailVO.setPk_project(String.valueOf(paySporadicVO.getProjectId())); // 项目主键
            detailVO.setBalatype(ncUtil.getDefDocById(paySporadicVO.getPaymentMethod()).getCode()); //结算方式
            detailVO.setLocal_mny(payInfoVo.getPayMny()); // 组织本币金额(支付金额)
            //detailVO.setTaxmny(payContractEntity.getPayMny()); //税额（不传）
            detailVO.setCashitem(ncUtil.getDefDocById(paySporadicVO.getCashItemId()).getCode()); //现金流量
            detailVOS.add(detailVO);
		}else if("QT".equals(payInfoVo.getPayInfoType())) {
			PayReimburseVO payReimburseVo=reimburseService.queryDetail(payInfoVo.getPayapplyId());
	        ncVo.setTradetype("F3-Cxx-021");//间接费（其他费用）
	        
	        ncVo.setPk_supplier("5465813256496854"); // 供应商主键
//	        SupplierVO supplierVO = ncUtil.querySupplierById(payReimburseEntity.getReceiveUnitId());
	        ncVo.setSupname("集团通用供应商");// 供应商名称
	        ncVo.setTaxpayerid("9999-000");// 纳税人识别号
	        ncVo.setDef6(false);// 是否内部单位 true/false
     	    ncVo.setBalatype(ncUtil.getDefDocById(payReimburseVo.getPaymentMethod()).getCode()); //结算方式
	        ncVo.setDef19(payReimburseVo.getBillCode()); //单据编号
	        ncVo.setDef20(ncUtil.getWebSite("ejc-finance-frontend/#/manageList/contractCard?id=" + payReimburseVo.getId()));// 外部访问url
	        ncVo.setDef21("BT200611000000017");// 单据类型
	        
	        PayBillDetailVO detailVO = new PayBillDetailVO();
	        detailVO.setPk_project(String.valueOf(payReimburseVo.getProjectId())); // 项目主键
	        detailVO.setBalatype(ncUtil.getDefDocById(payReimburseVo.getPaymentMethod()).getCode()); //结算方式
	        detailVO.setLocal_mny(payReimburseVo.getPayMny()); // 组织本币金额(支付金额)
	        detailVO.setCashitem(ncUtil.getDefDocById(payReimburseVo.getCashItemId()).getCode()); //现金流量
	        detailVOS.add(detailVO);
		}
		ncVo.setDetail(detailVOS);
		return ncVo;
	}
	
	
	/**
	 * 回写合同累计付款、累计预付款金额与结算单累计付款金额
	 *
	 * @param billId
	 * @param entity
	 * @param flag
	 */
	public boolean writeBackSumPayMny(PayInfoVO payInfoVo, boolean flag) {
		PayContractVO payContractVO = payContractService.queryDetail(payInfoVo.getPayapplyId());
		// 本期付款金额 true为回写，false为逆回写
		BigDecimal payMny = flag ? payInfoVo.getPayMny() : MathUtil.safeSub(new BigDecimal(0), payInfoVo.getPayMny());
		// 预付款时等于本期付款金额
		BigDecimal prepayMny = payContractVO.getFeeType() == 1 ? payMny : BigDecimal.ZERO;
		List<PayContractSettleEntity> settleEntityList = settleService
				.list(new QueryWrapper<PayContractSettleEntity>().eq("payapply_id", payInfoVo.getId()));
		// 结算单对应本期申请金额
		Map<Long, BigDecimal> settleApplyMnyMap = new HashMap<>();
		for (PayContractSettleEntity settleEntity : settleEntityList) {
			// 本期申请金额 true为回写，false为逆回写
			BigDecimal applyMny = flag ? settleEntity.getBodyApplyMny()
					: MathUtil.safeSub(new BigDecimal(0), settleEntity.getBodyApplyMny());
			settleApplyMnyMap.put(settleEntity.getSettleId(), applyMny);
		}

		if (payContractVO.getContractType() == 1) {// 分包
			subApi.updateSubContractSumPayMny(payContractVO.getContractId(), payMny, prepayMny);// 合同
			for (PayContractSettleVO payContractSettleVO : payContractVO.getSettleVOList()) {
				if("网银".equals(payContractSettleVO.getSettlePaymentMethodName())) {
					subApi.updateSubSettleSumPayMny(payContractSettleVO.getSettleId(),
							settleApplyMnyMap.get(payContractSettleVO.getSettleId()));// 结算单
				}
			}
		}
		if (payContractVO.getContractType() == 2) {// 设备采购
			equipmentApi.updatePurchaseContractSumPayMny(payContractVO.getContractId(), payMny, prepayMny);// 合同
			for (PayContractSettleVO payContractSettleVO : payContractVO.getSettleVOList()) {
				if("网银".equals(payContractSettleVO.getSettlePaymentMethodName())) {	
			equipmentApi.updatePurchaseSettleSumPayMny(payInfoVo.getSettleId(),
						settleApplyMnyMap.get(payInfoVo.getSettleId()));// 结算单
				}
				}
		}
		if (payContractVO.getContractType() == 3) {// 设备租赁
			equipmentApi.updateRentContractSumPayMny(payContractVO.getContractId(), payMny, prepayMny);// 合同
			for (PayContractSettleVO payContractSettleVO : payContractVO.getSettleVOList()) {
				if("网银".equals(payContractSettleVO.getSettlePaymentMethodName())) {	
				equipmentApi.updateRentSettleSumPayMny(payInfoVo.getSettleId(),
						settleApplyMnyMap.get(payInfoVo.getSettleId()));// 结算单
				}}
		}
		if (payContractVO.getContractType() == 4) {// 物资采购
			equipmentApi.updateRentContractSumPayMny(payContractVO.getContractId(), payMny, prepayMny);// 合同
			for (PayContractSettleVO payContractSettleVO : payContractVO.getSettleVOList()) {
				if("网银".equals(payContractSettleVO.getSettlePaymentMethodName())) {		
			materialApi.updateSettlementBillAlreadyPaidAmount(payInfoVo.getSettleId(),
						settleApplyMnyMap.get(payInfoVo.getSettleId()));// 结算单
				}}
		}
		if (payContractVO.getContractType() == 5) {// 物资租赁
			rmatContractApi.updateRentContractSumPayMny(payContractVO.getContractId(), payMny, prepayMny);// 合同
			for (PayContractSettleVO payContractSettleVO : payContractVO.getSettleVOList()) {
				if("网银".equals(payContractSettleVO.getSettlePaymentMethodName())) {
				rmatContractApi.updateRentSettleSumPayMny(payInfoVo.getSettleId(),
						settleApplyMnyMap.get(payInfoVo.getSettleId()));// 结算单
				}}
		}
		if (payContractVO.getContractType() == 6) {// 其它支出
			otherContractApi.updateOtherContractSumPayMny(payContractVO.getContractId(), payMny, prepayMny);// 合同
			for (PayContractSettleVO payContractSettleVO : payContractVO.getSettleVOList()) {
				if("网银".equals(payContractSettleVO.getSettlePaymentMethodName())) {
				otherContractApi.updateOtherSettleSumPayMny(payInfoVo.getSettleId(),
						settleApplyMnyMap.get(payInfoVo.getSettleId()));// 结算单
				}}
		}
		return true;
	}
	
    public Map<Long, String> getDefdocMap(Long id) {
        CommonResponse<List<DefdocDetailVO>> resp = defdocApi.getDefDocByDefId(id);
        if(resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())){
            List<DefdocDetailVO> list = resp.getData();
            return list.stream().collect(Collectors.toMap(DefdocDetailVO::getId, DefdocDetailVO::getCode));
        }
        return new HashMap<>();
    }
}
