package com.ejianc.business.finance.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.finance.bean.PayInvoiceEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.bean.PayReimburseFeetypeEntity;
import com.ejianc.business.finance.mapper.PayReimburseMapper;
import com.ejianc.business.finance.service.IPayInvoiceService;
import com.ejianc.business.finance.service.IPayReimburseFeetypeService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.util.ValidateUtil;
import com.ejianc.business.finance.utils.FeignUtil;
import com.ejianc.business.finance.utils.NCUtil;
import com.ejianc.business.finance.vo.PayInvoiceVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.qdsz.nc.vo.PayBillDetailVO;
import com.ejianc.business.qdsz.nc.vo.PayBillVO;
import com.ejianc.business.sub.api.ISubContractForPayApi;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveFlagVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-05-28
 */
@Service
public class PayReimburseServiceImpl extends BaseServiceImpl<PayReimburseMapper, PayReimburseEntity> implements IPayReimburseService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String REIM_PAYAPPLY_BILL_CODE = "REIM_PAYAPPLY";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IPayInvoiceService invoiceService;

    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPayReimburseFeetypeService iPayReimburseFeetypeService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private FeignUtil feignUtil;
    
    @Autowired
    private NCUtil ncUtil;
    
    @Autowired
    private ISubContractForPayApi subApi;
    
    @Autowired
    private IDefdocApi defdocApi;
    
    
    @Override
    public PayReimburseVO insertOrUpdate(PayReimburseVO vo) {
        PayReimburseEntity entity = BeanMapper.map(vo, PayReimburseEntity.class);
        // 自动生成编码
        this.autoSetBillCode(entity);
        //设置默认值
        entity.setProportionFlag("0");
        entity.setRelationFlag("0");
        // 设置默认是否需要发票
        if (StringUtils.isEmpty(entity.getInvoiceFlag())) {
            entity.setInvoiceFlag("3");
        }
        
        // 是否需要回写
        boolean writeFlag = this.getWriteFlag(vo);
        
        // 保存主表
        super.saveOrUpdate(entity);
        //成本改造
        if (2 == vo.getPayStatus()){
            PayReimburseEntity payReimburseEntity = super.selectById(entity.getId());
            costPush(payReimburseEntity);
        }
        Long id = entity.getId();
        // 更新发票
        List<PayInvoiceVO> invoiceVOList = this.updateInvoiceVOS(vo, id);
        
        // 确认支付回写累计付款与累计预付款金额
        if (writeFlag) {
        	//确认支付生成凭证并回写NC
            ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(entity.getProjectId())).get(0);
        	if ("1".equals(project.getIndustryIntegrationFlag())){
                this.pushToNcAr(entity);
            }
             //TODO 实付款回写方法
        	//        	this.writeBackSumPayMny(id, entity, true);
        }
        
        // 返回VO
        PayReimburseVO backVO = BeanMapper.map(super.getById(id), PayReimburseVO.class);
        backVO.setInvoiceVOList(invoiceVOList);// 发票列表
        return backVO;
    }

    /**
     * 更新发票
     * @param vo
     * @param id
     * @return
     */
    private List<PayInvoiceVO> updateInvoiceVOS(PayReimburseVO vo, Long id) {
        // 新增
        List<PayInvoiceVO> voList = vo.getInvoiceVOList();
        List<InvoiceReceiveFlagVO> flagVOS = new ArrayList<>();
        List<Long> receiveIds = new ArrayList<>();
        if(voList != null && !voList.isEmpty()){
            for(PayInvoiceVO invoiceVO : voList){
                // 保存时校验version是否一致
                if(!ValidateUtil.validateUpstreamVersion(String.valueOf(invoiceVO.getInvoiceId()),
                        BillTypeCodeEnum.税务收票.getBillTypeCode(), invoiceVO.getInvoiceVersion())){
                    throw new BusinessException("发票已被更新，请刷新后重做！");
                }
                InvoiceReceiveFlagVO flagVO = new InvoiceReceiveFlagVO();
                flagVO.setId(invoiceVO.getInvoiceId());
                flagVO.setFlag(1);
                flagVOS.add(flagVO);
                receiveIds.add(invoiceVO.getInvoiceId());
                invoiceVO.setPayapplyId(id);
            }
            List<PayInvoiceEntity> entityList = BeanMapper.mapList(voList, PayInvoiceEntity.class);
            invoiceService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList(entityList, PayInvoiceVO.class);
        }
        // 删除
        List<Long> voIds = voList.stream().map(PayInvoiceVO::getId).collect(Collectors.toList());
        List<PayInvoiceEntity> dataList = invoiceService.list(new QueryWrapper<PayInvoiceEntity>().eq("payapply_id", id));
        List<Long> dataIds = dataList.stream().map(PayInvoiceEntity::getId).collect(Collectors.toList());
        dataIds.removeAll(voIds);
        List<Long> delIds = dataIds;
        if(!delIds.isEmpty()){
            invoiceService.remove(new QueryWrapper<PayInvoiceEntity>().in("id", delIds), false);
        }
        // 回写收票是否占用
        for(PayInvoiceEntity data : dataList){
            if(delIds.contains(data.getId()) && !receiveIds.contains(data.getInvoiceId())){
                InvoiceReceiveFlagVO flagVO = new InvoiceReceiveFlagVO();
                flagVO.setId(data.getInvoiceId());
                flagVO.setFlag(0);
                flagVOS.add(flagVO);
            }
        }
        if(!flagVOS.isEmpty()){
            invoiceApi.updateFlag(flagVOS);
        }
        return voList;
    }

    @Override
    public PayReimburseVO queryDetail(Long id) {
        // 查询主表
        PayReimburseEntity entity = baseMapper.selectById(id);
        PayReimburseVO vo = BeanMapper.map(entity, PayReimburseVO.class);
        // 查询关联发票
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter(QueryParam.EQ, vo.getId()));
        queryParam.getOrderMap().put("createTime", "desc");
        List<PayInvoiceEntity> invoiceEntityList = invoiceService.queryList(queryParam, false);
        vo.setInvoiceVOList(BeanMapper.mapList(invoiceEntityList, PayInvoiceVO.class));
        return vo;
    }

    @Override
    public List<PayReimburseVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List<PayReimburseVO> resVos = (List<PayReimburseVO>) queryPageJson(param, false).get("records");    
//       Map<String, String> freeTypeMap=null;
//        List<PayReimburseFeetypeEntity>payReimburseFeetypeList=iPayReimburseFeetypeService.list();
//        if(payReimburseFeetypeList.size()>0) {
//        	freeTypeMap=payReimburseFeetypeList.stream().collect(Collectors.toMap(PayReimburseFeetypeEntity::getFeetypeCode, PayReimburseFeetypeEntity::getFeetypeName));
//        }
    
        if(!resVos.isEmpty()){
            for(int i = 0 ; i< resVos.size(); i++){
                PayReimburseVO vo = resVos.get(i);
                if(vo.getPayMny() ==null) {
                	vo.setPayMny(new BigDecimal(0));
                }
                if(vo.getInvoiceMny()==null) {
                	vo.setInvoiceMny(new BigDecimal(0));
                }
//                vo.setFeeTypeName(freeTypeMap.get(String.valueOf(vo.getFeeType())));
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            };
        }
        return resVos;
    }

    @Override
    public String delete(List<Long> ids) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<PayReimburseEntity> entityList = super.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(entityList)) {
            super.removeByIds(ids, false);
            // 删除发票
            QueryWrapper wrapper = new QueryWrapper<PayInvoiceEntity>().in("payapply_id", ids);
            List<PayInvoiceEntity> invoiceList = invoiceService.list(wrapper);
            invoiceService.remove(wrapper, false);
            // 回写收票是否占用
            List<InvoiceReceiveFlagVO> flagVOS = new ArrayList<>();
            for(PayInvoiceEntity data : invoiceList){
                InvoiceReceiveFlagVO flagVO = new InvoiceReceiveFlagVO();
                flagVO.setId(data.getInvoiceId());
                flagVO.setFlag(0);
                flagVOS.add(flagVO);
            }
            if(!flagVOS.isEmpty()){
                invoiceApi.updateFlag(flagVOS);
            }
        }
        return "删除成功！";
    }

    @Override
    public JSONObject queryPageJson(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("payReason");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();

        Page<PayReimburseVO> pages = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PayReimburseVO> list = baseMapper.queryPageList(pages, wrapper, flag);

        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", list);
        page.put("total", pages.getTotal());
        page.put("current", pages.getCurrent());
        page.put("size", pages.getSize());
        page.put("pages", pages.getPages());
        return page;
    }


    @Override
    public Map<String, Object> countAmt(Long tenantId, List<Long> projectIds, List<Long> orgIds) {
        QueryWrapper<PayReimburseEntity> queryWrapper = new QueryWrapper<>();
        if (CollectionUtils.isNotEmpty(orgIds)) {
            queryWrapper.in("org_id", orgIds);
        }

        queryWrapper.select("ifnull(sum(pay_mny),0) as amt");

        queryWrapper.eq("tenant_id", tenantId);
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
//        付款类型：1-组织付款 2-项目付款
//        queryWrapper.eq("pay_type", 2);
//        支付状态：1-未支付 2-已支付
        queryWrapper.eq("pay_status", 2);

//        if(CollectionUtils.isNotEmpty(projectIds)) {
//            queryWrapper.in("project_id", projectIds);
//        }
//        已生效的单据
        queryWrapper.in("bill_state",
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()}));

        return super.getMap(queryWrapper);
    }

    @Override
    public CommonResponse<PayReimburseVO> pushCost(PayReimburseVO payReimburseVO) {
        PayReimburseEntity payReimburseEntity = baseMapper.selectById(payReimburseVO.getId());
        payReimburseEntity.setSubjectId(payReimburseVO.getSubjectId());
        payReimburseEntity.setSubjectName(payReimburseVO.getSubjectName());
        payReimburseEntity.setOrgSubjectId(payReimburseVO.getOrgSubjectId());
        payReimburseEntity.setAccountingId(payReimburseVO.getAccountingId());
        payReimburseEntity.setAccountingName(payReimburseVO.getAccountingName());
        payReimburseEntity.setOrgAccountingId(payReimburseVO.getOrgAccountingId());
        super.saveOrUpdate(payReimburseEntity,false);
        //推送数据
        costPush(payReimburseEntity);
        return CommonResponse.success(BeanMapper.map(payReimburseEntity, PayReimburseVO.class));
    }
    @Override
    public void costPush(PayReimburseEntity payReimburseEntity) {
        if (!"1".equals(payReimburseEntity.getDependOnProject())){
            return;
        }
        //1.判断是否关联
        Long subjectId = payReimburseEntity.getSubjectId();
        Long accountingId = payReimburseEntity.getAccountingId();
        boolean newRelationFlag = true;
        if(null == subjectId||null == accountingId){
            newRelationFlag = false;
        }
        //更新是否关联
        LambdaUpdateWrapper<PayReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(PayReimburseEntity::getId, payReimburseEntity.getId());
        updateWrapper.set(PayReimburseEntity::getRelationFlag, newRelationFlag ? "1":"0");//(1:是，0：否)
        super.update(updateWrapper);

        //判断之前的单据是否关联
        String oldRelationFlag = payReimburseEntity.getRelationFlag();
        //之前已关联
        if (oldRelationFlag.equals("1")){
            if (newRelationFlag){
                saveCost(payReimburseEntity);
            }
            if (!newRelationFlag){
                //删除成本中心之前的数据
                costDetailApi.deleteSubject(payReimburseEntity.getId());
            }
        }
        //之前未关联
        if (oldRelationFlag.equals("0")){
            if (newRelationFlag){
                //税率
                saveCost(payReimburseEntity);
            }
        }


    }
    private void saveCost(PayReimburseEntity payReimburseEntity) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        CostDetailVO costDetailVO = new CostDetailVO();
        costDetailVO.setSubjectId(payReimburseEntity.getSubjectId());
        costDetailVO.setOrgSubjectId(payReimburseEntity.getOrgSubjectId());
        costDetailVO.setAccountingId(payReimburseEntity.getAccountingId());
        costDetailVO.setOrgAccountingId(payReimburseEntity.getOrgAccountingId());
        costDetailVO.setSourceId(payReimburseEntity.getId());
        costDetailVO.setSourceDetailId(payReimburseEntity.getId());
        costDetailVO.setHappenTaxMny(payReimburseEntity.getPayMny());
        costDetailVO.setHappenMny(payReimburseEntity.getPayMny());
        costDetailVO.setHappenDate(payReimburseEntity.getApplyTime());
        costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
        costDetailVO.setSourceType(REIM_PAYAPPLY_BILL_CODE);
        costDetailVO.setSourceTabType(REIM_PAYAPPLY_BILL_CODE);
        costDetailVO.setProjectId(payReimburseEntity.getProjectId());
        costDetailVOList.add(costDetailVO);
        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)){
            costDetailVOList.toString();
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            if (stringCommonResponse.isSuccess()){
            }else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
    /**
     * 自动生成编码
     * @param entity
     */
    private void autoSetBillCode(PayReimburseEntity entity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(REIM_PAYAPPLY_BILL_CODE, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //修改  校验合同编号是否重复
        LambdaQueryWrapper<PayReimburseEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(PayReimburseEntity::getBillCode, entity.getBillCode());
        lambda.eq(PayReimburseEntity::getTenantId, tenantId);
        lambda.ne(entity.getId() != null && entity.getId() > 0, PayReimburseEntity::getId, entity.getId());
        List<PayReimburseEntity> entityList = super.list(lambda);
        if(entityList != null && entityList.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
    }
    //成本改造
    @Override
    public void pullCost(Long id) {
        ////更新关联状态为未关联
        LambdaUpdateWrapper<PayReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(PayReimburseEntity::getId, id);
        updateWrapper.set(PayReimburseEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
        //删除成本中心数据
        costDetailApi.deleteSubject(id);
    }

    @Override
    public TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();

        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PayReimburseVO> list = baseMapper.queryPageList(null, wrapper, flag);

        // 过滤为空的数据并求和
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null)
                .map(PayReimburseVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null)
                .map(PayReimburseVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);

        return vo;
    }

    @Override
    public TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();

        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PayReimburseVO> list = baseMapper.queryPageList(null, wrapper, flag);

        // 过滤为空的数据并求和
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null)
                .map(PayReimburseVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null)
                .map(PayReimburseVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);

        return vo;
    }
    
    /**
     * 是否需要回写
     *
     * @param vo
     * @return
     */
    private boolean getWriteFlag(PayReimburseVO vo) {
        boolean writeFlag = false;
        if (vo.getId() != null) {
        	PayReimburseEntity data = super.selectById(vo.getId());
            Integer payStatus = data.getPayStatus();
            // 确认支付
            if (payStatus != vo.getPayStatus() && vo.getPayStatus() == 2) {
                writeFlag = true;
            }
        }
        return writeFlag;
    }
    
    /**
     * 推送NC传应付单凭证
     * @param PayReimburseEntity
     */
    private void pushToNcAr(PayReimburseEntity payReimburseEntity){

    	PayBillVO vo = transferToNCVO(payReimburseEntity);
    	
    	//根据费用类别id查询编码
    	Long feedtailid = payReimburseEntity.getFeeType();
    	Map<Long, String> defdocMap = this.getDefdocMap(feedtailid);
    	String feedetail = defdocMap.get(payReimburseEntity.getFeeType());
    	
    	//测试用，写死费用类别id，查询费用类别编码
//    	Map<Long, String> defdocMap = this.getDefdocMap(324875125018329093L);
//    	String feedetail = defdocMap.get(payReimburseEntity.getFeeType());
    	
    	//获取车号编码
    	Long carNoCodes = payReimburseEntity.getCarNo();
    	Map<Long, String> defdocMapcar = this.getDefdocMap(carNoCodes);
    	String carNoCode = defdocMapcar.get(payReimburseEntity.getCarNo());
    	
        ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(payReimburseEntity.getProjectId())).get(0);
        StringBuffer sb = new StringBuffer();
        
        if(payReimburseEntity.getApplyOrgId().equals(payReimburseEntity.getActualOrgId())){
            //【付款组织】和【实际付款组织】相同

            //根据开票主体决定传多少个凭证
            List<Long> orgIds = ncUtil.validateInvoiceMainOrg(payReimburseEntity.getApplyOrgId(), project.getMainOrgId());
            for(Long orgId:orgIds){
                vo.setPk_org(ncUtil.queryOrgById(orgId).getCode());
                String jsonString = JSONObject.toJSON(vo).toString();
                
//              String endjson = jsonString.replace(":[{", ":[{\"feedetail\":\""+ feedetail + "\",");
//              String endjsons = endjson.replace(",\"balatype", ",\"def30\":\""+ 10203003 + "\",\"balatype");
                String endjson = jsonString.replace(":[{", ":[{\"feedetail\":\""+ feedetail + "\",");//推送费用类别编码
                if(carNoCode != null) {
                	String endjsons = endjson.replace(",\"detail", ",\"def30\":\""+ carNoCode + "\",\"detail");//推送车号编码
                	String sourceId = ncUtil.postByJson(endjsons);// 调用NC传凭证接口
                    sb.append(sourceId).append(",");
                }else {
                	String sourceId = ncUtil.postByJson(endjson);// 调用NC传凭证接口
                    sb.append(sourceId).append(",");
                }
                
            }
        }else{
            //【收款组织】和【实际收款组织】不同

            //先传付款组织
            //根据开票主体决定传多少个凭证
            List<Long> orgIds = ncUtil.validateInvoiceMainOrg(payReimburseEntity.getApplyOrgId(), project.getMainOrgId());
            for(Long orgId:orgIds){
                vo.setPk_org(ncUtil.queryOrgById(orgId).getCode());
                String jsonString = JSONObject.toJSON(vo).toString();

//              String endjson = jsonString.replace(":[{", ":[{\"feedetail\":\""+ feedetail + "\",");
//              String endjsons = endjson.replace(",\"balatype", ",\"def30\":\""+ 10203003 + "\",\"balatype");
                String endjson = jsonString.replace(":[{", ":[{\"feedetail\":\""+ feedetail + "\",");//推送费用类别编码
                if(carNoCode != null) {
                	String endjsons = endjson.replace(",\"detail", ",\"def30\":\""+ carNoCode + "\",\"detail");//推送车号编码
                	String sourceId = ncUtil.postByJson(endjsons);// 调用NC传凭证接口
                    sb.append(sourceId).append(",");
                }else {
                	String sourceId = ncUtil.postByJson(endjson);// 调用NC传凭证接口
                    sb.append(sourceId).append(",");
                }
                
            }

            //再先传实际付款组织
            PayBillDetailVO payBillDetailVO2 = vo.getDetail().get(0);
            payBillDetailVO2.setBankaccount(payReimburseEntity.getAccountNum()); //传实际付款组织的银行账户
            //根据开票主体决定传多少个凭证
            List<Long> orgIds2 = ncUtil.validateInvoiceMainOrg(payReimburseEntity.getActualOrgId(), project.getMainOrgId());
            for(Long orgId:orgIds2){
                vo.setPk_org(String.valueOf(orgId));
                String jsonString = JSONObject.toJSON(vo).toString();
//              
//              String endjson = jsonString.replace(":[{", ":[{\"feedetail\":\""+ feedetail + "\",");
//              String endjsons = endjson.replace(",\"balatype", ",\"def30\":\""+ 10203003 + "\",\"balatype");
                String endjson = jsonString.replace(":[{", ":[{\"feedetail\":\""+ feedetail + "\",");//推送费用类别编码
                if(carNoCode != null) {
                	String endjsons = endjson.replace(",\"detail", ",\"def30\":\""+ carNoCode + "\",\"detail");//推送车号编码
                	String sourceId = ncUtil.postByJson(endjsons);// 调用NC传凭证接口
                    sb.append(sourceId).append(",");
                }else {
                	String sourceId = ncUtil.postByJson(endjson);// 调用NC传凭证接口
                    sb.append(sourceId).append(",");
                }
                
            }
        }
       
        String sourceIds = sb.substring(0,sb.length()-1);

        LambdaUpdateWrapper<PayReimburseEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(PayReimburseEntity::getSourceId, sourceIds);// 保存来源主键
        wrapper.eq(PayReimburseEntity::getId, payReimburseEntity.getId());
        super.update(wrapper);
    }
    
    
    /**
     * 转换成NCVO
     * @param payReimburseEntity
     * @return
     */
    private PayBillVO transferToNCVO(PayReimburseEntity payReimburseEntity){

//    	Long wy = 1460221804369940481L;
//    	if(payReimburseEntity.getPaymentMethod() != wy) {
//    		
//    	}
        logger.info("----付款单传凭证开始:");
        PayBillVO ncVo = new PayBillVO();
        ncVo.setBusitype("paybill"); // 业务标识(默认paybill)
        ncVo.setTradetype("F3-Cxx-021");//间接费（其他费用）
        
            ncVo.setPk_project(String.valueOf(payReimburseEntity.getProjectId()));// 项目主键
            ProjectRegisterVO project = ncUtil.queryProjectByIds(Arrays.asList(payReimburseEntity.getProjectId())).get(0);
//            ncVo.setPk_project(String.valueOf(payReimburseEntity.getProjectId()));// 项目主键
            ncVo.setDef1(null != project.getMeasurementCertificate() && 1 == project.getMeasurementCertificate() ? true : false);// 是否有计量证书
            ncVo.setDef2(ncUtil.getInvoiceMainDefCode(project.getInvoiceMainCategory()));// 开票主体分类 0-PMDA06001,1-PMDA06002
            ncVo.setDef3(ncUtil.getTaxWayDefCode(project.getTaxWay()));// 计税方式 0-01,1-02
            ncVo.setDef4(ncUtil.getDefDocById(project.getEngineeringType()).getCode());// 工程类型
            if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(project.getAreaCode())){
                throw new BusinessException("项目-区域不能为空！");
            }
            ncVo.setDef5(project.getAreaCode());// 区域编码
        ncVo.setDef12(String.valueOf(payReimburseEntity.getId())); // PM单据主键
        
        ncVo.setPk_supplier("5465813256496854"); // 供应商主键
//        SupplierVO supplierVO = ncUtil.querySupplierById(payReimburseEntity.getReceiveUnitId());
        ncVo.setSupname("集团通用供应商");// 供应商名称
        ncVo.setTaxpayerid("9999-000");// 纳税人识别号
        ncVo.setDef6(false);// 是否内部单位 true/false
        
//        ncVo.setPk_supplier(String.valueOf(payContractEntity.getReceiveUnitId())); // 供应商主键
//        SupplierVO supplierVO = ncUtil.querySupplierById(payContractEntity.getReceiveUnitId());
//        ncVo.setSupname(supplierVO.getName());// 供应商名称
//        ncVo.setTaxpayerid(supplierVO.getSocialCreditCode());// 纳税人识别号
//        ncVo.setDef6(supplierVO.getInsideOrgId() != null);// 是否内部单位 true/false
////    ncVo.setBalatype(ncUtil.getDefDocById(payContractEntity.getPaymentMethod()).getCode()); //结算方式
        ncVo.setDef19(payReimburseEntity.getBillCode()); //单据编号
        ncVo.setDef20(ncUtil.getWebSite("ejc-finance-frontend/#/manageList/contractCard?id=" + payReimburseEntity.getId()));// 外部访问url
        ncVo.setDef21("BT200611000000017");// 单据类型

        List<PayBillDetailVO> detailVOS = new ArrayList<>();
        
        PayBillDetailVO detailVO = new PayBillDetailVO();
        detailVO.setPk_project(String.valueOf(payReimburseEntity.getProjectId())); // 项目主键
        detailVO.setBalatype(ncUtil.getDefDocById(payReimburseEntity.getPaymentMethod()).getCode()); //结算方式
        detailVO.setLocal_mny(payReimburseEntity.getPayMny()); // 组织本币金额(支付金额)
        detailVO.setCashitem(ncUtil.getDefDocById(payReimburseEntity.getCashItemId()).getCode()); //现金流量
        
        detailVOS.add(detailVO);
        ncVo.setDetail(detailVOS);
        

        return ncVo;
    }
    

    public Map<Long, String> getDefdocMap(Long id) {
        CommonResponse<List<DefdocDetailVO>> resp = defdocApi.getDefDocByDefId(id);
        if(resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())){
            List<DefdocDetailVO> list = resp.getData();
            return list.stream().collect(Collectors.toMap(DefdocDetailVO::getId, DefdocDetailVO::getCode));
        }
        return new HashMap<>();
    }
    
    /**
     * 回写合同累计付款、累计预付款金额与发票累计付款金额
     *
     * @param billId
     * @param entity
     * @param flag
     */
    public boolean writeBackSumPayMny(Long billId, PayReimburseEntity entity, boolean flag) {
        // 本期付款金额   true为回写，false为逆回写
        BigDecimal payMny = flag ? entity.getPayMny() : MathUtil.safeSub(new BigDecimal(0), entity.getPayMny());
        // 预付款时等于本期付款金额
        BigDecimal prepayMny = entity.getMeetType() == 1 ? payMny : BigDecimal.ZERO;
        List<PayInvoiceEntity> invoiceEntityList = invoiceService
        		.list(new QueryWrapper<PayInvoiceEntity>().eq("payapply_id", billId));
//      // 结算单对应本期申请金额
        Map<Long, BigDecimal> settleApplyMnyMap = new HashMap<>();
        for (PayInvoiceEntity settleEntity : invoiceEntityList) {
            // 本期申请金额   true为回写，false为逆回写
            BigDecimal applyMny = flag ? settleEntity.getInvoiceTaxMny()
            		: MathUtil.safeSub(new BigDecimal(0), settleEntity.getInvoiceTaxMny());
            settleApplyMnyMap.put(settleEntity.getInvoiceId(), applyMny);
        }
        
        
        return true;
    }
}
