package com.ejianc.business.finance.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class XmlUtils {
	/**
	 * 获得POJO对象对应的XML字符串
	 * 
	 * @param obj
	 * @return xml字符串
	 */
	public static String getXmlFromObject(Object obj) {
		JAXBContext context;
		try {
			context = JAXBContext.newInstance(obj.getClass());
			Marshaller m = context.createMarshaller();
			m.setProperty("jaxb.encoding", "ISO-8859-1");
            m.setProperty(Marshaller.JAXB_FRAGMENT, true);
			StringWriter sw = new StringWriter();
			m.marshal(obj, sw);
			return sw.toString();
		} catch (JAXBException e) {
			e.printStackTrace();
			return null;
		}
	}
	
	/**
	 * 根据XML生成JAVA对象
	 * 
	 * @param obj
	 * @return xml字符串
	 */
	public static Object getObjectFromXml(Object obj, String xmlStr) {
		JAXBContext context;
		try {
			context = JAXBContext.newInstance(obj.getClass());
			Unmarshaller um = context.createUnmarshaller();
			StringReader stringReader = new StringReader(xmlStr);
			obj = um.unmarshal(stringReader);
			return obj;
		} catch (JAXBException e) {
			e.printStackTrace();
			return null;
		}
	}
	
	public static String sendXml(String xml, String urlStr) throws Exception {
		String result;
		URL url = new URL(urlStr); 
		
		HttpURLConnection conn = (HttpURLConnection) url.openConnection();
		conn.setRequestMethod("POST");// 提交模式
		byte[] contentbyte = xml.getBytes("UTF-8");
		conn.setRequestProperty("Content-Type", "text/plain");
		conn.setRequestProperty("Content-Length", "" + contentbyte.length);
		conn.setRequestProperty("Content-Language", "en-US");
		conn.setConnectTimeout(30000);// 连接超时 单位毫秒
		conn.setReadTimeout(30000);// 读取超时 单位毫秒
		conn.setUseCaches(false);
		conn.setDoInput(true); // 允许输入
		conn.setDoOutput(true);// 允许输出
		OutputStream out = conn.getOutputStream();
		out.write(contentbyte);
		out.flush();
		out.close();
		InputStream in = conn.getInputStream(); // 取返回值
		StringBuffer buffer = new StringBuffer();
		int k = 0;
		while (k != -1) {
			k = in.read();
			if (k != -1) {
				buffer.append((char) k);
			}
		}
		in.close();
		result = new String(buffer.toString().getBytes("iso-8859-1"), "UTF-8");
		conn.disconnect();
		return result;
	}
	public static String getResult(String url, String xml) throws Exception {
        PostMethod postMethod = new PostMethod(url);
        // 然后把Soap请求数据添加到PostMethod中
        byte[] b = xml.getBytes("utf-8");
        InputStream is = new ByteArrayInputStream(b, 0, b.length);
        RequestEntity re = new InputStreamRequestEntity(is, b.length,"text/xml; charset=UTF-8");
        postMethod.setRequestEntity(re);
        // 最后生成一个HttpClient对象，并发出postMethod请求
        HttpClient httpClient = new HttpClient();
        int statusCode = httpClient.executeMethod(postMethod);
        String soapResponseData= "";
        if(statusCode == 200) {
            soapResponseData = postMethod.getResponseBodyAsString();
        }
        else {
            
        }
        return soapResponseData;
    }

}