package com.ejianc.business.finance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 项目资金计划
 * 
 * @author generator
 * 
 */
 @TableName("ejc_finance_project_capital_plan")
public class ProjectCapitalPlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 合同名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="plan_date")
    private Date planDate; // 计划日期
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="plan_back_total_mny")
    private BigDecimal planBackTotalMny; // 计划回款金额合计
    @TableField(value="plan_payment_total_mny")
    private BigDecimal planPaymentTotalMny; // 计划支付金额合计
    @TableField(value="employee_id")
    private Long employeeId; // 编制人
    @TableField(value="employee_name")
    private String employeeName; // 编制人名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父组织名称


    @TableField(exist = false)
    @SubEntity(serviceName = "projectCapitalBackPlanService", pidName = "pid")
    private List<ProjectCapitalBackPlanEntity> backPlanList = new ArrayList<>();

    @TableField(exist = false)
    @SubEntity(serviceName = "projectCapitalPaymentPlanService", pidName = "pid")
    private List<ProjectCapitalPaymentPlanEntity> paymentPlanList = new ArrayList<>();

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public BigDecimal getPlanBackTotalMny() {
        return planBackTotalMny;
    }

    public void setPlanBackTotalMny(BigDecimal planBackTotalMny) {
        this.planBackTotalMny = planBackTotalMny;
    }
    public BigDecimal getPlanPaymentTotalMny() {
        return planPaymentTotalMny;
    }

    public void setPlanPaymentTotalMny(BigDecimal planPaymentTotalMny) {
        this.planPaymentTotalMny = planPaymentTotalMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }


    public List<ProjectCapitalBackPlanEntity> getBackPlanList() {
        return backPlanList;
    }

    public void setBackPlanList(List<ProjectCapitalBackPlanEntity> backPlanList) {
        this.backPlanList = backPlanList;
    }

    public List<ProjectCapitalPaymentPlanEntity> getPaymentPlanList() {
        return paymentPlanList;
    }

    public void setPaymentPlanList(List<ProjectCapitalPaymentPlanEntity> paymentPlanList) {
        this.paymentPlanList = paymentPlanList;
    }
}
