package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.accplat.consts.SystemCodeEnum;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.utils.NumberToCN;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.voucher.api.IVoucherApi;
import com.ejianc.business.voucher.callable.AccplatVoucherCallable;
import com.ejianc.business.voucher.consts.VoucherFlag;
import com.ejianc.business.voucher.consts.VoucherOptFlag;
import com.ejianc.business.voucher.vo.VoucherParams;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

/**
 * <p>
 * 报销付款申请审批操作业务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@Service("payReimburse")
public class PayReimburseBpmServiceImpl implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPayReimburseService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPayRecordService recordService;


    @Autowired
    private IVoucherApi voucherApi;

    @Autowired
    private HttpServletRequest request;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    };

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaUpdateWrapper<PayReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(PayReimburseEntity::getId, billId);
        updateWrapper.set(PayReimburseEntity::getApproveTime, new Date());
        service.update(updateWrapper);
        return CommonResponse.success("回调处理成功！");
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TO DO 结算单是否被其他引用
        CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
        if(res.isSuccess()) {//单据未被下游单据引用
        }else{
            return CommonResponse.error(res.getMsg());
        }
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PayReimburseEntity entity = service.selectById(billId);

        if(Optional.ofNullable(entity.getCloseFlag()).orElse(false)){
            //撤回的话申请金额回滚,关闭信息清空
            BigDecimal applyMnyBeforeClose = entity.getApplyMnyBeforeClose();
            entity.setApplyMny(applyMnyBeforeClose);
            entity.setApplyMnyCn(NumberToCN.number2CN(applyMnyBeforeClose));
            entity.setCloseFlag(Boolean.FALSE);
            entity.setCloseState(null);
            entity.setCloseTime(null);
            entity.setCloseUser(null);
        }

        entity.setPayMny(null);
        entity.setPayStatus(1);
        entity.setApproveTime(null);
        service.saveOrUpdate(entity);
        logger.info("进入审批后回写--- entity:"+entity);
        //成本改造
        //删除成本中心数据, 更新关联状态为未关联
        service.pullCost(billId);
        // 删除付款记录表，因service.writeBackSumPayMny已全部撤回已支付合同及结算单，则不需要重新撤回结算单已支付金额，如需要再处理
        QueryWrapper<PayRecordEntity> recordQueryWrapper = new QueryWrapper<PayRecordEntity>().eq("payapply_id", billId);
        List<PayRecordEntity> recordEntities = recordService.list(recordQueryWrapper);
        recordService.remove(recordQueryWrapper);
        if(CollectionUtils.isNotEmpty(recordEntities)){
            // 支付记录有凭证则删除
            List<PayRecordEntity> listRec = recordEntities.stream().filter(t -> VoucherFlag.SUCCESS.equals(t.getVoucherFlag())).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(listRec)){
                ExecutorService threadPool = Executors.newFixedThreadPool(listRec.size());
                String authority = request.getHeader("authority");
                if (authority == null) {
                    logger.info("request-authority为空");
                    authority = (String) InvocationInfoProxy.getExtendAttribute("authority");
                }
                try {
                    for (PayRecordEntity recordEntity : listRec) {
                        VoucherParams voucherParamsDed = VoucherParams.newInstanceByOrgId(PayReimburseVO.BILL_TYPE_CODE, recordEntity, SystemCodeEnum.FINANCE);
                        Callable<CommonResponse> voucherCallable = new AccplatVoucherCallable(voucherApi, recordService, voucherParamsDed, VoucherOptFlag.DEL, RequestContextHolder.getRequestAttributes(), authority);
                        threadPool.submit(voucherCallable);
                    }
                } catch (Exception e) {
                    logger.error("报销撤回凭证异常, ", e);
                } finally {
                    threadPool.shutdown();
                }
            }
        }
        return CommonResponse.success("回调处理成功！");
    }

}
