package com.ejianc.entity;

import com.ejianc.framework.skeleton.template.BaseEntity;

import java.util.HashMap;

/**
 * 文件上传实体类
 * @author: yucaibi
 * @date: 2024
 */
public class UpLoad extends BaseEntity {

    private static final long serialVersionUID = -2614244573363772246L;
    
    /**
     * 文件类型ID
     */
    private String fileType;
    
    /**
     * 文件名称
     */
    private String fileName;
    
    /**
     * 文件的base64字符串
     */
    private String base64String;
    
    /**
     * 单据类型
     */
    private String billType;
    
    /**
     * 来源ID
     */
    private String sourceId;
    
    /**
     * 来源类型
     */
    private String sourceType;
    
    /**
     * 参数映射
     */
    private HashMap<String, Object> params;

    // Getter and Setter methods
    
    public String getFileType() {
        return fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getBase64String() {
        return base64String;
    }

    public void setBase64String(String base64String) {
        this.base64String = base64String;
    }

    public String getBillType() {
        return billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public HashMap<String, Object> getParams() {
        return params;
    }

    public void setParams(HashMap<String, Object> params) {
        this.params = params;
    }

    @Override
    public String toString() {
        return "UpLoad{" +
                "fileType='" + fileType + '\'' +
                ", fileName='" + fileName + '\'' +
                ", base64String='" + (base64String != null ? base64String.substring(0, Math.min(base64String.length(), 50)) + "..." : "null") + '\'' +
                ", billType='" + billType + '\'' +
                ", sourceId='" + sourceId + '\'' +
                ", sourceType='" + sourceType + '\'' +
                ", params=" + params +
                '}';
    }
}
