package com.ejianc.vo;

public class FileUploadResult {
    private final boolean success;
    private final String fileName;
    private final String rpaFileId;
    private final String errorMessage;

    private FileUploadResult(boolean success, String fileName, String rpaFileId, String errorMessage) {
        this.success = success;
        this.fileName = fileName;
        this.rpaFileId = rpaFileId;
        this.errorMessage = errorMessage;
    }

    public static FileUploadResult success(String fileName, String rpaFileId) {
        return new FileUploadResult(true, fileName, rpaFileId, null);
    }

    public static FileUploadResult failure(String errorMessage) {
        return new FileUploadResult(false, null, null, errorMessage);
    }

    public boolean isSuccess() { return success; }
    public String getFileName() { return fileName; }
    public String getRpaFileId() { return rpaFileId; }
    public String getErrorMessage() { return errorMessage; }
}
