package com.ejianc.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.entity.TemplateCategoryEntity;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.mapper.TemplateCategoryMapper;
import com.ejianc.vo.CategoryLevelVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


@RestController
@RequestMapping("templateCategory")
public class TemplateCategoryController {

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private TemplateCategoryMapper templateCategoryMapper;

    @PostMapping("/categoryTree")
    public CommonResponse<List<TemplateCategoryEntity>> categoryTree(@RequestBody(required = false) Map<String, Object> params) {
        QueryWrapper<TemplateCategoryEntity> wrapper = new QueryWrapper<>();
        //wrapper.eq("enable_status", 1);
       // wrapper.eq("tenant_id", 999999);

/*        if (StringUtils.isNotEmpty(String.valueOf(InvocationInfoProxy.getTenantid())))
        wrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());*/

        if (params != null) {

            // 范围
            if (params.get("range") != null) {
                String range = params.get("range").toString();
                switch (range) {
                    case "selfOrg":
                        wrapper.eq("belong_org_id", InvocationInfoProxy.getOrgId());
                        break;
                    case "selfAndBelow":
                        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(InvocationInfoProxy.getOrgType())) {
                            wrapper.eq("belong_org_id", InvocationInfoProxy.getOrgId());
                        } else {
                            CommonResponse<List<OrgVO>> orgVOListResp = orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
                            if (!orgVOListResp.isSuccess()) {
                                throw new BusinessException("查询失败，获取组织信息失败！");
                            }
                            List<Long> orgIds = orgVOListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
                            if (!orgIds.isEmpty()) {
                                wrapper.in("belong_org_id", orgIds);
                            }
                        }
                        break;
                    case "parents":
                        CommonResponse<List<OrgVO>> orgVOListResp = orgApi.findParentsByOrgId(InvocationInfoProxy.getOrgId());
                        if (!orgVOListResp.isSuccess()) {
                            throw new BusinessException("查询失败，获取组织信息失败！");
                        }
                        List<Long> orgIds = orgVOListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
                        if (!orgIds.isEmpty()) {
                            wrapper.in("belong_org_id", orgIds);
                        }
                        break;
                    default:
                        break;
                }
            }
        }

        //wrapper.orderByAsc("sequence");
        List<TemplateCategoryEntity> dataList = templateCategoryMapper.selectList(wrapper);
        return CommonResponse.success("查询列表数据成功！", dataList);
    }

    /**
     * 查询多级分类树结构
     * @return 多级分类树结构列表
     */
    @GetMapping("/categoryLevels")
    public CommonResponse<List<CategoryLevelVO>> getCategoryLevels() {
        List<CategoryLevelVO> list = templateCategoryMapper.selectCategoryLevels();
        return CommonResponse.success("查询多级分类树成功！", list);
    }
}
