/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.controller;

import com.ejianc.entity.UpLoad;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/upload"})
public class UploadFileController {
    private static final Logger logger = LoggerFactory.getLogger(UploadFileController.class);
    @Autowired
    private IAttachmentApi attachmentApi;

    @PostMapping(value={"/uploadFile"})
    public CommonResponse<List<AttachmentVO>> uploadFile(@RequestBody UpLoad upload) {
        logger.info("\u5f00\u59cb\u5904\u7406\u6587\u4ef6\u4e0a\u4f20\uff0c\u5355\u636e\u7c7b\u578b: {}, \u6765\u6e90ID: {}", (Object)upload.getBillType(), (Object)upload.getSourceId());
        try {
            if (!this.validateUploadParams(upload)) {
                return CommonResponse.error((String)"\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25");
            }
            String dataUri = this.buildDataUri(upload.getFileName(), upload.getBase64String());
            this.deleteExistingFiles(upload);
            return this.uploadNewFile(upload, dataUri);
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u5355\u636e\u7c7b\u578b: {}, \u6765\u6e90ID: {}", new Object[]{upload.getBillType(), upload.getSourceId(), e});
            return CommonResponse.error((String)("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: " + e.getMessage()));
        }
    }

    private boolean validateUploadParams(UpLoad upload) {
        if (upload == null) {
            logger.error("\u4e0a\u4f20\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((String)upload.getBase64String())) {
            logger.error("base64\u5b57\u7b26\u4e32\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((String)upload.getBillType()) || StringUtils.isBlank((String)upload.getSourceId()) || StringUtils.isBlank((String)upload.getSourceType())) {
            logger.error("\u5fc5\u8981\u53c2\u6570\u7f3a\u5931: billType={}, sourceId={}, sourceType={}", new Object[]{upload.getBillType(), upload.getSourceId(), upload.getSourceType()});
            return false;
        }
        if (!this.isValidBase64(upload.getBase64String())) {
            logger.error("\u65e0\u6548\u7684base64\u5b57\u7b26\u4e32");
            return false;
        }
        return true;
    }

    private void deleteExistingFiles(UpLoad upload) {
        try {
            Long sourceId = Long.valueOf(upload.getSourceId());
            this.attachmentApi.deleteFileByParam(sourceId, upload.getBillType(), upload.getSourceType());
            logger.debug("\u5df2\u5220\u9664\u5df2\u6709\u6587\u4ef6\uff0c\u6765\u6e90ID: {}", (Object)upload.getSourceId());
        }
        catch (NumberFormatException e) {
            logger.warn("\u6765\u6e90ID\u683c\u5f0f\u9519\u8bef\uff0c\u8df3\u8fc7\u5220\u9664\u64cd\u4f5c: {}", (Object)upload.getSourceId());
        }
        catch (Exception e) {
            logger.warn("\u5220\u9664\u5df2\u6709\u6587\u4ef6\u5931\u8d25\uff0c\u7ee7\u7eed\u4e0a\u4f20: {}", (Object)e.getMessage());
        }
    }

    private CommonResponse<List<AttachmentVO>> uploadNewFile(UpLoad upload, String dataUri) {
        ArrayList<String> fileList = new ArrayList<String>();
        fileList.add(dataUri);
        AttachmentRequestVO request = new AttachmentRequestVO();
        request.setBillType(upload.getBillType());
        request.setSourceId(upload.getSourceId());
        request.setSourceType(upload.getSourceType());
        request.setFileList(fileList);
        CommonResponse response = this.attachmentApi.uploadForBase64(request);
        if (response.isSuccess()) {
            logger.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u5355\u636e\u7c7b\u578b: {}, \u6765\u6e90ID: {}, \u6587\u4ef6\u6570\u91cf: {}", new Object[]{upload.getBillType(), upload.getSourceId(), response.getData() != null ? ((List)response.getData()).size() : 0});
        } else {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u5355\u636e\u7c7b\u578b: {}, \u6765\u6e90ID: {}, \u9519\u8bef\u4fe1\u606f: {}", new Object[]{upload.getBillType(), upload.getSourceId(), response.getData()});
        }
        return response;
    }

    private boolean isValidBase64(String base64String) {
        if (StringUtils.isBlank((String)base64String)) {
            return false;
        }
        try {
            Base64.getDecoder().decode(base64String);
            return true;
        }
        catch (IllegalArgumentException e) {
            logger.debug("\u65e0\u6548\u7684base64\u5b57\u7b26\u4e32: {}", (Object)e.getMessage());
            return false;
        }
    }

    private String buildDataUri(String fileName, String base64String) {
        String extension = this.getFileExtension(fileName);
        return "data:application/" + extension + ";base64," + base64String;
    }

    private String getFileExtension(String fileName) {
        if (StringUtils.isBlank((String)fileName)) {
            return "tmp";
        }
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex > 0 && lastDotIndex < fileName.length() - 1) {
            return fileName.substring(lastDotIndex + 1);
        }
        return "docx";
    }

    @PostMapping(value={"/uploadFile2"})
    public void uploadFile2(@RequestBody UpLoad upload) throws IOException {
        logger.info("\u5f00\u59cb\u6d4b\u8bd5\u6587\u4ef6\u4e0a\u4f20");
        try {
            Path path = Paths.get("C:\\Users\\fc\\IdeaProjects\\pageoffice6-springboot2-master\\target\\classes\\static\\doc\\DataTagEdit\\111111.docx", new String[0]);
            byte[] fileBytes = Files.readAllBytes(path);
            String base64String = Base64.getEncoder().encodeToString(fileBytes);
            String dataUri = this.buildDataUri("111111.docx", base64String);
            ArrayList<String> fileList = new ArrayList<String>();
            fileList.add(dataUri);
            AttachmentRequestVO request = new AttachmentRequestVO();
            request.setBillType("BT220216000000003");
            request.setSourceId("1956275048645922818");
            request.setSourceType("subContractFile");
            request.setFileList(fileList);
            CommonResponse deleteResponse = this.attachmentApi.deleteFileByParam(Long.valueOf(1956275048645922818L), "BT220216000000003", "subContractFile");
            logger.info("\u5220\u9664\u54cd\u5e94: {}", (Object)deleteResponse);
            CommonResponse uploadResponse = this.attachmentApi.uploadForBase64(request);
            logger.info("\u4e0a\u4f20\u54cd\u5e94: {}", uploadResponse.getData());
        }
        catch (Exception e) {
            logger.error("\u6d4b\u8bd5\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
        }
    }
}

