/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.controller;

import com.ejianc.entity.TemplateEntity;
import com.ejianc.entity.UpLoad;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.service.ITemplateService;
import feign.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/upload"})
public class UploadFileController {
    private static final Logger logger = LoggerFactory.getLogger(UploadFileController.class);
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ITemplateService templateService;

    @PostMapping(value={"/uploadFile"})
    public CommonResponse<List<AttachmentVO>> uploadFile(@RequestBody UpLoad upload) {
        logger.info("\u5f00\u59cb\u5904\u7406\u6587\u4ef6\u4e0a\u4f20\uff0c\u5355\u636e\u7c7b\u578b: {}, \u6765\u6e90ID: {}", (Object)upload.getBillType(), (Object)upload.getSourceId());
        try {
            if (!this.validateUploadParams(upload)) {
                return CommonResponse.error((String)"\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25");
            }
            String dataUri = this.buildDataUri(upload.getFileName(), upload.getBase64String());
            this.deleteExistingFiles(upload);
            return this.uploadNewFile(upload, dataUri);
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u5355\u636e\u7c7b\u578b: {}, \u6765\u6e90ID: {}", new Object[]{upload.getBillType(), upload.getSourceId(), e});
            return CommonResponse.error((String)("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: " + e.getMessage()));
        }
    }

    private boolean validateUploadParams(UpLoad upload) {
        if (upload == null) {
            logger.error("\u4e0a\u4f20\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((String)upload.getBase64String())) {
            logger.error("base64\u5b57\u7b26\u4e32\u4e3a\u7a7a");
            return false;
        }
        if (StringUtils.isBlank((String)upload.getBillType()) || StringUtils.isBlank((String)upload.getSourceId()) || StringUtils.isBlank((String)upload.getSourceType())) {
            logger.error("\u5fc5\u8981\u53c2\u6570\u7f3a\u5931: billType={}, sourceId={}, sourceType={}", new Object[]{upload.getBillType(), upload.getSourceId(), upload.getSourceType()});
            return false;
        }
        if (!this.isValidBase64(upload.getBase64String())) {
            logger.error("\u65e0\u6548\u7684base64\u5b57\u7b26\u4e32");
            return false;
        }
        return true;
    }

    private void deleteExistingFiles(UpLoad upload) {
        try {
            Long sourceId = Long.valueOf(upload.getSourceId());
            this.attachmentApi.deleteFileByParam(sourceId, upload.getBillType(), upload.getSourceType());
            logger.debug("\u5df2\u5220\u9664\u5df2\u6709\u6587\u4ef6\uff0c\u6765\u6e90ID: {}", (Object)upload.getSourceId());
        }
        catch (NumberFormatException e) {
            logger.warn("\u6765\u6e90ID\u683c\u5f0f\u9519\u8bef\uff0c\u8df3\u8fc7\u5220\u9664\u64cd\u4f5c: {}", (Object)upload.getSourceId());
        }
        catch (Exception e) {
            logger.warn("\u5220\u9664\u5df2\u6709\u6587\u4ef6\u5931\u8d25\uff0c\u7ee7\u7eed\u4e0a\u4f20: {}", (Object)e.getMessage());
        }
    }

    private CommonResponse<List<AttachmentVO>> uploadNewFile(UpLoad upload, String dataUri) {
        ArrayList<String> fileList = new ArrayList<String>();
        fileList.add(dataUri);
        AttachmentRequestVO request = new AttachmentRequestVO();
        request.setBillType(upload.getBillType());
        request.setSourceId(upload.getSourceId());
        request.setSourceType(upload.getSourceType());
        request.setFileList(fileList);
        CommonResponse response = this.attachmentApi.uploadForBase64(request);
        if (response.isSuccess()) {
            logger.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u5355\u636e\u7c7b\u578b: {}, \u6765\u6e90ID: {}, \u6587\u4ef6\u6570\u91cf: {}", new Object[]{upload.getBillType(), upload.getSourceId(), response.getData() != null ? ((List)response.getData()).size() : 0});
        } else {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u5355\u636e\u7c7b\u578b: {}, \u6765\u6e90ID: {}, \u9519\u8bef\u4fe1\u606f: {}", new Object[]{upload.getBillType(), upload.getSourceId(), response.getData()});
        }
        return response;
    }

    private boolean isValidBase64(String base64String) {
        if (StringUtils.isBlank((String)base64String)) {
            return false;
        }
        try {
            Base64.getDecoder().decode(base64String);
            return true;
        }
        catch (IllegalArgumentException e) {
            logger.debug("\u65e0\u6548\u7684base64\u5b57\u7b26\u4e32: {}", (Object)e.getMessage());
            return false;
        }
    }

    private String buildDataUri(String fileName, String base64String) {
        String extension = this.getFileExtension(fileName);
        return "data:application/" + extension + ";base64," + base64String;
    }

    private String getFileExtension(String fileName) {
        if (StringUtils.isBlank((String)fileName)) {
            return "tmp";
        }
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex > 0 && lastDotIndex < fileName.length() - 1) {
            return fileName.substring(lastDotIndex + 1);
        }
        return "docx";
    }

    @PostMapping(value={"/uploadTemplate"})
    @ResponseBody
    public void uploadFileTemplate(@RequestBody UpLoad upload) throws IOException {
        logger.info("\u5f00\u59cb\u5904\u7406\u6a21\u677f\u6587\u4ef6\u4e0a\u4f20\uff0c\u6587\u4ef6ID: {}, \u6a21\u677f\u540d\u79f0: {}", (Object)upload.getFileId(), (Object)upload.getTemplateName());
        try {
            TemplateEntity templateEntity = this.createTemplateEntity(upload);
            this.templateService.save((Object)templateEntity);
            logger.info("\u6a21\u677f\u4fe1\u606f\u4fdd\u5b58\u6210\u529f: {}", (Object)templateEntity.getTemplateName());
            this.uploadFileFromAttachment(upload.getFileId());
        }
        catch (Exception e) {
            logger.error("\u6a21\u677f\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u6587\u4ef6ID: {}", (Object)upload.getFileId(), (Object)e);
            throw new IOException("\u6a21\u677f\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private void uploadFileFromAttachment(String fileId) throws IOException {
        Response response = this.attachmentApi.downloadFileById(Long.valueOf(fileId));
        if (response == null || response.body() == null) {
            throw new IOException("\u65e0\u6cd5\u4e0b\u8f7d\u6587\u4ef6\uff0c\u6587\u4ef6ID: " + fileId);
        }
        CommonResponse attachmentResponse = this.attachmentApi.queryDetail(fileId);
        if (!attachmentResponse.isSuccess() || attachmentResponse.getData() == null) {
            throw new IOException("\u65e0\u6cd5\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\uff0c\u6587\u4ef6ID: " + fileId);
        }
        String fileName = ((AttachmentVO)attachmentResponse.getData()).getFileName();
        if (StringUtils.isBlank((String)fileName)) {
            throw new IOException("\u6587\u4ef6\u540d\u4e3a\u7a7a\uff0c\u6587\u4ef6ID: " + fileId);
        }
        try (InputStream inputStream = response.body().asInputStream();){
            MultipartFile multipartFile = this.createMultipartFile(inputStream, fileName);
            this.callUploadFileInterface(multipartFile);
            logger.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u6587\u4ef6\u540d: {}", (Object)fileName);
        }
    }

    private MultipartFile createMultipartFile(InputStream inputStream, final String fileName) throws IOException {
        final byte[] fileBytes = this.readAllBytes(inputStream);
        return new MultipartFile(){

            public String getName() {
                return "file";
            }

            public String getOriginalFilename() {
                return fileName;
            }

            public String getContentType() {
                return UploadFileController.this.getContentTypeByFileName(fileName);
            }

            public boolean isEmpty() {
                return fileBytes.length == 0;
            }

            public long getSize() {
                return fileBytes.length;
            }

            public byte[] getBytes() throws IOException {
                return fileBytes;
            }

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(fileBytes);
            }

            public void transferTo(File dest) throws IOException, IllegalStateException {
                Files.write(dest.toPath(), fileBytes, new OpenOption[0]);
            }
        };
    }

    private TemplateEntity createTemplateEntity(UpLoad upload) {
        TemplateEntity templateEntity = new TemplateEntity();
        templateEntity.setTemplateName(upload.getTemplateName());
        templateEntity.setCategoryName(upload.getCategoryName());
        templateEntity.setBelongOrgName(upload.getBelongOrgName());
        templateEntity.setFileName(upload.getFileName());
        if (StringUtils.isNotBlank((String)upload.getFileId())) {
            templateEntity.setFileId(Long.valueOf(upload.getFileId()));
        }
        templateEntity.setEnableStatus(1);
        templateEntity.setSequence(1);
        if (StringUtils.isNotBlank((String)upload.getFileName())) {
            String fileType = this.getFileTypeByFileName(upload.getFileName());
            templateEntity.setFileType(fileType);
        }
        logger.info("TemplateEntity\u521b\u5efa\u5b8c\u6210: \u6a21\u677f\u540d\u79f0={}, \u5206\u7c7b\u540d\u79f0={}, \u6240\u5c5e\u7ec4\u7ec7={}, \u6587\u4ef6\u540d={}", new Object[]{templateEntity.getTemplateName(), templateEntity.getCategoryName(), templateEntity.getBelongOrgName(), templateEntity.getFileName()});
        return templateEntity;
    }

    private String getFileTypeByFileName(String fileName) {
        String extension;
        if (StringUtils.isBlank((String)fileName)) {
            return "w";
        }
        switch (extension = this.getFileExtension(fileName).toLowerCase()) {
            case "pdf": {
                return "f";
            }
            case "doc": 
            case "docx": {
                return "w";
            }
            case "xls": 
            case "xlsx": {
                return "s";
            }
            case "ppt": 
            case "pptx": {
                return "p";
            }
        }
        return "w";
    }

    private byte[] readAllBytes(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private String getContentTypeByFileName(String fileName) {
        String extension;
        if (StringUtils.isBlank((String)fileName)) {
            return "application/octet-stream";
        }
        switch (extension = this.getFileExtension(fileName).toLowerCase()) {
            case "pdf": {
                return "application/pdf";
            }
            case "doc": {
                return "application/msword";
            }
            case "docx": {
                return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            }
            case "xls": {
                return "application/vnd.ms-excel";
            }
            case "xlsx": {
                return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
            }
            case "txt": {
                return "text/plain";
            }
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "png": {
                return "image/png";
            }
            case "gif": {
                return "image/gif";
            }
        }
        return "application/octet-stream";
    }

    private void callUploadFileInterface(final MultipartFile multipartFile) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            ByteArrayResource fileResource = new ByteArrayResource(multipartFile.getBytes()){

                public String getFilename() {
                    return multipartFile.getOriginalFilename();
                }
            };
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.add((Object)"file", (Object)fileResource);
            HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
            String uploadUrl = "http://localhost:8081/upload/uploadFile";
            ResponseEntity response = this.restTemplate.exchange(uploadUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                logger.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u54cd\u5e94: {}", response.getBody());
            } else {
                logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u72b6\u6001\u7801: {}, \u54cd\u5e94: {}", (Object)response.getStatusCode(), response.getBody());
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u4e0a\u4f20\u63a5\u53e3\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }
}

