package com.ejianc.util;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;

public class GetDirPathUtil {

    public static String getDirPath()  {

        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource resource = resolver.getResource("classpath*:");
        URI uri = null;
        try {
            uri = resource.getURI();

        if (uri.getScheme().equals("file")) {
            // 开发环境 - 文件系统模式
            File classpathRoot = new File(uri);
            File targetDir = new File(classpathRoot.getParentFile().getParentFile(), "target/classes");
            if (targetDir.exists()) {
                return targetDir.getAbsolutePath();
            }
        } else if (uri.getScheme().equals("jar")) {
            // 生产环境 - JAR包模式
            try (InputStream in = resource.getInputStream()) {
                // 处理JAR包内资源
                Path tempDir = Files.createTempDirectory("jar-resources");
                Path tempFile = tempDir.resolve("temp-resource");
                Files.copy(in, tempFile);
                return tempDir.toString();
            }
        }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

}
