/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.util;

import java.util.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static boolean isValidBase64(String base64String) {
        if (StringUtils.isBlank((String)base64String)) {
            return false;
        }
        try {
            Base64.getDecoder().decode(base64String);
            return true;
        }
        catch (IllegalArgumentException e) {
            logger.debug("\u65e0\u6548\u7684base64\u5b57\u7b26\u4e32: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static String buildDataUri(String fileName, String base64String) {
        String extension = FileUtils.getFileExtension(fileName);
        return "data:application/" + extension + ";base64," + base64String;
    }

    public static String getFileExtension(String fileName) {
        if (StringUtils.isBlank((String)fileName)) {
            return "tmp";
        }
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex > 0 && lastDotIndex < fileName.length() - 1) {
            return fileName.substring(lastDotIndex + 1);
        }
        return "docx";
    }

    public static String getFileTypeByFileName(String fileName) {
        String extension;
        if (StringUtils.isBlank((String)fileName)) {
            return "w";
        }
        switch (extension = FileUtils.getFileExtension(fileName).toLowerCase()) {
            case "pdf": {
                return "f";
            }
            case "doc": 
            case "docx": {
                return "w";
            }
            case "xls": 
            case "xlsx": {
                return "s";
            }
            case "ppt": 
            case "pptx": {
                return "p";
            }
        }
        return "w";
    }

    public static String getContentTypeByFileName(String fileName) {
        String extension;
        if (StringUtils.isBlank((String)fileName)) {
            return "application/octet-stream";
        }
        switch (extension = FileUtils.getFileExtension(fileName).toLowerCase()) {
            case "pdf": {
                return "application/pdf";
            }
            case "doc": {
                return "application/msword";
            }
            case "docx": {
                return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            }
            case "xls": {
                return "application/vnd.ms-excel";
            }
            case "xlsx": {
                return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
            }
            case "txt": {
                return "text/plain";
            }
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "png": {
                return "image/png";
            }
            case "gif": {
                return "image/gif";
            }
        }
        return "application/octet-stream";
    }
}

