package com.ejianc.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * 文件上传配置类
 * 
 * @author: yucaibi
 * @date: 2024
 */
@Configuration
@ConfigurationProperties(prefix = "file.upload")
public class FileUploadConfig {
    
    /**
     * 测试文件路径
     */
    private String testFilePath = "C:\\Users\\fc\\IdeaProjects\\pageoffice6-springboot2-master\\target\\classes\\static\\doc\\DataTagEdit\\456.pdf";
    
    /**
     * 测试单据类型
     */
    private String testBillType = "BT220216000000003";
    
    /**
     * 测试来源ID
     */
    private String testSourceId = "1956275048645922818";
    
    /**
     * 测试来源类型
     */
    private String testSourceType = "subContractFile";
    
    /**
     * 最大文件大小（字节）
     */
    private long maxFileSize = 10 * 1024 * 1024; // 10MB
    
    /**
     * 允许的文件类型
     */
    private String[] allowedFileTypes = {"pdf", "doc", "docx", "xls", "xlsx", "txt", "jpg", "jpeg", "png"};
    
    // Getter and Setter methods
    
    public String getTestFilePath() {
        return testFilePath;
    }
    
    public void setTestFilePath(String testFilePath) {
        this.testFilePath = testFilePath;
    }
    
    public String getTestBillType() {
        return testBillType;
    }
    
    public void setTestBillType(String testBillType) {
        this.testBillType = testBillType;
    }
    
    public String getTestSourceId() {
        return testSourceId;
    }
    
    public void setTestSourceId(String testSourceId) {
        this.testSourceId = testSourceId;
    }
    
    public String getTestSourceType() {
        return testSourceType;
    }
    
    public void setTestSourceType(String testSourceType) {
        this.testSourceType = testSourceType;
    }
    
    public long getMaxFileSize() {
        return maxFileSize;
    }
    
    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }
    
    public String[] getAllowedFileTypes() {
        return allowedFileTypes;
    }
    
    public void setAllowedFileTypes(String[] allowedFileTypes) {
        this.allowedFileTypes = allowedFileTypes;
    }
} 