package com.ejianc.service;

import com.ejianc.entity.UpLoad;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.foundation.file.vo.AttachmentVO;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

/**
 * 文件上传服务接口
 * @author: 系统生成
 * @version: 1
 */
public interface IUploadFileService {

    /**
     * 处理PageOffice文件上传
     * @param upload 上传参数
     * @return 上传结果
     */
    CommonResponse<List<AttachmentVO>> uploadFile(UpLoad upload);

    /**
     * 处理模板文件上传
     * @param upload 上传参数
     * @throws IOException IO异常
     */
    void uploadTemplate(UpLoad upload) throws IOException;

    /**
     * 删除模板文件
     * @param upload 删除参数
     * @throws IOException IO异常
     */
    void deleteTemplate(UpLoad upload) throws IOException;

    /**
     * 从附件服务下载并上传文件
     * @param fileId 文件ID
     * @throws IOException IO异常
     */
    void uploadFileFromAttachment(String fileId,String fileName) throws IOException;

    /**
     * 调用远程上传文件接口
     * @param multipartFile 文件对象
     */
    void callUploadFileInterface(MultipartFile multipartFile);

    /**
     * 调用远程删除文件接口
     * @param upload 删除参数
     */
    void callDeleteFileInterface(UpLoad upload);
} 