/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.controller;

import com.ejianc.business.bean.TaskChangeEntity;
import com.ejianc.business.bean.TaskEntity;
import com.ejianc.business.bean.WorkChangeEntity;
import com.ejianc.business.service.ITaskChangeService;
import com.ejianc.business.service.ITaskService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejinac.business.vo.TaskChangeHisVO;
import com.ejinac.business.vo.TaskChangeVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"taskChange"})
public class TaskChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ITaskChangeService service;
    @Autowired
    private ITaskService taskService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TaskChangeVO> saveOrUpdate(@RequestBody TaskChangeVO saveOrUpdateVO) {
        TaskEntity taskEntity = (TaskEntity)((Object)this.taskService.getById(saveOrUpdateVO.getSourceTaskId()));
        UserContext userContext = this.sessionManager.getUserContext();
        TaskChangeEntity saveEntity = null;
        if (saveOrUpdateVO.getId() == null) {
            saveEntity = (TaskChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TaskChangeEntity.class));
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setChangeUserName(userContext.getUserName());
            saveEntity.setChangeVersion(taskEntity.getChangeVersion() + 1);
            saveEntity.setCode(taskEntity.getCode());
            saveEntity.setOrgName(taskEntity.getOrgName());
            saveEntity.setOrgId(taskEntity.getOrgId());
            saveEntity.setWorkItem(taskEntity.getWorkItem());
            saveEntity.setWorkItemStatus(taskEntity.getWorkItemStatus());
            saveEntity.setWorkOverdue(taskEntity.getWorkOverdue());
            saveEntity.setCloseItem(taskEntity.getCloseItem());
        } else {
            saveEntity = (TaskChangeEntity)((Object)this.service.getById(saveOrUpdateVO.getId()));
            saveEntity.setCode(saveOrUpdateVO.getCode());
            saveEntity.setWorkItemList(BeanMapper.mapList((Iterable)saveOrUpdateVO.getWorkItemList(), WorkChangeEntity.class));
        }
        saveEntity = this.service.saveOrUpdateTaskChange(saveEntity);
        TaskChangeVO vo = (TaskChangeVO)BeanMapper.map((Object)((Object)saveEntity), TaskChangeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TaskChangeVO> queryDetail(Long id) {
        TaskChangeEntity entity = (TaskChangeEntity)((Object)this.service.selectById(id));
        TaskChangeVO vo = (TaskChangeVO)BeanMapper.map((Object)((Object)entity), TaskChangeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TaskChangeHisVO> vos) {
        this.service.deleteChangeTask(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

