/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bean.TaskEntity;
import com.ejianc.business.bean.WorkEntity;
import com.ejianc.business.service.ITaskChangeHisService;
import com.ejianc.business.service.ITaskService;
import com.ejianc.business.service.IWorkAssignService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejinac.business.vo.TaskChangeHisVO;
import com.ejinac.business.vo.TaskVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"task"})
public class TaskController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IWorkAssignService workAssignService;
    private static final String TASK_BILL_CODE = "GDGJ_TASK_CODE";
    private static final String WORK_BILL_CODE = "GDJG_WORK_CODE";
    @Autowired
    private ITaskService service;
    @Autowired
    private ITaskChangeHisService taskChangeHisService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TaskVO> saveOrUpdate(@RequestBody TaskVO saveorUpdateVO) {
        TaskEntity entity = (TaskEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, TaskEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(TASK_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            entity.setWorkItemStatus(0);
            entity.setWorkOverdue(0);
            entity.setCloseItem(0);
            entity.setChangeState(0);
            entity.setChangeVersion(1);
        }
        if (CollectionUtils.isNotEmpty(entity.getWorkItemList())) {
            for (WorkEntity workEntity : entity.getWorkItemList()) {
                int workTtemNum = entity.getWorkItemList().size();
                if (!"del".equals(workEntity.getRowState())) {
                    entity.setWorkItem(workTtemNum);
                    workEntity.setTaskTitle(entity.getTaksTitle());
                    workEntity.setInitiateTime(entity.getInitiateTime());
                    workEntity.setPromoterId(entity.getPromoterId());
                    workEntity.setPromoterName(entity.getPromoterName());
                    workEntity = this.service.saveOrgId(workEntity);
                } else {
                    entity.setWorkItem(workTtemNum--);
                }
                if (!"add".equals(workEntity.getRowState())) continue;
                workEntity.setTaskStatus(0);
                workEntity.setWhetherOverdue(0);
                workEntity.setWorkStatus(0);
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WORK_BILL_CODE, InvocationInfoProxy.getTenantid());
                if (billCode.isSuccess()) {
                    workEntity.setCode((String)billCode.getData());
                    continue;
                }
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        TaskVO vo = (TaskVO)BeanMapper.map((Object)((Object)entity), TaskVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TaskVO> queryDetail(Long id) {
        TaskVO vo = null;
        TaskEntity entity = (TaskEntity)((Object)this.service.selectById(id));
        if (null != entity && TaskVO.TASK_CHANGE_STATE_CHANGED == (vo = (TaskVO)BeanMapper.map((Object)((Object)entity), TaskVO.class)).getChangeState()) {
            List<TaskChangeHisVO> changeHisList = this.loadChangeHisList(vo.getId());
            vo.setTaskChangeHisList(changeHisList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", vo);
    }

    private List<TaskChangeHisVO> loadChangeHisList(Long taskId) {
        List<Object> resp = new ArrayList<TaskChangeHisVO>();
        QueryWrapper hisQuery = new QueryWrapper();
        hisQuery.eq((Object)"source_task_id", (Object)taskId);
        hisQuery.orderByDesc((Object)"create_time");
        List list = this.taskChangeHisService.list((Wrapper)hisQuery);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resp = BeanMapper.mapList((Iterable)list, TaskChangeHisVO.class);
        }
        return resp;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TaskVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TaskVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TaskVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryMyList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TaskVO>> queryMyList(@RequestBody QueryParam queryParam) {
        IPage<TaskEntity> page = this.service.queryMyList(queryParam);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TaskVO.class));
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Task-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refTaskData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TaskVO>> refTaskData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TaskVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateWorkHisOrgIdAndOrgName"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateWorkHisOrgIdAndOrgName() {
        this.service.updateWorkHisOrgIdAndOrgName();
        return CommonResponse.success((String)"\u5b8c\u5584\u5386\u53f2\u6570\u636e\u7ec4\u7ec7\u6210\u529f\uff01");
    }
}

