/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bean.WorkEntity;
import com.ejianc.business.service.IWorkService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejinac.business.vo.WorkAssignVO;
import com.ejinac.business.vo.WorkHistoryVO;
import com.ejinac.business.vo.WorkStateVO;
import com.ejinac.business.vo.WorkVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"work"})
public class WorkController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IWorkService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WorkVO> saveOrUpdate(@RequestBody WorkVO saveorUpdateVO) {
        WorkEntity entity = (WorkEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, WorkEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        WorkVO vo = (WorkVO)BeanMapper.map((Object)((Object)entity), WorkVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WorkVO> queryDetail(Long id) {
        WorkVO mdClassVo = this.service.queryDetail(id);
        return CommonResponse.success((Object)mdClassVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WorkVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("workTitle");
        fuzzyFields.add("taskTitle");
        fuzzyFields.add("responsibleUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = null;
        Long deptId = null;
        if (param.getParams().containsKey("orgId") && ((Parameter)param.getParams().get("orgId")).getValue() != null) {
            orgId = Long.parseLong(((Parameter)param.getParams().get("orgId")).getValue().toString());
        }
        if (param.getParams().containsKey("deptId") && ((Parameter)param.getParams().get("deptId")).getValue() != null) {
            deptId = Long.parseLong(((Parameter)param.getParams().get("deptId")).getValue().toString());
        }
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List<Long> orgIds = null;
        if (deptId == null) {
            orgIds = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        param.getParams().remove("orgId");
        param.getParams().remove("deptId");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<WorkVO> vos = this.service.queryWorkList((Page<WorkVO>)page, wrapper, orgIds, deptId);
        page.setTotal(page.getTotal());
        page.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryMyList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WorkEntity>> queryMyList(@RequestBody QueryParam queryParam) {
        IPage<WorkEntity> pageData = this.service.queryMyList(queryParam);
        return CommonResponse.success(pageData);
    }

    @RequestMapping(value={"/countNumber"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> countNumber(@RequestParam Long userId) {
        return this.service.countNumber(userId);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("workTitle");
        fuzzyFields.add("taskTitle");
        fuzzyFields.add("responsibleUserName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        Long orgId = null;
        Long deptId = null;
        if (param.getParams().containsKey("orgId")) {
            orgId = Long.parseLong(((Parameter)param.getParams().get("orgId")).getValue().toString());
        }
        if (param.getParams().containsKey("deptId")) {
            deptId = Long.parseLong(((Parameter)param.getParams().get("deptId")).getValue().toString());
        }
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        List<Long> orgIds = null;
        if (deptId == null) {
            orgIds = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        param.getParams().remove("orgId");
        param.getParams().remove("deptId");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<WorkVO> vos = this.service.queryWorkList((Page<WorkVO>)page, wrapper, orgIds, deptId);
        page.setTotal(page.getTotal());
        page.setRecords(vos);
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            page.getRecords().forEach(pool -> {
                WorkVO r = (WorkVO)BeanMapper.map((Object)pool, WorkVO.class);
                if (r.getWhetherOverdue().equals("0")) {
                    r.setWhetherOverdueName("\u5426");
                } else {
                    r.setWhetherOverdueName("\u662f");
                }
                voList.add(r);
            });
        }
        String titel = "";
        if (param.getParams().get("taskLevel") != null) {
            if (((Parameter)param.getParams().get("taskLevel")).getValue().equals(2)) {
                titel = "\u90e8\u95e8\u91cd\u70b9\u62a5\u8868";
            } else if (((Parameter)param.getParams().get("taskLevel")).getValue().equals(1)) {
                titel = "\u516c\u53f8\u91cd\u70b9\u62a5\u8868";
            } else if (((Parameter)param.getParams().get("taskLevel")).getValue().equals(3)) {
                titel = "\u9879\u76ee\u91cd\u70b9\u62a5\u8868";
            }
        } else {
            titel = "\u7efc\u5408\u62a5\u8868";
        }
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("titel", titel);
        beans.put("records", voList);
        ExcelExport.getInstance().export("report-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refWorkData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WorkVO>> refWorkData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorkVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/assignTask"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> assignTask(@RequestBody List<WorkAssignVO> workAssignVO) {
        return this.service.assignTask(workAssignVO);
    }

    @RequestMapping(value={"/dealTask"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> dealTask(@RequestBody WorkHistoryVO workHistoryVO) {
        return this.service.dealTask(workHistoryVO);
    }

    @RequestMapping(value={"/closeTask"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> closeTask(@RequestBody WorkHistoryVO workHistoryVO) {
        return this.service.closeTask(workHistoryVO);
    }

    @RequestMapping(value={"/commentTask"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> commentTask(@RequestBody WorkHistoryVO workHistoryVO) {
        return this.service.commentTask(workHistoryVO);
    }

    @RequestMapping(value={"/pollingTask"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> pollingTask() {
        return this.service.pollingTask();
    }

    @RequestMapping(value={"/warningMessage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> warningMessage() {
        return this.service.warningMessage();
    }

    @RequestMapping(value={"/warningSendMessage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> warningSendMessage(Long workId) {
        return this.service.warningSendMessage(workId);
    }

    @RequestMapping(value={"/queryStateStatistics"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WorkStateVO> queryStateStatistics() {
        WorkStateVO vo = this.service.queryStateAll(1);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", (Object)vo);
    }

    @RequestMapping(value={"/queryStateProjectStatistics"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WorkStateVO> queryStateProjectStatistics() {
        WorkStateVO vo = this.service.queryStateAll(3);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", (Object)vo);
    }
}

