/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bean.TaskChangeEntity;
import com.ejianc.business.bean.TaskChangeHisEntity;
import com.ejianc.business.bean.TaskEntity;
import com.ejianc.business.bean.WorkChangeEntity;
import com.ejianc.business.bean.WorkEntity;
import com.ejianc.business.service.ITaskChangeHisService;
import com.ejianc.business.service.ITaskChangeService;
import com.ejianc.business.service.ITaskService;
import com.ejianc.business.service.IWorkChangeService;
import com.ejianc.business.service.IWorkService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejinac.business.vo.TaskVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="taskChange")
public class TaskChangeBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ITaskService taskService;
    @Autowired
    private IWorkService workService;
    @Autowired
    private ITaskChangeService taskChangeService;
    @Autowired
    private IWorkChangeService workChangeService;
    @Autowired
    private ITaskChangeHisService taskChangeHisService;
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        TaskChangeEntity taskChange = (TaskChangeEntity)((Object)this.taskChangeService.getById(billId));
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"pid", (Object)taskChange.getId());
        qw.eq((Object)"dr", (Object)0);
        taskChange.setWorkItemList(this.workChangeService.list((Wrapper)qw));
        TaskEntity newTaskEntity = null;
        TaskEntity oldTask = (TaskEntity)((Object)this.taskService.getById(taskChange.getSourceTaskId()));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"pid", (Object)oldTask.getId());
        wrapper.eq((Object)"dr", (Object)0);
        oldTask.setWorkItemList(this.workService.list((Wrapper)wrapper));
        taskChange.setEffectiveDate(new Date());
        TaskChangeHisEntity recordEntity = (TaskChangeHisEntity)((Object)BeanMapper.map((Object)((Object)oldTask), TaskChangeHisEntity.class));
        this.logger.info("\u4efb\u52a1\u53d8\u66f4\u5ba1\u6279\u6b63\u5728\u56de\u8c03");
        recordEntity.setSourceTaskId(oldTask.getId());
        recordEntity.setId(null);
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getWorkItemList())) {
            recordEntity.getWorkItemList().stream().forEach(detail -> {
                detail.setTargetId(detail.getId());
                detail.setId(null);
            });
        }
        recordEntity.setCreateUserCode(taskChange.getCreateUserCode());
        recordEntity.setCreateTime(taskChange.getCreateTime());
        recordEntity.setUpdateTime(taskChange.getUpdateTime());
        recordEntity.setUpdateUserCode(taskChange.getUpdateUserCode());
        recordEntity.setEffectiveDate(taskChange.getEffectiveDate());
        recordEntity.setOriginalTaskTitle(oldTask.getTaksTitle());
        recordEntity.setTaksTitle(taskChange.getTaksTitle());
        recordEntity.setChangeTaskId(oldTask.getCurChangingTaskId());
        recordEntity.setChangeUserName(taskChange.getChangeUserName());
        recordEntity.setChangeReason(taskChange.getChangeReason());
        this.taskChangeHisService.saveOrUpdate((Object)recordEntity, false);
        this.taskChangeService.saveOrUpdate((Object)taskChange, false);
        newTaskEntity = (TaskEntity)((Object)BeanMapper.map((Object)((Object)taskChange), TaskEntity.class));
        newTaskEntity.setChangeState(TaskVO.TASK_CHANGE_STATE_CHANGED);
        newTaskEntity.setCurChangingTaskId(null);
        newTaskEntity.setCreateUserCode(oldTask.getCreateUserCode());
        newTaskEntity.setCreateTime(oldTask.getCreateTime());
        newTaskEntity.setId(oldTask.getId());
        newTaskEntity.setVersion(oldTask.getVersion());
        newTaskEntity.setChangeVersion(taskChange.getChangeVersion());
        ArrayList<Long> delDetailIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(taskChange.getWorkItemList())) {
            ArrayList<WorkEntity> list = new ArrayList<WorkEntity>();
            WorkEntity tmp = null;
            Map<Long, Integer> map = oldTask.getWorkItemList().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
            for (WorkChangeEntity detail2 : taskChange.getWorkItemList()) {
                tmp = (WorkEntity)((Object)BeanMapper.map((Object)((Object)detail2), WorkEntity.class));
                if (null != detail2.getTargetId()) {
                    tmp.setId(detail2.getTargetId());
                    tmp.setVersion(map.get(detail2.getTargetId()));
                    if ("2".equals(detail2.getChangeType())) {
                        delDetailIds.add(detail2.getTargetId());
                        continue;
                    }
                    tmp.setRowState("update");
                    list.add(tmp);
                    continue;
                }
                tmp.setRowState("add");
                list.add(tmp);
            }
            newTaskEntity.setWorkItemList(list);
        }
        if (CollectionUtils.isNotEmpty(delDetailIds)) {
            this.workService.delByTaskIdAndDetailIds(delDetailIds, oldTask.getId());
        }
        if (this.taskService.saveOrUpdate((Object)newTaskEntity, false)) {
            this.logger.info("\u62f7\u8d1d\u9644\u4ef6\u5230\u4efb\u52a1\u5355\u636e\uff1abillId:" + billId + ", billTypeCode:" + billTypeCode + ", newTaskEntity.getId:" + newTaskEntity.getId());
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "BT202208000004", "notOpenApply", String.valueOf(newTaskEntity.getId()), "BT210926000000003", "notOpenApply");
            this.logger.info("\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u6210\u529f\uff01");
        } else {
            this.logger.info("\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        if (state != BillStateEnum.COMMITED_STATE.getBillStateCode()) {
            CommonResponse.success((String)"\u6709\u5ba1\u6279\u6d41\u7a0b\u7684\u53d8\u66f4\u4efb\u52a1\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u4efb\u52a1\u53d8\u66f4\u5f03\u5ba1\u56de\u8c03\u5904\u7406\uff1abillId: {}, state: {}", (Object)billId, (Object)state);
        TaskChangeEntity taskChange = (TaskChangeEntity)((Object)this.taskChangeService.selectById(billId));
        QueryWrapper hisQuery = new QueryWrapper();
        hisQuery.eq((Object)"change_task_id", (Object)billId);
        TaskChangeHisEntity hisEntity = (TaskChangeHisEntity)((Object)this.taskChangeHisService.getOne((Wrapper)hisQuery));
        if (null != hisEntity) {
            TaskEntity newTaskEntity = null;
            TaskEntity oldTask = (TaskEntity)((Object)this.taskService.selectById(taskChange.getSourceTaskId()));
            this.logger.info("\u4efb\u52a1\u6267\u884c\u5f03\u5ba1\u6570\u636e\u6062\u590d\u903b\u8f91\uff0c\u5f53\u524d\u6570\u636e\u3010{}\u3011\uff0c\u5f85\u6062\u590d\u6570\u636e\u3010{}\u3011", (Object)oldTask, (Object)hisEntity);
            newTaskEntity = (TaskEntity)((Object)BeanMapper.map((Object)((Object)hisEntity), TaskEntity.class));
            newTaskEntity.setCurChangingTaskId(hisEntity.getChangeTaskId());
            newTaskEntity.setCreateUserCode(oldTask.getCreateUserCode());
            newTaskEntity.setCreateTime(oldTask.getCreateTime());
            newTaskEntity.setId(oldTask.getId());
            newTaskEntity.setVersion(oldTask.getVersion());
            newTaskEntity.setChangeVersion(taskChange.getChangeVersion());
            newTaskEntity.setChangeState(TaskVO.TASK_CHANGE_STATE_CHANGING);
            newTaskEntity.setTaksTitle(hisEntity.getOriginalTaskTitle());
            newTaskEntity.setChangeVersion(taskChange.getChangeVersion() - 1);
            ArrayList<Long> delDetailIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(taskChange.getWorkItemList())) {
                ArrayList<WorkEntity> list = new ArrayList<WorkEntity>();
                WorkEntity tmp = null;
                Map<Long, Integer> map = oldTask.getWorkItemList().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
                for (WorkChangeEntity detail : taskChange.getWorkItemList()) {
                    tmp = (WorkEntity)((Object)BeanMapper.map((Object)((Object)detail), WorkEntity.class));
                    if (null != detail.getTargetId()) {
                        tmp.setVersion(map.get(detail.getTargetId()));
                        tmp.setId(detail.getTargetId());
                        if (detail.getChangeType().equals("1")) {
                            delDetailIds.add(detail.getId());
                            continue;
                        }
                        list.add(tmp);
                        continue;
                    }
                    delDetailIds.add(detail.getId());
                }
                newTaskEntity.setWorkItemList(list);
            }
            if (CollectionUtils.isNotEmpty(delDetailIds)) {
                this.workService.delByTaskIdAndDetailIds(delDetailIds, oldTask.getId());
            }
            this.taskChangeHisService.removeById(hisEntity.getId(), false);
            this.taskService.saveOrUpdate((Object)newTaskEntity, false);
        }
        if (this.taskChangeService.saveOrUpdate((Object)taskChange, false)) {
            return CommonResponse.success((String)"\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u6210\u529f\uff01");
        }
        return CommonResponse.success((String)"\u603b\u8ba1\u5212\u53d8\u66f4\u5f03\u5ba1\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }
}

