/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bean.TaskChangeEntity;
import com.ejianc.business.bean.TaskEntity;
import com.ejianc.business.mapper.TaskChangeHisMapper;
import com.ejianc.business.mapper.TaskChangeMapper;
import com.ejianc.business.service.ITaskChangeService;
import com.ejianc.business.service.ITaskService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taskChangeService")
public class TaskChangeServiceImpl
extends BaseServiceImpl<TaskChangeMapper, TaskChangeEntity>
implements ITaskChangeService {
    @Autowired
    private ITaskService taskService;
    @Autowired
    private TaskChangeMapper taskChangeMapper;
    @Autowired
    private TaskChangeHisMapper taskChangeHisMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TaskChangeEntity saveOrUpdateTaskChange(TaskChangeEntity saveEntity) {
        super.saveOrUpdate((Object)saveEntity, false);
        TaskEntity taskEntity = (TaskEntity)((Object)this.taskService.selectById(saveEntity.getSourceTaskId()));
        if (1 != taskEntity.getChangeState()) {
            taskEntity.setChangeState(1);
            taskEntity.setCurChangingTaskId(saveEntity.getId());
            this.taskService.saveOrUpdate((Object)taskEntity, false);
        }
        return saveEntity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteChangeTask(List<Long> changeIds) {
        List changeList = this.taskChangeMapper.selectBatchIds(changeIds);
        List taskIds = changeList.stream().map(TaskChangeEntity::getSourceTaskId).collect(Collectors.toList());
        QueryWrapper taskQuery = new QueryWrapper();
        taskQuery.in((Object)"id", taskIds);
        List taskList = this.taskService.list((Wrapper)taskQuery);
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"ifnull(count(1), 0) as hisNum, source_task_id as taskId"});
        query.in((Object)"source_task_id", taskIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.groupBy((Object[])new String[]{"source_task_id"});
        List queryResult = this.taskChangeHisMapper.selectMaps((Wrapper)query);
        HashMap hisCountNumMap = new HashMap();
        queryResult.stream().forEach(m -> hisCountNumMap.put(Long.valueOf(m.get("taskId").toString()), Integer.valueOf(m.get("hisNum").toString())));
        Iterator iterator = taskList.iterator();
        while (iterator.hasNext()) {
            TaskEntity task;
            task.setChangeState(null != hisCountNumMap.get((task = (TaskEntity)((Object)iterator.next())).getId()) && (Integer)hisCountNumMap.get(task.getId()) > 0 ? 2 : 0);
            task.setCurChangingTaskId(null);
        }
        this.taskService.saveOrUpdateBatch(taskList, taskList.size());
        super.removeByIds((Collection)changeList.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
    }
}

