package com.ejianc.business.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.bean.WorkChangeHisEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 任务变更记录
 * 
 * @author generator
 * 
 */
 @TableName("ejc_task_change_his")
public class TaskChangeHisEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 任务编码
    @TableField(value="taks_title")
    private String taksTitle; // 现任务标题
    @TableField(value="year")
    private String year; // 年
    @TableField(value="promoter_id")
    private Long promoterId; // 发起人
    @TableField(value="promoter_name")
    private String promoterName; // 发起人名称
    @TableField(value="work_item")
    private Integer workItem; // 工作项
    @TableField(value="work_item_status")
    private Integer workItemStatus; // 已完成项
    @TableField(value="work_overdue")
    private Integer workOverdue; // 逾期项
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="initiate_time")
    private Date initiateTime; // 发起时间
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="close_item")
    private Integer closeItem; // 关闭项
    @TableField(value="change_user_name")
    private String changeUserName; // 变更人
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="original_task_title")
    private String originalTaskTitle; // 原任务标题
    @TableField(value="source_task_id")
    private Long sourceTaskId; // 源计划数据Id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_task_id")
    private Long changeTaskId; // 变更任务Id
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="workChangeHisService")//此处有pid="xxx"，默认值pid="pid"
    private List<WorkChangeHisEntity> workItemList = new ArrayList<>(); // 工作变更记录
    

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getTaksTitle() {
        return taksTitle;
    }

    public void setTaksTitle(String taksTitle) {
        this.taksTitle = taksTitle;
    }
    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }
    public Long getPromoterId() {
        return promoterId;
    }

    public void setPromoterId(Long promoterId) {
        this.promoterId = promoterId;
    }
    public String getPromoterName() {
        return promoterName;
    }

    public void setPromoterName(String promoterName) {
        this.promoterName = promoterName;
    }
    public Integer getWorkItem() {
        return workItem;
    }

    public void setWorkItem(Integer workItem) {
        this.workItem = workItem;
    }
    public Integer getWorkItemStatus() {
        return workItemStatus;
    }

    public void setWorkItemStatus(Integer workItemStatus) {
        this.workItemStatus = workItemStatus;
    }
    public Integer getWorkOverdue() {
        return workOverdue;
    }

    public void setWorkOverdue(Integer workOverdue) {
        this.workOverdue = workOverdue;
    }
    public Date getInitiateTime() {
        return initiateTime;
    }

    public void setInitiateTime(Date initiateTime) {
        this.initiateTime = initiateTime;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getCloseItem() {
        return closeItem;
    }

    public void setCloseItem(Integer closeItem) {
        this.closeItem = closeItem;
    }
    public String getChangeUserName() {
        return changeUserName;
    }

    public void setChangeUserName(String changeUserName) {
        this.changeUserName = changeUserName;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public String getOriginalTaskTitle() {
        return originalTaskTitle;
    }

    public void setOriginalTaskTitle(String originalTaskTitle) {
        this.originalTaskTitle = originalTaskTitle;
    }
    public Long getSourceTaskId() {
        return sourceTaskId;
    }

    public void setSourceTaskId(Long sourceTaskId) {
        this.sourceTaskId = sourceTaskId;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getChangeTaskId() {
        return changeTaskId;
    }

    public void setChangeTaskId(Long changeTaskId) {
        this.changeTaskId = changeTaskId;
    }

    public List<WorkChangeHisEntity> getWorkItemList() {
        return workItemList;
    }

    public void setWorkItemList(List<WorkChangeHisEntity> workItemList) {
        this.workItemList = workItemList;
    }
}
