package com.ejianc.business.controller;

import java.io.Serializable;

import com.ejianc.business.bean.TaskEntity;
import com.ejianc.business.bean.WorkChangeEntity;
import com.ejianc.business.service.ITaskService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;

import com.ejinac.business.vo.TaskChangeHisVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bean.TaskChangeEntity;
import com.ejianc.business.service.ITaskChangeService;
import com.ejinac.business.vo.TaskChangeVO;

/**
 * 任务变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("taskChange")
public class TaskChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String WORK_BILL_CODE = "GDJG_WORK_CODE";//此处需要根据实际修改

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ITaskChangeService service;

    @Autowired
    private ITaskService taskService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TaskChangeVO> saveOrUpdate(@RequestBody TaskChangeVO saveOrUpdateVO) {
        TaskEntity taskEntity = taskService.getById(saveOrUpdateVO.getSourceTaskId());
        UserContext userContext = sessionManager.getUserContext();
    	TaskChangeEntity saveEntity = null;
        if(saveOrUpdateVO.getId() == null){
            saveEntity = BeanMapper.map(saveOrUpdateVO, TaskChangeEntity.class);
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            //设置变更人
            saveEntity.setChangeUserName(userContext.getUserName());

            saveEntity.setChangeVersion(taskEntity.getChangeVersion() + 1);
            saveEntity.setCode(taskEntity.getCode());
            saveEntity.setOrgName(taskEntity.getOrgName());
            saveEntity.setOrgId(taskEntity.getOrgId());
            saveEntity.setWorkItem(taskEntity.getWorkItem());
            saveEntity.setWorkItemStatus(taskEntity.getWorkItemStatus());
            saveEntity.setWorkOverdue(taskEntity.getWorkOverdue());
            saveEntity.setCloseItem(taskEntity.getCloseItem());
        }else{
            saveEntity = service.getById(saveOrUpdateVO.getId());
            saveEntity.setCode(saveOrUpdateVO.getCode());
            saveEntity.setWorkItemList(BeanMapper.mapList(saveOrUpdateVO.getWorkItemList(), WorkChangeEntity.class));
        }

        if(CollectionUtils.isNotEmpty(saveEntity.getWorkItemList())){
            for (WorkChangeEntity workEntity : saveEntity.getWorkItemList()) {
                int workTtemNum = saveEntity.getWorkItemList().size();
                if(!"del".equals(workEntity.getRowState())){
                    saveEntity.setWorkItem(workTtemNum);
                    workEntity.setTaskTitle(saveEntity.getTaksTitle());
                    workEntity.setInitiateTime(saveEntity.getInitiateTime());
                    workEntity.setPromoterId(saveEntity.getPromoterId());
                    workEntity.setPromoterName(saveEntity.getPromoterName());
                    //保存组织
                    workEntity = service.saveOrgId(workEntity);
                }else{
                    saveEntity.setWorkItem(workTtemNum--);
                }

                if("add".equals(workEntity.getRowState())){
                    workEntity.setTaskStatus(0);
                    workEntity.setWhetherOverdue(0);
                    workEntity.setWorkStatus(0);
                    CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WORK_BILL_CODE, InvocationInfoProxy.getTenantid());
                    if(billCode.isSuccess()) {
                        workEntity.setCode(billCode.getData());
                    }else{
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                }

            }
        }

        saveEntity = service.saveOrUpdateTaskChange(saveEntity);

    	TaskChangeVO vo = BeanMapper.map(saveEntity, TaskChangeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TaskChangeVO> queryDetail(Long id) {
    	TaskChangeEntity entity = service.selectById(id);
    	TaskChangeVO vo = BeanMapper.map(entity, TaskChangeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TaskChangeHisVO> vos) {
        service.deleteChangeTask(vos.stream().map(TaskChangeHisVO::getId).collect(Collectors.toList()));
        return CommonResponse.success("删除成功！");
    }

}
