package com.ejianc.business.controller;

import java.io.Serializable;

import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejinac.business.vo.TaskChangeHisVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.kit.mapper.BeanMapper;

import com.ejianc.framework.auth.session.SessionManager;

import com.ejianc.business.bean.TaskChangeHisEntity;
import com.ejianc.business.service.ITaskChangeHisService;

/**
 * 任务变更记录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("taskChangeHis")
public class TaskChangeHisController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ITaskChangeHisService service;

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TaskChangeHisVO> queryDetail(Long id) {
    	TaskChangeHisEntity entity = service.selectById(id);
    	TaskChangeHisVO vo = BeanMapper.map(entity, TaskChangeHisVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

}
