package com.ejianc.business.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bean.WorkEntity;
import com.ejianc.business.service.IWorkService;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.mapper.TaskMapper;
import com.ejianc.business.bean.TaskEntity;
import com.ejianc.business.service.ITaskService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 任务
 * 
 * @author generator
 * 
 */
@Service("taskService")
public class TaskServiceImpl extends BaseServiceImpl<TaskMapper, TaskEntity> implements ITaskService{

    @Autowired
    private IWorkService workService;
    @Autowired
    private TaskMapper taskMapper;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IEmployeeApi iEmployeeApi;

    /**
     * 自定义分页查询
     * @param queryParam
     * @return
     */
    @Override
    public IPage<TaskEntity> queryMyList(QueryParam queryParam) {
        IPage<TaskEntity> page = new Page<TaskEntity>();
        Map<String, Object> param = new HashMap<>();
        param.put("pageIndex", queryParam.getPageIndex());
        param.put("pageSize", queryParam.getPageSize());
        if (queryParam.getParams().get("workItemStr") != null){
            if(queryParam.getParams().get("workItemStr").getValue().equals("1")){
                param.put("workItemStr", "1");
            }else if(queryParam.getParams().get("workItemStr").getValue().equals("0")){
                param.put("workItemStr", "0");
            }
        }
        if (queryParam.getParams().get("workOverdue") != null){
            if(queryParam.getParams().get("workOverdue").getValue().equals("1")){
                param.put("workOverdue", "1");
            }else if(queryParam.getParams().get("workOverdue").getValue().equals("0")){
                param.put("workOverdue", "0");
            }
        }
        if (queryParam.getOrderMap().get("createTime") != null){
            param.put("createTime", queryParam.getOrderMap().get("createTime"));
        }
        if(param.get("pageIndex")!=null){
            Integer pn = queryParam.getPageIndex() - 1 < 0 ? 1 : queryParam.getPageIndex();
            long startLine = (pn - 1) * queryParam.getPageSize();
            param.put("startLine", startLine);
        }
        if(StringUtils.isNotBlank(queryParam.getSearchText())){
            param.put("searchText", queryParam.getSearchText());
        }
        Map<String, Parameter> params = queryParam.getParams();

        /** 数据隔离 本下 */
        param.put("orgIds",iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        param.put("userId", InvocationInfoProxy.getUserid());
        param.put("tenantId",InvocationInfoProxy.getTenantid());
        Integer count = taskMapper.countNumber(param);
        if(count>0){
            List<TaskEntity> appEntity = taskMapper.queryMyList(param);
            page.setRecords(appEntity);
        }else{
            page.setRecords(new ArrayList<>());
        }
        if(param.get("pageIndex")!=null){
            page.setCurrent(Integer.parseInt(param.get("pageIndex").toString()));
            page.setSize(Integer.parseInt(param.get("pageSize").toString()));
            page.setTotal(count);
        }
        return page;
    }

    /**
     * 保存工作的orgId
     * @param workEntity
     * @return
     */
    @Override
    public WorkEntity saveOrgId(WorkEntity workEntity) {
        //如果组织为空
        if(workEntity.getOrgId()==null){
            //部门不为空
            if(StringUtils.isNotBlank(workEntity.getResponsibleDepId())){
                List<Long> orgIds = new ArrayList<>();
                List<String> orgIdStr = new ArrayList<>();
                List<String> orgNames = new ArrayList<>();
                String[] split = workEntity.getResponsibleDepId().split(",");
                //根据部门id查询部门
                for (String s : split) {
                    CommonResponse<DeptVO> deptById = iOrgApi.findDeptById(Long.valueOf(s));
                    if(deptById.isSuccess()){
                        orgIdStr.add(String.valueOf(deptById.getData().getOrgId()));
                        //获取部门中的组织id
                        orgIds.add(deptById.getData().getOrgId());
                    }
                }
                //根据组织id查询组织名称
                for (Long orgId : orgIds) {
                    CommonResponse<OrgVO> oneById = iOrgApi.getOneById(orgId);
                    if(oneById.isSuccess()){
                        orgNames.add(oneById.getData().getName());
                    }
                }
                if(CollectionUtils.isNotEmpty(orgIdStr)){
                    orgIdStr = orgIdStr.stream().distinct().collect(Collectors.toList());
                    workEntity.setOrgId(StringUtils.join(orgIdStr.toArray(),","));
                }
                if(CollectionUtils.isNotEmpty(orgNames)){
                    orgNames = orgNames.stream().distinct().collect(Collectors.toList());
                    workEntity.setOrgName(StringUtils.join(orgNames.toArray(), ","));
                }
            }else{
                //部门为空，根据责任人查
                List<String> orgIds = new ArrayList<>();
                List<String> orgNames = new ArrayList<>();
                String[] split = workEntity.getResponsibleUserId().split(",");
                //查询责任人的组织id 组织名称
                for (String s : split) {
                    CommonResponse<List<Long>> response = iEmployeeApi.getJobOrgIdsByUserId(Long.valueOf(s), InvocationInfoProxy.getTenantid());
                    if(response.isSuccess()){
                        List<Long> data = response.getData();
                        for (Long orgId : data) {
                            orgIds.add(String.valueOf(orgId));
                            CommonResponse<OrgVO> oneById = iOrgApi.getOneById(orgId);
                            if(oneById.isSuccess()){
                                orgNames.add(oneById.getData().getName());
                            }
                        }
                    }
                }
                if(CollectionUtils.isNotEmpty(orgIds)){
                    orgIds = orgIds.stream().distinct().collect(Collectors.toList());
                    workEntity.setOrgId(StringUtils.join(orgIds.toArray(),","));
                }
                if(CollectionUtils.isNotEmpty(orgNames)){
                    orgNames = orgNames.stream().distinct().collect(Collectors.toList());
                    workEntity.setOrgName(StringUtils.join(orgNames.toArray(), ","));
                }
            }
        }
        return workEntity;
    }

    /**
     * 修改历史数据中orgId为空的工作项
     * @return
     */
    @Override
    public void updateWorkHisOrgIdAndOrgName() {
        QueryWrapper<WorkEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr",0);
        List<WorkEntity> list = workService.list(wrapper);
        for (WorkEntity entity : list) {
            saveOrgId(entity);
            LambdaUpdateWrapper<WorkEntity> updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(WorkEntity::getId,entity.getId());
            updateWrapper.set(WorkEntity::getOrgId,entity.getOrgId());
            updateWrapper.set(WorkEntity::getOrgName,entity.getOrgName());
            System.out.println("--------id="+entity.getId()+",-----------orgId="+entity.getOrgId()+"-------------,orgName="+entity.getOrgName());
            workService.update(updateWrapper);
        }
    }
}
