package com.ejianc.business.guarantee.enums;


import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 担保合同状态
 *
 * @author Jiang
 * @Description:
 * @date 2023年3月30日11:01:11
 */
public enum ContractStatuesEnum {
    评审中(0, "评审中"),
    在保(1, "在保"),
    续保(2, "续保"),
    在保续保中(3,"在保-续保中"),
    解保(4, "解保"),
    代偿(5, "代偿"),
    已结束(6, "已结束"),


    追偿中(7, "追偿中"),
    已追偿(8, "已追偿"),
    已过期(9,"已过期");


    private Integer code;
    private String description;
    private static Map<Integer, ContractStatuesEnum> enumMap = new HashMap<>();

    ContractStatuesEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(ContractStatuesEnum.class).stream().collect(Collectors.toMap(ContractStatuesEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static ContractStatuesEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }

    }
