package com.ejianc.business.guarantee.contract.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 投标担保
 *
 * @author generator
 */
public class ContractBidVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String billStateName;
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long contractId; // 合同评审id
    private String contractName; // 合同名称
    private String projectId; // 项目
    private String projectName; // 项目名称
    private String selfCode; // 自定义编号
    private String applyArea; // 申请地区
    private String applyAreaName; // 申请地区名称
    private Long employeeId; // 委托保证人
    private String employeeName; // 委托保证人名称
    private Long applicant; // 申请人
    private String applicantName; // 申请名称
    private Long projectType; // 项目类型
    private String projectTypeName; // 项目类型名称
    private BigDecimal baseTaxMny; // 初始担保金额（含税）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date serviceDate; // 业务日期
    private BigDecimal basePremiumTaxMny; // 初始保费金额(含税)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date guaranteeEffectDate; // 担保生效期
    private String bidPersonName; // 招标人
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date letterDate; //出函时间

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    @ReferSerialTransfer(referCode = "ref-guarantee-contract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getSelfCode() {
        return selfCode;
    }

    public void setSelfCode(String selfCode) {
        this.selfCode = selfCode;
    }

    public String getApplyArea() {
        return applyArea;
    }

    public void setApplyArea(String applyArea) {
        this.applyArea = applyArea;
    }

    public String getApplyAreaName() {
        return applyAreaName;
    }

    public void setApplyAreaName(String applyAreaName) {
        this.applyAreaName = applyAreaName;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getApplicant() {
        return applicant;
    }

    public void setApplicant(Long applicant) {
        this.applicant = applicant;
    }

    public String getApplicantName() {
        return applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public Long getProjectType() {
        return projectType;
    }

    public void setProjectType(Long projectType) {
        this.projectType = projectType;
    }

    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }

    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }

    public Date getServiceDate() {
        return serviceDate;
    }

    public void setServiceDate(Date serviceDate) {
        this.serviceDate = serviceDate;
    }

    public BigDecimal getBasePremiumTaxMny() {
        return basePremiumTaxMny;
    }

    public void setBasePremiumTaxMny(BigDecimal basePremiumTaxMny) {
        this.basePremiumTaxMny = basePremiumTaxMny;
    }

    public Date getGuaranteeEffectDate() {
        return guaranteeEffectDate;
    }

    public void setGuaranteeEffectDate(Date guaranteeEffectDate) {
        this.guaranteeEffectDate = guaranteeEffectDate;
    }

    public String getBidPersonName() {
        return bidPersonName;
    }

    public void setBidPersonName(String bidPersonName) {
        this.bidPersonName = bidPersonName;
    }

    public Date getLetterDate() {
        return letterDate;
    }

    public void setLetterDate(Date letterDate) {
        this.letterDate = letterDate;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBillStateName() {
        if (this.billState != null) {

            switch (this.billState) {
                case 0:
                    billStateName = "自由态";
                    break;
                case 1:
                    billStateName = "已提交";
                    break;
                case 2:
                case 5:
                    billStateName = "审批中";
                    break;
                case 3:
                    billStateName = "审批通过";
                    break;
                case 4:
                    billStateName = "审批驳回";
                    break;
                default:
                    billStateName = null;
                    break;
            }
        }
        return billStateName;
    }
}
