package com.ejianc.business.guarantee.contract.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.guarantee.contract.vo.ContractDetailVO;
import com.ejianc.business.guarantee.contract.vo.ContractInfoVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 担保合同评审
 *
 * @author generator
 */
public class ContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 合同编号
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private String contractName; // 合同名称
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String applyArea; // 申请地区
    private String applyAreaName; // 申请地区名称
    private Long employeeId; // 委托保证人
    private String employeeName; // 委托保证人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 竣工日期
    private String duration; // 工期
    private BigDecimal contractMny; // 合同造价(无税)
    private BigDecimal contractTaxMny; // 合同造价(含税)
    private Long owner; // 业主
    private String ownerName; // 业主名称
    private Long contractorId; // 承包商
    private String contractorName; // 承包商名称
    private Long projectType; // 项目类型
    private String projectTypeName; // 项目类型名称
    private Integer constructProcedure; // 开发施工手续（1：齐全 2：不齐全）
    private Long sourceFunds; // 资金来源
    private String sourceFundsName; // 资金来源名称
    private Long applicant; // 申请人
    private String applicantName; // 申请名称
    private BigDecimal registerMny; // 注册资金
    private Integer litigationCases; // 诉讼案件（1：较多 2：较少 3：无）
    private Long legalPerson; // 法定代表人
    private String legalPersonName; // 法定代表人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date establishDate; // 成立时间
    private String qualityLevelName; // 资质等级
    private Long client; // 委托人
    private String clientName; // 委托人名称
    private String clientPhone; // 联系电话
    private Long litigationAddress; // 诉讼地
    private String litigationAddressName; // 诉讼地名称
    private Long guaranteeType; // 担保类型
    private String guaranteeTypeName; // 担保类型名称
    private Long ensureDuty; // 保证责任
    private String ensureDutyName; // 保证责任名称
    private String projectAddress; // 项目地址
    private String projectAddressName; // 项目地址名称
    private String projectProvince; // 项目省
    private String projectCity; // 项目市
    private String projectRegion; // 项目区县
    private String projectRegionCode; // 项目区县编码
    private BigDecimal baseMny; // 初始担保金额
    private BigDecimal baseTaxMny; // 初始担保金额（含税）
    private BigDecimal beforeChangeMny; // 变更前担保金额
    private BigDecimal beforeChangeTaxMny; // 变更前担保金额（含税）
    private BigDecimal changingMny; // 变更中担保金额
    private BigDecimal changingTaxMny; // 变更中担保金额（含税）
    private BigDecimal basePremiumMny; // 初始保费金额
    private BigDecimal basePremiumTaxMny; // 初始保费金额(含税)
    private BigDecimal basePremiumTaxRate; // 初始保费税率
    private BigDecimal guaranteeReturnTaxMny; // 现金反担保金额（类似押金）
    private Long changeId; // 变更主键
    private BigDecimal beforePremiumMny; // 变更前保费金额
    private BigDecimal beforePremiumTaxMny; // 变更前保费金额(含税)
    private BigDecimal changingPremiumMny; // 变更中保费金额
    private BigDecimal changingPremiumTaxMny; // 变更中保费金额(含税)
    private String changeCode; // 变更单号
    private Integer changeVersion; // 变更版本
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate; // 变更日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date guaranteeEffectDate; // 担保生效期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date guaranteeTermStartDate; // 担保收费开始日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date guaranteeTermEndDate; // 担保收费结束日期
    private Long guaranteeMode; // 担保方式
    private String guaranteeModeName; // 担保方式名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    private Long oldReviewId; // 原评审编号
    private String selfCode; // 自定义编号
    private Integer contractStatus;//合同状态(1-在保 2-续保 3-解保 4-代偿 5-结束)
    private Integer recoveryStatus;//追偿状态(1-追偿中 2-已追偿)
    private Integer abandonStatus;//废弃状态(1-正常 2-已废弃)
    private Integer renewalStatus;//续保状态(1-续保中 2-已续保)
    private Integer financeStatus;//财务确认状态(0-未到账 1-已全部到账 2-未完全到账)
    private BigDecimal guaranteeTaxMny; // 担保金额
    private BigDecimal guaranteeMnyPer; // 担保额比例
    private BigDecimal returnTaxBond; // 反担保保证金
    private BigDecimal bondPer; //保证金比例
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date renewalDate; //续保日期
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date letterDate; //出函时间
    private String benefitPersonName;//受益人
    private Long followId;//跟踪id
    private String followStatus;//跟踪状态
    private String importFlag;//重点标识(1-是 2-否)
    private Long contractCategoryId;
    private String contractCategoryName;//合同类别名称
    private String guaranteePeriod;//担保期限(1-敞口 2-闭口)
    /**
     * 字段翻译
     */
    private String billStateName;
    private String contractStatusName;
    private String renewalStatusName;
    private String recoveryStatusName;
    private String changeStatusName;
    /**
     * 拼接字段
     */
    private String isOnlineName;//是否上网
    private BigDecimal renewalPremiumTaxMny;//续保保费金额（含税）
    private BigDecimal relievePremiumTaxMny;//保费金额(逾期保费)（含税）
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date renewalApproveDate; //续保审批通过时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date relieveApproveDate; //解保审批通过时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date projectApproveDate; //项目评审审批通过时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date projectCreateDate; //项目评审创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date approveDate; //审批通过时间

    private List<ContractDetailVO> contractDetailList = new ArrayList<>(); // 联合保证详情子表
    private List<ContractInfoVO> contractInfoList = new ArrayList<>(); // 个人信用反担保信息子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode = "ref-guarantee-projectReview2")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getApplyArea() {
        return applyArea;
    }

    public void setApplyArea(String applyArea) {
        this.applyArea = applyArea;
    }

    public String getApplyAreaName() {
        return applyAreaName;
    }

    public void setApplyAreaName(String applyAreaName) {
        this.applyAreaName = applyAreaName;
    }

    @ReferSerialTransfer(referCode = "ref-guarantee-supplier")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getDuration() {
        return duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public Long getOwner() {
        return owner;
    }

    public void setOwner(Long owner) {
        this.owner = owner;
    }

    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public Long getContractorId() {
        return contractorId;
    }

    public void setContractorId(Long contractorId) {
        this.contractorId = contractorId;
    }

    public String getContractorName() {
        return contractorName;
    }

    public void setContractorName(String contractorName) {
        this.contractorName = contractorName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProjectType() {
        return projectType;
    }

    @ReferDeserialTransfer
    public void setProjectType(Long projectType) {
        this.projectType = projectType;
    }

    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }

    public Integer getConstructProcedure() {
        return constructProcedure;
    }

    public void setConstructProcedure(Integer constructProcedure) {
        this.constructProcedure = constructProcedure;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getSourceFunds() {
        return sourceFunds;
    }

    @ReferDeserialTransfer
    public void setSourceFunds(Long sourceFunds) {
        this.sourceFunds = sourceFunds;
    }

    public String getSourceFundsName() {
        return sourceFundsName;
    }

    public void setSourceFundsName(String sourceFundsName) {
        this.sourceFundsName = sourceFundsName;
    }

    public Long getApplicant() {
        return applicant;
    }

    public void setApplicant(Long applicant) {
        this.applicant = applicant;
    }

    public String getApplicantName() {
        return applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public BigDecimal getRegisterMny() {
        return registerMny;
    }

    public void setRegisterMny(BigDecimal registerMny) {
        this.registerMny = registerMny;
    }

    public Integer getLitigationCases() {
        return litigationCases;
    }

    public void setLitigationCases(Integer litigationCases) {
        this.litigationCases = litigationCases;
    }

    public Long getLegalPerson() {
        return legalPerson;
    }

    public void setLegalPerson(Long legalPerson) {
        this.legalPerson = legalPerson;
    }

    public String getLegalPersonName() {
        return legalPersonName;
    }

    public void setLegalPersonName(String legalPersonName) {
        this.legalPersonName = legalPersonName;
    }

    public Date getEstablishDate() {
        return establishDate;
    }

    public void setEstablishDate(Date establishDate) {
        this.establishDate = establishDate;
    }

    public String getQualityLevelName() {
        return qualityLevelName;
    }

    public void setQualityLevelName(String qualityLevelName) {
        this.qualityLevelName = qualityLevelName;
    }

    public Long getClient() {
        return client;
    }

    public void setClient(Long client) {
        this.client = client;
    }

    public String getClientName() {
        return clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getClientPhone() {
        return clientPhone;
    }

    public void setClientPhone(String clientPhone) {
        this.clientPhone = clientPhone;
    }

    public String getLitigationAddressName() {
        return litigationAddressName;
    }

    public void setLitigationAddressName(String litigationAddressName) {
        this.litigationAddressName = litigationAddressName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getGuaranteeType() {
        return guaranteeType;
    }

    @ReferDeserialTransfer
    public void setGuaranteeType(Long guaranteeType) {
        this.guaranteeType = guaranteeType;
    }

    public String getGuaranteeTypeName() {
        return guaranteeTypeName;
    }

    public void setGuaranteeTypeName(String guaranteeTypeName) {
        this.guaranteeTypeName = guaranteeTypeName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEnsureDuty() {
        return ensureDuty;
    }

    @ReferDeserialTransfer
    public void setEnsureDuty(Long ensureDuty) {
        this.ensureDuty = ensureDuty;
    }

    public String getEnsureDutyName() {
        return ensureDutyName;
    }

    public void setEnsureDutyName(String ensureDutyName) {
        this.ensureDutyName = ensureDutyName;
    }

    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }

    public String getProjectAddressName() {
        return projectAddressName;
    }

    public void setProjectAddressName(String projectAddressName) {
        this.projectAddressName = projectAddressName;
    }

    public String getProjectProvince() {
        return projectProvince;
    }

    public void setProjectProvince(String projectProvince) {
        this.projectProvince = projectProvince;
    }

    public String getProjectCity() {
        return projectCity;
    }

    public void setProjectCity(String projectCity) {
        this.projectCity = projectCity;
    }

    public String getProjectRegion() {
        return projectRegion;
    }

    public void setProjectRegion(String projectRegion) {
        this.projectRegion = projectRegion;
    }

    public String getProjectRegionCode() {
        return projectRegionCode;
    }

    public void setProjectRegionCode(String projectRegionCode) {
        this.projectRegionCode = projectRegionCode;
    }

    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }

    public BigDecimal getBaseTaxMny() {
        return baseTaxMny;
    }

    public void setBaseTaxMny(BigDecimal baseTaxMny) {
        this.baseTaxMny = baseTaxMny;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }

    public BigDecimal getBasePremiumMny() {
        return basePremiumMny;
    }

    public void setBasePremiumMny(BigDecimal basePremiumMny) {
        this.basePremiumMny = basePremiumMny;
    }

    public BigDecimal getBasePremiumTaxMny() {
        return basePremiumTaxMny;
    }

    public void setBasePremiumTaxMny(BigDecimal basePremiumTaxMny) {
        this.basePremiumTaxMny = basePremiumTaxMny;
    }

    public BigDecimal getBasePremiumTaxRate() {
        return basePremiumTaxRate;
    }

    public void setBasePremiumTaxRate(BigDecimal basePremiumTaxRate) {
        this.basePremiumTaxRate = basePremiumTaxRate;
    }

    public BigDecimal getGuaranteeReturnTaxMny() {
        return guaranteeReturnTaxMny;
    }

    public void setGuaranteeReturnTaxMny(BigDecimal guaranteeReturnTaxMny) {
        this.guaranteeReturnTaxMny = guaranteeReturnTaxMny;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public BigDecimal getBeforePremiumMny() {
        return beforePremiumMny;
    }

    public void setBeforePremiumMny(BigDecimal beforePremiumMny) {
        this.beforePremiumMny = beforePremiumMny;
    }

    public BigDecimal getBeforePremiumTaxMny() {
        return beforePremiumTaxMny;
    }

    public void setBeforePremiumTaxMny(BigDecimal beforePremiumTaxMny) {
        this.beforePremiumTaxMny = beforePremiumTaxMny;
    }

    public BigDecimal getChangingPremiumMny() {
        return changingPremiumMny;
    }

    public void setChangingPremiumMny(BigDecimal changingPremiumMny) {
        this.changingPremiumMny = changingPremiumMny;
    }

    public BigDecimal getChangingPremiumTaxMny() {
        return changingPremiumTaxMny;
    }

    public void setChangingPremiumTaxMny(BigDecimal changingPremiumTaxMny) {
        this.changingPremiumTaxMny = changingPremiumTaxMny;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public Date getGuaranteeEffectDate() {
        return guaranteeEffectDate;
    }

    public void setGuaranteeEffectDate(Date guaranteeEffectDate) {
        this.guaranteeEffectDate = guaranteeEffectDate;
    }

    public Date getGuaranteeTermStartDate() {
        return guaranteeTermStartDate;
    }

    public void setGuaranteeTermStartDate(Date guaranteeTermStartDate) {
        this.guaranteeTermStartDate = guaranteeTermStartDate;
    }

    public Date getGuaranteeTermEndDate() {
        return guaranteeTermEndDate;
    }

    public void setGuaranteeTermEndDate(Date guaranteeTermEndDate) {
        this.guaranteeTermEndDate = guaranteeTermEndDate;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")

    public Long getGuaranteeMode() {
        return guaranteeMode;
    }

    @ReferDeserialTransfer
    public void setGuaranteeMode(Long guaranteeMode) {
        this.guaranteeMode = guaranteeMode;
    }

    public String getGuaranteeModeName() {
        return guaranteeModeName;
    }

    public void setGuaranteeModeName(String guaranteeModeName) {
        this.guaranteeModeName = guaranteeModeName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getLitigationAddress() {
        return litigationAddress;
    }

    @ReferDeserialTransfer
    public void setLitigationAddress(Long litigationAddress) {
        this.litigationAddress = litigationAddress;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    @ReferSerialTransfer(referCode = "ref-guarantee-contract")
    public Long getOldReviewId() {
        return oldReviewId;
    }

    @ReferDeserialTransfer
    public void setOldReviewId(Long oldReviewId) {
        this.oldReviewId = oldReviewId;
    }

    public String getSelfCode() {
        return selfCode;
    }

    public void setSelfCode(String selfCode) {
        this.selfCode = selfCode;
    }

    public Integer getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }

    public Integer getRecoveryStatus() {
        return recoveryStatus;
    }

    public void setRecoveryStatus(Integer recoveryStatus) {
        this.recoveryStatus = recoveryStatus;
    }

    public Integer getAbandonStatus() {
        return abandonStatus;
    }

    public void setAbandonStatus(Integer abandonStatus) {
        this.abandonStatus = abandonStatus;
    }

    public Integer getRenewalStatus() {
        return renewalStatus;
    }

    public void setRenewalStatus(Integer renewalStatus) {
        this.renewalStatus = renewalStatus;
    }

    public List<ContractDetailVO> getContractDetailList() {
        return contractDetailList;
    }

    public void setContractDetailList(List<ContractDetailVO> contractDetailList) {
        this.contractDetailList = contractDetailList;
    }

    public List<ContractInfoVO> getContractInfoList() {
        return contractInfoList;
    }

    public void setContractInfoList(List<ContractInfoVO> contractInfoList) {
        this.contractInfoList = contractInfoList;
    }

    public Integer getFinanceStatus() {
        return financeStatus;
    }

    public void setFinanceStatus(Integer financeStatus) {
        this.financeStatus = financeStatus;
    }

    public BigDecimal getGuaranteeTaxMny() {
        return guaranteeTaxMny;
    }

    public void setGuaranteeTaxMny(BigDecimal guaranteeTaxMny) {
        this.guaranteeTaxMny = guaranteeTaxMny;
    }

    public BigDecimal getGuaranteeMnyPer() {
        return guaranteeMnyPer;
    }

    public void setGuaranteeMnyPer(BigDecimal guaranteeMnyPer) {
        this.guaranteeMnyPer = guaranteeMnyPer;
    }

    public BigDecimal getReturnTaxBond() {
        return returnTaxBond;
    }

    public void setReturnTaxBond(BigDecimal returnTaxBond) {
        this.returnTaxBond = returnTaxBond;
    }

    public BigDecimal getBondPer() {
        return bondPer;
    }

    public void setBondPer(BigDecimal bondPer) {
        this.bondPer = bondPer;
    }

    public Date getRenewalDate() {
        return renewalDate;
    }

    public void setRenewalDate(Date renewalDate) {
        this.renewalDate = renewalDate;
    }

    public Date getLetterDate() {
        return letterDate;
    }

    public void setLetterDate(Date letterDate) {
        this.letterDate = letterDate;
    }

    public String getBillStateName() {
        if (this.billState != null) {

            switch (this.billState) {
                case 0:
                    billStateName = "自由态";
                    break;
                case 1:
                    billStateName = "已提交";
                    break;
                case 2:
                case 5:
                    billStateName = "审批中";
                    break;
                case 3:
                    billStateName = "审批通过";
                    break;
                case 4:
                    billStateName = "审批驳回";
                    break;
                default:
                    billStateName = null;
                    break;
            }
        }
        return billStateName;
    }

    public String getContractStatusName() {
        if (this.contractStatus != null) {
            switch (this.contractStatus) {
                case 0:
                    contractStatusName = "签订中";
                    break;
                case 1:
                    contractStatusName = "在保";
                    break;
                case 2:
                    contractStatusName = "续保";
                    break;
                case 3:
                    contractStatusName = "已结束";
                    break;
                case 4:
                    contractStatusName = "已关闭";
                    break;
                case 5:
                    contractStatusName = "已过期";
                    break;
                default:
                    contractStatusName = null;
                    break;
            }
        }
        return contractStatusName;
    }

    public String getRenewalStatusName() {
        if (this.renewalStatus != null) {

            switch (this.renewalStatus) {
                case 1:
                    renewalStatusName = "续保中";
                    break;
                case 2:
                    renewalStatusName = "已续保";
                    break;
                default:
                    renewalStatusName = null;
                    break;
            }
        }
        return renewalStatusName;
    }

    public String getRecoveryStatusName() {
        if (this.recoveryStatus != null) {
            switch (this.recoveryStatus) {
                case 1:
                    recoveryStatusName = "追偿中";
                    break;
                case 2:
                    recoveryStatusName = "已追偿";
                    break;
                default:
                    recoveryStatusName = null;
                    break;
            }
        }

        return recoveryStatusName;
    }

    public String getChangeStatusName() {
        if (this.changeStatus != null) {
            switch (this.changeStatus) {
                case 0:
                    changeStatusName = "未变更";
                    break;
                case 1:
                    changeStatusName = "变更中";
                    break;
                case 2:
                    changeStatusName = "已变更";
                    break;
                default:
                    changeStatusName = null;
                    break;
            }
        }
        return changeStatusName;
    }

    public String getBenefitPersonName() {
        return benefitPersonName;
    }

    public void setBenefitPersonName(String benefitPersonName) {
        this.benefitPersonName = benefitPersonName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public void setContractStatusName(String contractStatusName) {
        this.contractStatusName = contractStatusName;
    }

    public void setRenewalStatusName(String renewalStatusName) {
        this.renewalStatusName = renewalStatusName;
    }

    public void setRecoveryStatusName(String recoveryStatusName) {
        this.recoveryStatusName = recoveryStatusName;
    }

    public void setChangeStatusName(String changeStatusName) {
        this.changeStatusName = changeStatusName;
    }

    public String getIsOnlineName() {
        return isOnlineName;
    }

    public void setIsOnlineName(String isOnlineName) {
        this.isOnlineName = isOnlineName;
    }

    public BigDecimal getRenewalPremiumTaxMny() {
        return renewalPremiumTaxMny;
    }

    public void setRenewalPremiumTaxMny(BigDecimal renewalPremiumTaxMny) {
        this.renewalPremiumTaxMny = renewalPremiumTaxMny;
    }


    public BigDecimal getRelievePremiumTaxMny() {
        return relievePremiumTaxMny;
    }

    public void setRelievePremiumTaxMny(BigDecimal relievePremiumTaxMny) {
        this.relievePremiumTaxMny = relievePremiumTaxMny;
    }

    public Long getFollowId() {
        return followId;
    }

    public void setFollowId(Long followId) {
        this.followId = followId;
    }

    public String getFollowStatus() {
        return followStatus;
    }

    public void setFollowStatus(String followStatus) {
        this.followStatus = followStatus;
    }

    public String getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(String importFlag) {
        this.importFlag = importFlag;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }
    @ReferDeserialTransfer
    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    public String getGuaranteePeriod() {
        return guaranteePeriod;
    }

    public void setGuaranteePeriod(String guaranteePeriod) {
        this.guaranteePeriod = guaranteePeriod;
    }


    public Date getRenewalApproveDate() {
        return renewalApproveDate;
    }

    public void setRenewalApproveDate(Date renewalApproveDate) {
        this.renewalApproveDate = renewalApproveDate;
    }

    public Date getRelieveApproveDate() {
        return relieveApproveDate;
    }

    public void setRelieveApproveDate(Date relieveApproveDate) {
        this.relieveApproveDate = relieveApproveDate;
    }

    public Date getProjectApproveDate() {
        return projectApproveDate;
    }

    public void setProjectApproveDate(Date projectApproveDate) {
        this.projectApproveDate = projectApproveDate;
    }

    public Date getProjectCreateDate() {
        return projectCreateDate;
    }

    public void setProjectCreateDate(Date projectCreateDate) {
        this.projectCreateDate = projectCreateDate;
    }

    public Date getApproveDate() {
        return approveDate;
    }

    public void setApproveDate(Date approveDate) {
        this.approveDate = approveDate;
    }
}
