package com.ejianc.business.guarantee.contract.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 合同、续保财务确认记录汇总
 * 
 * @author generator
 * 
 */
public class TotalFinanceVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者


    /**
     * 合同财务到账信息
     */
    private BigDecimal financeMny; // 保费金额
    private Integer financeReceive; // 保费是否到账(1-是 2-否)
    private Long contractId; // 合同id
    private BigDecimal financeReturnMny; // 反担保金额
    private Integer financeReturnReceive; // 反担保金额是否到账(1-是 2-否)
    private String financeRemark; // 备注

    /**
     * 续保财务到账信息
     */
    private Long renewalId; // 解保id
    private BigDecimal renewalMny; // 保费金额
    private Integer isReceive; // 是否到账(1-是 2-否)



    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getFinanceRemark() {
        return financeRemark;
    }

    public void setFinanceRemark(String financeRemark) {
        this.financeRemark = financeRemark;
    }

    public BigDecimal getFinanceMny() {
        return financeMny;
    }

    public void setFinanceMny(BigDecimal financeMny) {
        this.financeMny = financeMny;
    }
    public Integer getFinanceReceive() {
        return financeReceive;
    }

    public void setFinanceReceive(Integer financeReceive) {
        this.financeReceive = financeReceive;
    }
    @ReferSerialTransfer(referCode="ref-guarantee-contract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public BigDecimal getFinanceReturnMny() {
        return financeReturnMny;
    }

    public void setFinanceReturnMny(BigDecimal financeReturnMny) {
        this.financeReturnMny = financeReturnMny;
    }
    public Integer getFinanceReturnReceive() {
        return financeReturnReceive;
    }

    public void setFinanceReturnReceive(Integer financeReturnReceive) {
        this.financeReturnReceive = financeReturnReceive;
    }

    public Long getRenewalId() {
        return renewalId;
    }

    public void setRenewalId(Long renewalId) {
        this.renewalId = renewalId;
    }

    public BigDecimal getRenewalMny() {
        return renewalMny;
    }

    public void setRenewalMny(BigDecimal renewalMny) {
        this.renewalMny = renewalMny;
    }

    public Integer getIsReceive() {
        return isReceive;
    }

    public void setIsReceive(Integer isReceive) {
        this.isReceive = isReceive;
    }
}
