package com.ejianc.business.guarantee.contractChange.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.guarantee.contract.bean.ContractEntity;
import com.ejianc.business.guarantee.contract.service.IContractService;
import com.ejianc.business.guarantee.contractChange.bean.ContractHistoryEntity;
import com.ejianc.business.guarantee.contractChange.service.IContractHistoryService;
import com.ejianc.business.guarantee.contractChange.vo.ContractChangeVO;
import com.ejianc.business.guarantee.enums.ContractStatuesEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.guarantee.contractChange.mapper.ContractChangeMapper;
import com.ejianc.business.guarantee.contractChange.bean.ContractChangeEntity;
import com.ejianc.business.guarantee.contractChange.service.IContractChangeService;

import java.util.Arrays;
import java.util.List;

/**
 * 担保合同评审变更
 *
 * @author generator
 */
@Service("contractChangeService")
public class ContractChangeServiceImpl extends BaseServiceImpl<ContractChangeMapper, ContractChangeEntity> implements IContractChangeService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractHistoryService historyService;
    @Autowired
    private IAttachmentApi attachmentApi;

    private static final String BILL_CODE = "Guarantee_Contract_Change";//此处需要根据实际修改

    @Override
    public ContractChangeVO saveOrUpdate(ContractChangeVO saveOrUpdateVO) {
        ContractChangeEntity entity = BeanMapper.map(saveOrUpdateVO, ContractChangeEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();

        // 新增
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            //校验合同编号是否重复
            LambdaQueryWrapper<ContractChangeEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(ContractChangeEntity::getTenantId, tenantId);
            lambda.eq(ContractChangeEntity::getBillCode, entity.getBillCode());
            lambda.ne(ContractChangeEntity::getOldReviewId, entity.getOldReviewId());
            List<ContractChangeEntity> entityList = super.list(lambda);
            if (ListUtil.isNotEmpty(entityList)) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }

        }
        else {
            // 修改
            if(StringUtils.isEmpty(entity.getBillCode())){
                entity.setBillCode(null);
            }

            //校验合同编号是否重复
            LambdaQueryWrapper<ContractChangeEntity> lambda = new LambdaQueryWrapper<>();
            lambda.eq(ContractChangeEntity::getTenantId, tenantId);
            lambda.eq(ContractChangeEntity::getBillCode, entity.getBillCode());
            lambda.ne(ContractChangeEntity::getOldReviewId, entity.getOldReviewId());
            List<ContractChangeEntity> entityList = super.list(lambda);
            if (ListUtil.isNotEmpty(entityList)) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        super.saveOrUpdate(entity, false);

        // 回写主表
        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(ContractEntity::getChangeId, entity.getId());
        updateWrapper.set(ContractEntity::getChangeStatus, ContractStatuesEnum.变更中.getCode());
        updateWrapper.set(ContractEntity::getChangeCode, entity.getBillCode());
        updateWrapper.eq(ContractEntity::getId, entity.getOldReviewId());
        contractService.update(updateWrapper);

//        if(entity.getId() == null || entity.getId() == 0){
//        }
//        submit(entity);

        ContractChangeEntity contractChangeEntity = this.selectById(entity.getId());
        return BeanMapper.map(contractChangeEntity, ContractChangeVO.class);


    }

//    /**
//     * @Author Jiang
//     * @Date 2023年5月10日16:10:44
//     *
//     * @Descript 模拟提交后的过程
//     *
//     *      1.将原合同保存到变更历史
//     *      2.将变更单据回写到原合同
//     *      3.附件回写
//     *
//     */
//    private void submit(ContractChangeEntity entity) {
//        ContractChangeEntity contractChangeEntity = this.selectById(entity.getId());
//        //1.将原合同保存到变更历史
//        ContractEntity contractEntity = contractService.selectById(contractChangeEntity.getOldReviewId());
//        ContractHistoryEntity contractHistoryEntity = BeanMapper.map(contractEntity, ContractHistoryEntity.class);
//        contractHistoryEntity.setOldReviewId(contractEntity.getId());
//        contractHistoryEntity.setId(null);
//        historyService.saveOrUpdate(contractHistoryEntity);
//
//        //2.将变更单据回写到原合同
//
//        //2.1更改合同状态
//        contractEntity.setChangeStatus(ContractStatuesEnum.变更中.getCode());
//
//        //2.2合同信息
//        contractEntity.setChangeCode(contractChangeEntity.getBillCode());
//        contractEntity.setSelfCode(contractChangeEntity.getSelfCode());
//        contractEntity.setProjectId(contractChangeEntity.getProjectId());
//        contractEntity.setProjectName(contractChangeEntity.getProjectName());
//        contractEntity.setContractName(contractChangeEntity.getContractName());
//        contractEntity.setApplyArea(contractChangeEntity.getApplyArea());
//        contractEntity.setApplyAreaName(contractChangeEntity.getApplyAreaName());
//        contractEntity.setEmployeeId(contractChangeEntity.getEmployeeId());
//        contractEntity.setEmployeeName(contractChangeEntity.getEmployeeName());
//        contractEntity.setProjectAddress(contractChangeEntity.getProjectAddress());
//        contractEntity.setStartDate(contractChangeEntity.getStartDate());
//        contractEntity.setEndDate(contractChangeEntity.getEndDate());
//        contractEntity.setDuration(contractChangeEntity.getDuration());
//        contractEntity.setContractTaxMny(contractChangeEntity.getContractTaxMny());
//        contractEntity.setOwner(contractChangeEntity.getOwner());
//        contractEntity.setOwnerName(contractChangeEntity.getOwnerName());
//        contractEntity.setContractorId(contractChangeEntity.getContractorId());
//        contractEntity.setContractName(contractChangeEntity.getContractName());
//        contractEntity.setProjectType(contractChangeEntity.getProjectType());
//        contractEntity.setProjectTypeName(contractChangeEntity.getProjectTypeName());
//        contractEntity.setConstructProcedure(contractChangeEntity.getConstructProcedure());
//        contractEntity.setSourceFunds(contractChangeEntity.getSourceFunds());
//        contractEntity.setSourceFundsName(contractChangeEntity.getSourceFundsName());
//        contractEntity.setApplicant(contractChangeEntity.getApplicant());
//        contractEntity.setApplyAreaName(contractChangeEntity.getApplyAreaName());
//        contractEntity.setRegisterMny(contractChangeEntity.getRegisterMny());
//        contractEntity.setLitigationCases(contractChangeEntity.getLitigationCases());
//        contractEntity.setLegalPersonName(contractChangeEntity.getLegalPersonName());
//        contractEntity.setEstablishDate(contractChangeEntity.getEstablishDate());
//        contractEntity.setQualityLevelName(contractChangeEntity.getQualityLevelName());
//        contractEntity.setClient(contractChangeEntity.getClient());
//        contractEntity.setClientName(contractChangeEntity.getClientName());
//        contractEntity.setClientPhone(contractChangeEntity.getClientPhone());
//        contractEntity.setLitigationAddress(contractChangeEntity.getLitigationAddress());
//        contractEntity.setLitigationAddressName(contractChangeEntity.getLitigationAddressName());
//        contractEntity.setEnsureDuty(contractChangeEntity.getEnsureDuty());
//        contractEntity.setEnsureDutyName(contractChangeEntity.getEnsureDutyName());
//        contractEntity.setBaseTaxMny(contractChangeEntity.getBaseTaxMny());
//        contractEntity.setGuaranteeMnyPer(contractChangeEntity.getGuaranteeMnyPer());
//        contractEntity.setBasePremiumTaxMny(contractChangeEntity.getBasePremiumTaxMny());
//        contractEntity.setGuaranteeEffectDate(contractChangeEntity.getGuaranteeEffectDate());
//        contractEntity.setGuaranteeTermEndDate(contractChangeEntity.getGuaranteeTermEndDate());
//        contractEntity.setGuaranteeTermStartDate(contractChangeEntity.getGuaranteeTermStartDate());
//
////        //2.3记录变更历史编号
////        ContractHistoryEntity historyEntity = historyService.getOne(Wrappers.<ContractHistoryEntity>lambdaQuery()
////                .eq(ContractHistoryEntity::getChangeId, entity.getId())
////        );
////        contractChangeEntity.setHistoryId(historyEntity.getId());
////        contractChangeEntity.setHistoryCode(historyEntity.getBillCode());
//
//
//        //3.同步附件
//        logger.info("原合同同步附件");
//        //3.1将原合同附件同步到记录表中
//        CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
//                String.valueOf(contractChangeEntity.getId()), "ZZYJ202303230003", "guaranteeContractFile",
//                String.valueOf(contractEntity.getId()), "ZZYJ202305160002", "historyFile");
//        logger.info("原合同合同同步附件::::::::::::结果::" + JSONObject.toJSONString(response).toString());
//        //3.2将变更合同附件同步到原合同汇总
//        logger.info("变更合同同步附件");
//        CommonResponse<String> changeResponse = attachmentApi.copyFilesFromSourceBillToTargetBill(
//                String.valueOf(contractChangeEntity.getId()), "ZZYJ202305100001", "contractChangeFile",
//                String.valueOf(contractEntity.getId()), "ZZYJ202303230003", "guaranteeContractFile");
//        logger.info("变更合同同步附件::::::::::::结果::" + JSONObject.toJSONString(changeResponse).toString());
//        contractService.saveOrUpdate(contractEntity);
//    }

    @Override
    public List<ContractChangeVO> queryChangeRecord(Long id) {

        List<ContractChangeEntity> contractChangeEntities = this.list(Wrappers.<ContractChangeEntity>lambdaQuery()
                .in(ContractChangeEntity::getBillState, Arrays.asList(1, 3))
                .eq(ContractChangeEntity::getOldReviewId, id)
                .orderByDesc(ContractChangeEntity::getCreateTime)
        );

        List<ContractChangeVO> contractChangeVOS = BeanMapper.mapList(contractChangeEntities, ContractChangeVO.class);
        // 原合同
        ContractEntity contractEntity = contractService.selectById(id);
        int index = 1;
        //历史版本编号
        for (ContractChangeVO changeVO : contractChangeVOS) {
            changeVO.setHistoryCode(contractEntity.getBillCode() + "-" + index);
            index++;
        }
        return contractChangeVOS;
    }
}
